<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Services\Slug;
use Storage;



class SettingsController extends Controller
{


    public function __construct()
    {
        
    }

    /**
     * 

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Request $request)
    {
        $pageNumber = $request->input('page','1');
        $getRow = DB::table('settings')->first();
        return view('back.settings.settings',['page'=>$pageNumber,'currentRecord'=>$getRow]);
            }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
    
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $getRow = DB::table('settings')->first();
        

		

        $tt = $request->validate([
            'company_name' => 'required',
            'company_image' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
            'address1' => 'required',
            'city' => 'required',
            'state' => 'required',
            'phone1' => 'nullable',
            'phone2' => 'nullable',
            'email' => 'required|email',
            'website' => 'nullable',
            'twitterlink' => 'nullable',
            'pinterestlink' => 'nullable',
            'facebooklink' => 'nullable',
            'instagramlink' => 'nullable',
            'skypeid' => 'nullable',
			'linkedinlink' => 'nullable',
         
        ]);



        if($request->hasFile('company_image')){
            $n_image = $request->company_image;
            $imgOrigname = $n_image->getClientOriginalName();
            $imgOrigname_arr = explode('.',$imgOrigname);
            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();
            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;
            $n_image->storeAs('public/settings',$img_name);
            //Storage::delete("public/news/{$user->image}");
           
        }else{
            $img_name= $getRow->companylogo;
        }


       

             $updaterec = DB::table('settings')->where('id', $id)
            ->update(
            [
			
                'companyname' => $request->company_name,
                'companylogo' => $img_name,
                'address1' => $request->address1,
                'address2' => $request->address2,
                'city' => $request->city,
                'state' => $request->state,
                'phone1' => $request->phone1,
                'phone2' => $request->phone2,
                'email' => $request->email,
                'website' => $request->website,
                'updatedat' => $dateTime,
                'updatedby' => $userId,
              
                'twitterlink' => $request->twitterlink,
                'pinterestlink' => $request->pinterestlink,
                'facebooklink' => $request->facebooklink,
                'instagramlink' => $request->instagramlink,
				'linkedinlink' => $request->linkedinlink,
                'skypeid' => $request->skypeid,

            ]);
            
            $pageNumber = $request->input('page','1');

            if($updaterec > 0)
            {
                return redirect()->route('settings',['page'=>$pageNumber])->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('settings',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');
            }
            }


    
}
