<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\DB;
use App\Services\Slug;
use Storage;



class MenuController extends Controller
{
    private $cid;
    private $typ;
    private $page;
    private $querystring;



    public function __construct(Request $request)
    {
        $this->cid = $request->input('cid','0');
        $this->page = $request->input('page','1');
        $this->typ = 1;
        $this->querystring = array('cid'=>$this->cid, 'typ'=>$this->typ, 'page'=>$this->page);
    }

    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $recordToShow = 10;
        $querystring = $this->querystring;

        $recordList = DB::table('content_management')->where('typ',$this->typ)->where('cid',$this->cid)->orderBy('showorder','asc')->orderBy('created_at','desc')->paginate($recordToShow);
		
		if($this->cid > 0)
		{
			$parentLoop = $this->getParentDetails($this->cid);
			ksort($parentLoop);
		}else
		{
			$parentLoop = array();
		}
		
        $catRow = DB::table('content_categories')->where('id',$this->typ)->first();

        return view('back.menu.list',compact('recordList','catRow','recordToShow','querystring','parentLoop'));
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create(Request $request)
    {
        $querystring = $this->querystring;
        $catRow = DB::table('content_categories')->where('id',$this->typ)->first();
        return view('back.menu.add',['catRow'=>$catRow,'querystring'=>$querystring]);
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $querystring = $this->querystring;

        $request->validate([
            'title' => 'required',
            'image1' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
            'attachment1' => 'nullable|mimes:doc,docx,pdf|max:1999',
        ]);


        if($request->hasFile('image1')){
            $n_image1 = $request->image1;
            $imgOrigname1 = $n_image1->getClientOriginalName();
            $imgOrigname1_arr1 = explode('.',$imgOrigname1);
            $img_name_first1 = str_replace(' ','_',$imgOrigname1_arr1[0]);
            $img_name_first1 = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first1);

            $ext = $n_image1->getClientOriginalExtension();
            $img_name1 = date('YmdH').$img_name_first1.uniqid().'.'.$ext;
            $n_image1->storeAs('public/pages',$img_name1);
            //Storage::delete("public/pages/{$user->image}");
           
        }else{
            $img_name1='';
        }



        if($request->hasFile('attachment1')){
            $n_attach1 = $request->attachment1;
            $attachOrigName1 = $n_attach1->getClientOriginalName();
            $attachOrigName1_arr = explode('.',$attachOrigName1);
            $attach_name_first1 = str_replace(' ', '_', $attachOrigName1_arr[0]);
            $attach_name_first1 = preg_replace('/[^a-zA-z0-9\-]/', '', $attach_name_first1);

            $ext = $n_attach1->getClientOriginalExtension();
            $attach_name1 = date('YmdH').$attach_name_first1.uniqid().'.'.$ext;
            $n_attach1->storeAs('public/pages/',$attach_name1);
        }else{
            $attach_name1 = "";
        }

        $n_title = $request->title;
        $n_desc = $request->description;
        $n_img1 = $img_name1;

        $slugClass = new Slug();
        $creeatedSlug = $slugClass->createSlug('content_management', 'slug', $n_title);

        
            $slug = $creeatedSlug;
            $title = $n_title;
            $description = $n_desc;
            $image1 = $n_img1;
            $attachment = $attach_name1; 
            $link = ($request->link)? $request->link : '';
            $date = ($request->date)? date('Y-m-d H:i:s',strtotime($request->date)) : NULL;
            $status = $request->status;
         
            $minimumnorderId = 1;
            $getmaxNOrderId = DB::table('content_management')->where('typ',$this->typ)->where('cid',$this->cid)->max('showorder');
            $getmaxNOrderId = ($getmaxNOrderId >= $minimumnorderId)? $getmaxNOrderId : $minimumnorderId;
            $getmaxNOrderId = $getmaxNOrderId + 1;
            $order = $getmaxNOrderId;

            $meta_title = ($request->meta_title!="")? $request->meta_title : '';
            $meta_description = ($request->meta_description!="")? $request->meta_description : '';
            $meta_keywords = ($request->meta_keywords!="")? $request->meta_keywords : '';


           
        $insrec = DB::table('content_management')->insertGetId(
            [
                'cid' => $this->cid,
                'typ' => $this->typ,
                'slug' => $slug,
                'title' => $title,
                'description' => $description,
                'img1' => $image1,
                'link' => $link,
                'attachment1' => $attach_name1,
                'show_date' => $date,
                'status' => $status,
                'showorder' => $order,
                'created_at' => $dateTime,
                'updated_at' => $dateTime,
                'created_by' => $userId,
                'updated_by' => $userId,
                'meta_title' => $meta_title,
                'meta_description' => $meta_description,
                'meta_keywords' => $meta_keywords
            ]);
            
            if($insrec > 0)
            {
                return redirect()->route('menu-list',['cid'=>$querystring['cid'],'page'=>$querystring['page']])->with('success', 'Record added successfully.');
            }else{
                return redirect()->route('menu-list',['cid'=>$querystring['cid'],'page'=>$querystring['page']])->with('error', 'Error occurred.Please Try Again Later.');
            }
        

        

        
        


        



    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        $getRow = DB::table('content_management')->where('id',$id)->first();
       
        $catRow = DB::table('content_categories')->where('id',$this->typ)->first();

        return view('back.menu.view',['catRow'=>$catRow,'currentRecord'=>$getRow]);
                   
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $pageNumber = $request->input('page','1');
        $getRow = DB::table('content_management')->where('id',$id)->first();
        $catRow = DB::table('content_categories')->where('id',$this->typ)->first();
        return view('back.menu.edit',['catRow'=>$catRow,'currentRecord'=>$getRow,'page'=>$pageNumber]);
            }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $getRow = DB::table('content_management')->where('id',$id)->first();
        
        

        $request->validate([
            'title' => 'required',
            'image1' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
            'attachment1' => 'nullable|mimes:doc,docx,pdf|max:1999',
        ]);


        if($request->hasFile('image1')){
            $n_image1 = $request->image1;
            $imgOrigname1 = $n_image1->getClientOriginalName();
            $imgOrigname1_arr1 = explode('.',$imgOrigname1);
            $img_name_first1 = str_replace(' ','_',$imgOrigname1_arr1[0]);
            $img_name_first1 = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first1);

            $ext = $n_image1->getClientOriginalExtension();
            $img_name1 = date('YmdH').$img_name_first1.uniqid().'.'.$ext;
            $n_image1->storeAs('public/pages',$img_name1);
            //Storage::delete("public/pages/{$user->image}");
           
        }else{
            $img_name1= $getRow->img1;
        }



        if($request->hasFile('attachment1')){
            $n_attach1 = $request->attachment1;
            $attachOrigName1 = $n_attach1->getClientOriginalName();
            $attachOrigName1_arr = explode('.',$attachOrigName1);
            $attach_name_first1 = str_replace(' ', '_', $attachOrigName1_arr[0]);
            $attach_name_first1 = preg_replace('/[^a-zA-z0-9\-]/', '', $attach_name_first1);

            $ext = $n_attach1->getClientOriginalExtension();
            $attach_name1 = date('YmdH').$attach_name_first1.uniqid().'.'.$ext;
            $n_attach1->storeAs('public/pages/',$attach_name1);
        }else{
            $attach_name1 = $getRow->attachment1;
        }

        $n_title = $request->title;
        $n_desc = $request->description;
        $n_img1 = $img_name1;

        if ($getRow->slug_edit_allowed == 1 && $getRow->title != $n_title) {
        $slugClass = new Slug();
            $creeatedSlug = $slugClass->createSlug('content_management', 'slug', $n_title);
        }else{
            $creeatedSlug = $getRow->slug;
        }
        
            $slug =  $creeatedSlug;
            $title = $n_title;
            $description = $n_desc;
            $image1 = $n_img1;
            $attachment1 = $attach_name1; 
            $link = ($request->link)? $request->link : '';
            $date = ($request->date)? date('Y-m-d H:i:s',strtotime($request->date)) : NULL;
            $status = $request->status;
            if($request->new_icon==1)
            {
                $new_icon = 1;

            }else{
                $new_icon = 0;
            }
            
            $meta_title = ($request->meta_title!="")? $request->meta_title : '';
            $meta_description = ($request->meta_description!="")? $request->meta_description : '';
            $meta_keywords = ($request->meta_keywords!="")? $request->meta_keywords : '';


        $updaterec = DB::table('content_management')->where('id', $id)->update([
                'slug' => $slug,
                'title' => $title,
                'description' => $description,
                'img1' => $image1,
                'link' => $link,
                'attachment1' => $attach_name1,
                'show_date' => $date,
                'status' => $status,
                'updated_at' => $dateTime,
                'updated_by' => $userId,
                'meta_title' => $meta_title,
                'meta_description' => $meta_description,
                'meta_keywords' => $meta_keywords
            ]);
            
            $querystring = $this->querystring;
            $querystring['cid'] = $getRow->cid;

            if($updaterec > 0)
            {
                return redirect()->route('menu-list',['cid'=>$querystring['cid'],'page'=>$querystring['page']])->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('menu-list',['cid'=>$querystring['cid'],'page'=>$querystring['page']])->with('error', 'Error occurred.Please Try Again Later.');
            }
        

    }


    public function updateStatus(Request $request)
    {
       if($request->has('chid') && $request->has('chtyp'))
       {
        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 
        {
            
            $update = DB::update('update content_management set status = ? where id = ?', [$request->chtyp, $request->chid]);
            if($update > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }   
       }else
       {
            $msg = "Error occured.";
            $sts = 201;
       }

       $results=array("msg"=>$msg,"status"=>$sts);
       return response()->json($results);

    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {   
        if($id > 0)
        {
            $getRow = DB::table('content_management')->where('id',$id)->first();

            Storage::delete("public/pages/{$getRow->img1}");
            Storage::delete("public/pages/{$getRow->attachment1}");
            
            $updateorder = DB::table('content_management')->where('cid',$getRow->cid)->where('typ',$getRow->typ)->where('showorder','>',$getRow->showorder)->update(['showorder' => DB::raw('showorder-1')]);

            $delete = DB::table('content_management')->where('id',$id)->where('typ',$this->typ)->delete();
            if($delete > 0)
            {
                $msg = "Successfully updated";
                $sts = 200;
            }else{
                $msg = "Error occured.";
                $sts = 201;
            }
        }else{
            $msg = "Error occured.";
            $sts = 201;
        }
        $results=array("msg"=>$msg,"status"=>$sts);
        return response()->json($results);
 
    }
	
	
	public function getParentDetails($id, $currarray=array())
	{
		$recordList = DB::table('content_management')->select('id', 'title','cid')->where('typ',$this->typ)->where('id',$id)->first();
		$currarray[$recordList->cid] = array('id'=>$recordList->id,'title'=>$recordList->title);
		if($recordList->cid == 0)
		{
 			return $currarray;
		}else
		{
			return $this->getParentDetails($recordList->cid, $currarray);
		}
		
		
	}


    
}
