<?php



namespace App\Http\Controllers\Admin;



use Illuminate\Http\Request;

use App\Http\Controllers\Controller;

use Illuminate\Support\Facades\DB;

use App\Services\Slug;

use Storage;







class BrandController extends Controller

{





    public function __construct()

    {

        

    }

	

	

	

	  public function index()

    {

			



        $recordToShow = 25;

        $brandList = DB::table('brand')->orderBy('created_at','desc')->paginate($recordToShow);

     

        return view('back.brand.brand',compact('brandList','recordToShow'));

    }

	

 public function create()

    {

      

		

        return view('back.brand.brand-add');

    }	

	

	public function store(Request $request)

    {

	

        $dateTime = date('Y-m-d H:i:s');

       $userId = auth()->user()->id;

		

               $title=$request->title;

			   $blink=$request->blink;

               

		         $status=$request->status;

$m_title=$request->meta_title;
	$m_key=$request->meta_keywords;
	$m_des=$request->meta_description;



	$slugClass = new Slug();

        $createdSlug = $slugClass->createSlug('brand', 'brand_slug', $title);

		

		if($request->hasFile('brandimage'))

		{

		

			$bimage = $request->file('brandimage');

            $imgOrigname = $bimage->getClientOriginalName();

            $imgOrigname_arr = explode('.',$imgOrigname);

            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);

            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $bimage->getClientOriginalExtension();

             $img_name1 = date('YmdH').$img_name_first.uniqid().'.'.$ext;

               $bimage->storeAs('public/brand',$img_name1);

			

		

		}  		





           

        $insrec = DB::table('brand')->insertGetId(

            [

                'name' => $title,

				'link'=>$blink,

				'brand_slug'=>$createdSlug,

                'status' =>$status,

			'image'=>$img_name1,
'meta_title'=>$m_title,
			'meta_keywords'=>$m_key,
			'meta_description'=>$m_des,

                'created_at' =>$dateTime,

                'updated_at' =>$dateTime,

                'created_by' =>$userId,

                'updated_by' =>$userId

                  ]);

            

            if($insrec > 0)

            {

		

                return redirect()->route('brand-list')->with('success', 'Record added successfully.');

            }else{

                return redirect()->route('brand-list')->with('error', 'Error occurred.Please Try Again Later.');

            }

       



    }



	

	

	

	    public function show($id)



    {



        $getRow = DB::table('brand')->where('id',$id)->first();

	

        return view('back.brand.brand-view',['currentRecord'=>$getRow]);



                   



    }







    /**



     * Show the form for editing the specified resource.



     *



     * @param  int  $id



     * @return \Illuminate\Http\Response



     */



    public function edit($id, Request $request)



    {



        $pageNumber = $request->input('page','1');



        $getRow = DB::table('brand')->where('id',$id)->first();   

		

		

		

        return view('back.brand.brand-edit',['currentRecord'=>$getRow,'page'=>$pageNumber]);



            }







public function destroy($id)



    {   



        if($id > 0)



        {



            $getRow = DB::table('brand')->where('id',$id)->first();



            $delete = DB::table('brand')->where('id',$id)->delete();



            if($delete > 0)



            {



                $msg = "Successfully updated";



                $sts = 200;



            }else{



                $msg = "Error occured.";



                $sts = 201;



            }



        }else{



            $msg = "Error occured.";



            $sts = 201;



        }



        $results=array("msg"=>$msg,"status"=>$sts);



        return response()->json($results);



 



    }

	

	public function updateStatus(Request $request)



    {



       if($request->has('chid') && $request->has('chtyp'))



       {



        if($request->chid > 0 && $request->chtyp >= 0 && ($request->chtyp == 1 || $request->chtyp == 2 || $request->chtyp == 0) ) 



        {



            



            $update = DB::update('update brand set status = ? where id = ?', [$request->chtyp, $request->chid]);



            if($update > 0)



            {



                $msg = "Successfully updated";



                $sts = 200;



            }else{



                $msg = "Error occured.";



                $sts = 201;



            }



        }else{



            $msg = "Error occured.";



            $sts = 201;



        }   



       }else



       {



            $msg = "Error occured.";



            $sts = 201;



       }







       $results=array("msg"=>$msg,"status"=>$sts);



       return response()->json($results);







    }













public function update(Request $request, $id)



    {





        $dateTime = date('Y-m-d H:i:s');



        $userId = auth()->user()->id;



        $getRow = DB::table('brand')->where('id',$id)->first();



        if($request->hasFile('image')){



            $n_image = $request->image;



            $imgOrigname = $n_image->getClientOriginalName();



            $imgOrigname_arr = explode('.',$imgOrigname);



            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);



            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);







            $ext = $n_image->getClientOriginalExtension();



            $img_name = date('YmdH').$img_name_first.uniqid().'.'.$ext;



            $n_image->storeAs('public/brand',$img_name);



        }else{



            $img_name=$getRow->image;



        }

		  

		

          $title=$request->name;

         $blink=$request->blink;

$m_title=$request->meta_title;
	$m_key=$request->meta_keywords;
	$m_des=$request->meta_description;

        $updaterec = DB::table('brand')->where('id', $id)



            ->update(



            [



                'name' =>$title,

'image'=> $img_name,

               'link'=>$blink,

				  

                'status' => $request->status,

				'meta_title'=>$m_title,
			'meta_keywords'=>$m_key,
			'meta_description'=>$m_des,

                'created_at' =>$dateTime,



                'updated_at' =>$dateTime,



                'created_by' =>$userId,



                'updated_by' =>$userId,               





            ]);



           

            $pageNumber = $request->input('page','1');







            if($updaterec > 0)



            {



                return redirect()->route('brand-list',['page'=>$pageNumber])->with('success', 'Record updated successfully.');



            }else{



                return redirect()->route('brand-list',['page'=>$pageNumber])->with('error', 'Error occurred.Please Try Again Later.');



            }



       }





    }

    

    

    

?>