<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Rules\MatchOldPassword;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\DB;
use App\Services\Slug;
use Storage;


class AdminProfileController extends Controller
{


    public function __construct()
    {
        
    }


    
    public function edit()
    {
		$userId = auth()->user()->id;
		$userRec = DB::table('users')->where('id',$userId)->first();
        return view('back.adminprofile.profile-edit',compact('userRec'));
    }

 
    public function update(Request $request)
    {
        //echo $id;die();
        $dateTime = date('Y-m-d H:i:s');
        $userId = auth()->user()->id;
        $userRec = DB::table('users')->where('id',$userId)->first();
        
        $request->validate([
			'u_name' => 'required',
            'u_email' => 'required|email',
			'u_profile' => 'nullable|image|max:1999|mimes:jpeg,jpg,png',
            ]);


        $u_name = $request->u_name;
        $u_email = $request->u_email;
		$u_phone = $request->u_phone;
        $u_profile = $request->u_profile;


		if($request->hasFile('u_profile')){
            $n_image = $request->u_profile;
            $imgOrigname = $n_image->getClientOriginalName();
            $imgOrigname_arr = explode('.',$imgOrigname);
            $img_name_first = str_replace(' ','_',$imgOrigname_arr[0]);
            $img_name_first = preg_replace('/[^A-Za-z0-9\-]/','',$img_name_first);

            $ext = $n_image->getClientOriginalExtension();
            $img_name = "usrprof".date('YmdH').$img_name_first.uniqid().'.'.$ext;
            $n_image->storeAs('public/profile',$img_name);
            //Storage::delete("public/blog/{$user->image}");
        }else{
            $img_name=$userRec->avatar;
        }

        
		 $userId = auth()->user()->id;
        $updaterec = DB::table('users')->where('id', $userId)
            ->update(
            [
				'name' => $u_name?:"",
                'phone' => $u_phone?:"",
                'contact_email' => $u_email?:"",
                'avatar' => $img_name,
                'updated_at' => $dateTime
           ]);

            if($updaterec > 0)
            {
                return redirect()->route('profile-edit')->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('profile-edit')->with('error', 'Error occurred.Please Try Again Later.');
            }
        

    }



	public function changepassword()
    {
		$userId = auth()->user()->id;
		$userRec = DB::table('users')->where('id',$userId)->first();
        return view('back.adminprofile.change-password',compact('userRec'));
    }

 
    public function updatepassword(Request $request)
    {
		 $request->validate([
            'current_password' => ['required'],
            'new_password' => ['required'],
            'new_confirm_password' => ['same:new_password'],
        ]);
   
			$dateTime = date('Y-m-d H:i:s');
	   
			$userId = auth()->user()->id;
			$updaterec = DB::table('users')->where('id', $userId)
				->update(
				[
					'password' => Hash::make($request->new_password),
					'updated_at' => $dateTime
			   ]);
	
            if($updaterec > 0)
            {
                return redirect()->route('change-password')->with('success', 'Record updated successfully.');
            }else{
                return redirect()->route('change-password')->with('error', 'Error occurred.Please Try Again Later.');
            }
        

    }

   

} 