<?php



/**

 * Define the internationalization functionality

 *

 * Loads and defines the internationalization files for this plugin

 * so that its ready for translation.

 *

 * @link       http://example.com

 * @since      1.1.5

 *

 * @package    Custom_Widget_Area

 * @subpackage Custom_Widget_Area/includes

 */



/**

 * Define the internationalization functionality.

 *

 * Loads and defines the internationalization files for this plugin

 * so that its ready for translation.

 *

 * @since      1.1.5

 * @package    Custom_Widget_Area

 * @subpackage Custom_Widget_Area/includes

 * @author     Your Name <email@example.com>

 */

class Custom_Widget_Area_i18n {



	/**

	 * The domain specified for this plugin.

	 *

	 * @since    1.1.5

	 * @access   private

	 * @var      string    $domain    The domain identifier for this plugin.

	 */

	private $domain;



	/**

	 * Load the plugin text domain for translation.

	 *

	 * @since    1.1.5

	 */

	public function load_plugin_textdomain() {



		load_plugin_textdomain(

			$this->domain,

			false,

			dirname( dirname( plugin_basename( __FILE__ ) ) ) . '/languages/'

		);



	}



	/**

	 * Set the domain equal to that of the specified domain.

	 *

	 * @since    1.1.5

	 * @param    string    $domain    The domain that represents the locale of this plugin.

	 */

	public function set_domain( $domain ) {

		$this->domain = $domain;

	}



}

