<?php



/**

 * The file that defines the core plugin class

 *

 * A class definition that includes attributes and functions used across both the

 * public-facing side of the site and the dashboard.

 *

 * @link       http://example.com

 * @since      1.1.5

 *

 * @package    Custom_Widget_Area

 * @subpackage Custom_Widget_Area/includes

 */



/**

 * The core plugin class.

 *

 * This is used to define internationalization, dashboard-specific hooks, and

 * public-facing site hooks.

 *

 * Also maintains the unique identifier of this plugin as well as the current

 * version of the plugin.

 *

 * @since      1.1.5

 * @package    Custom_Widget_Area

 * @subpackage Custom_Widget_Area/includes

 * @author     Your Name <email@example.com>

 */

class Custom_Widget_Area {



	/**

	 * The loader that's responsible for maintaining and registering all hooks that power

	 * the plugin.

	 *

	 * @since    1.1.5

	 * @access   protected

	 * @var      Custom_Widget_Area_Loader    $loader    Maintains and registers all hooks for the plugin.

	 */

	protected $loader;



	/**

	 * The unique identifier of this plugin.

	 *

	 * @since    1.1.5

	 * @access   protected

	 * @var      string    $plugin_name    The string used to uniquely identify this plugin.

	 */

	protected $plugin_name;



	/**

	 * The current version of the plugin.

	 *

	 * @since    1.1.5

	 * @access   protected

	 * @var      string    $version    The current version of the plugin.

	 */

	protected $version;



	/**

	 * Define the core functionality of the plugin.

	 *

	 * Set the plugin name and the plugin version that can be used throughout the plugin.

	 * Load the dependencies, define the locale, and set the hooks for the Dashboard and

	 * the public-facing side of the site.

	 *

	 * @since    1.1.5

	 */

	public function __construct() {



		$this->plugin_name = 'wp-custom-widget-area';

		$this->version = KZ_DB_VERSION;



		$this->load_dependencies();

		$this->set_locale();

		$this->define_admin_hooks();

		$this->register_shortcode();



	}



	/**

	 * Load the required dependencies for this plugin.

	 *

	 * Include the following files that make up the plugin:

	 *

	 * - Custom_Widget_Area_Loader. Orchestrates the hooks of the plugin.

	 * - Custom_Widget_Area_i18n. Defines internationalization functionality.

	 * - Custom_Widget_Area_Admin. Defines all hooks for the dashboard.

	 * - Custom_Widget_Area_Public. Defines all hooks for the public side of the site.

	 *

	 * Create an instance of the loader which will be used to register the hooks

	 * with WordPress.

	 *

	 * @since    1.1.5

	 * @access   private

	 */

	private function load_dependencies() {



		/**

		 * The class responsible for orchestrating the actions and filters of the

		 * core plugin.

		 */

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wp-custom-widget-area-loader.php';



		/**

		 * The class responsible for defining internationalization functionality

		 * of the plugin.

		 */

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'includes/class-wp-custom-widget-area-i18n.php';



		/**

		 * The class responsible for defining all actions that occur in the Dashboard.

		 */

		require_once plugin_dir_path( dirname( __FILE__ ) ) . 'admin/class-wp-custom-widget-area-admin.php';



		



		$this->loader = new Custom_Widget_Area_Loader();



	}



	/**

	 * Define the locale for this plugin for internationalization.

	 *

	 * Uses the Custom_Widget_Area_i18n class in order to set the domain and to register the hook

	 * with WordPress.

	 *

	 * @since    1.1.5

	 * @access   private

	 */

	private function set_locale() {



		$plugin_i18n = new Custom_Widget_Area_i18n();

		$plugin_i18n->set_domain( $this->get_plugin_name() );



		$this->loader->add_action( 'plugins_loaded', $plugin_i18n, 'load_plugin_textdomain' );



	}



	/**

	 * Register all of the hooks related to the dashboard functionality

	 * of the plugin.

	 *

	 * @since    1.1.5

	 * @access   private

	 */

	private function define_admin_hooks() {



		$plugin_admin = new Custom_Widget_Area_Admin( $this->get_plugin_name(), $this->get_version() );

		$this->loader->add_action( 'admin_menu', $plugin_admin, 'menu_setup' );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_styles' );

		$this->loader->add_action( 'admin_enqueue_scripts', $plugin_admin, 'enqueue_scripts' );



	}



	private function register_shortcode() {

		add_shortcode( 'cwa', array($this, 'cwa_short') );

		add_shortcode( 'menu', array($this, 'menu_short') );

		//exit;



	}



	public function cwa_short($attr){

		//var_dump($attr);

		ob_start();

		dynamic_sidebar( $attr['id'] );

		$output = ob_get_contents();

		ob_end_clean();

		return $output;

	}



	public function menu_short($attr){

		//var_dump($attr);

		$args = array();

		foreach ($attr as $key => $value) {

			# code...

			$args[$key] = $value;

		}

		$args['fallback_cb'] = isset($args['fallback_cb'])? $args['fallback_cb'] : false ;

		

		ob_start();

		wp_nav_menu( $args );

		$output = ob_get_contents();

		ob_end_clean();

		return $output;

	}



	/**

	 * Run the loader to execute all of the hooks with WordPress.

	 *

	 * @since    1.1.5

	 */

	public function run() {

		$this->loader->run();

	}



	/**

	 * The name of the plugin used to uniquely identify it within the context of

	 * WordPress and to define internationalization functionality.

	 *

	 * @since     1.1.5

	 * @return    string    The name of the plugin.

	 */

	public function get_plugin_name() {

		return $this->plugin_name;

	}



	/**

	 * The reference to the class that orchestrates the hooks with the plugin.

	 *

	 * @since     1.1.5

	 * @return    Custom_Widget_Area_Loader    Orchestrates the hooks of the plugin.

	 */

	public function get_loader() {

		return $this->loader;

	}



	/**

	 * Retrieve the version number of the plugin.

	 *

	 * @since     1.1.5

	 * @return    string    The version number of the plugin.

	 */

	public function get_version() {

		return $this->version;

	}



}

