<?php
date_default_timezone_set("Asia/Kolkata");
?>
<html>
<head>
<style>
/** 
                Set the margins of the page to 0, so the footer and the header
                can be of the full height and width !
             **/
            @page {
 margin: 0cm 0cm;
}
/** Define now the real margins of every page in the PDF **/
            body {
	margin-top: 2cm;
	margin-left: 2cm;
	margin-right: 2cm;
	margin-bottom: 2cm;
}
/** Define the header rules **/
           header {
	position: fixed;
	top: 0cm;
	left: 0cm;
	right: 0cm;
	height: 2cm;
	/** Extra personal styles **/
                background-color: #ffffff;
	color: white;
	text-align: center;
	line-height: 1.5cm;
	text-align: left;
	padding-left:80px;
}
/** Define the footer rules **/
            footer {
	position: fixed;
	bottom: 0cm;
	left: 0cm;
	right: 0cm;
	height: 3cm;
	/** Extra personal styles **/
                background-color: #F60;
	color: #ffffff;
	text-align: left;
	padding-left:80px;
	/*border-top: 1px solid #000000;*/ font-size:14px;
}
#footer .page:after {
	content: counter(page, upper-roman);
}
.page-break {
	page-break-after: always;
}
td {
	font-size:14px;
}
.content2 {
	word-wrap:break-word; /*old browsers*/
	overflow-wrap:break-word;
}
.overflow-wrap-hack {
	max-width:1px;
}
</style>
</head>
<body>
<header>
  <p align="left"><img src="{{url('user/images/logo.png')}}" alt="logo"> <br>
  </p>
</header>
<footer>
  <p>{{ucfirst($meeting_by->meeting_name)}}<br>
  <p>Session hosted by leancoffeebrew on
    @if($dfinfo == 1)
    {{ \Carbon\Carbon::parse($meeting_by->meeting_date_created)->format('F d, Y')}}
    @elseif($dfinfo == 2)
    {{ \Carbon\Carbon::parse($meeting_by->meeting_date_created)->format('m/d/Y')}}
    @elseif($dfinfo == 3)
    {{ \Carbon\Carbon::parse($meeting_by->meeting_date_created)->format('d/m/Y')}}
    @else
    {{ \Carbon\Carbon::parse($meeting_by->meeting_date_created)->format('Y/m/d')}}                                
    @endif<br>
    <br>
    www.leancoffeebrew.com </p>
</footer>
<!-- Wrap the content of your PDF inside a main tag -->
<main>
  <table width="100%" cellpadding="5">
    <tr>
      <td align="center"><span style="color:#F60; font-size:20px;">{{ucfirst($meeting_by->meeting_name)}}</span></td>
    </tr>
    @if($datedetails == 0)
    <tr>
      <td align="left"> Date : 
        @if($dfinfo == 1)
        {{ \Carbon\Carbon::parse($meeting_by->meeting_date_created)->format('F d, Y')}}
        @elseif($dfinfo == 2)
        {{ \Carbon\Carbon::parse($meeting_by->meeting_date_created)->format('m/d/Y')}}
        @elseif($dfinfo == 3)
        {{ \Carbon\Carbon::parse($meeting_by->meeting_date_created)->format('d/m/Y')}}
        @else
        {{ \Carbon\Carbon::parse($meeting_by->meeting_date_created)->format('Y/m/d')}}                                
        @endif
        - All items on the board.</td>
    </tr>
    @else
    <tr>
      <td align="left">Date : {{$s_date}} - {{$e_date}}</td>
    </tr>
    @endif
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td align="left"><span style="color:#F60">Barista</span><br />
        {{ucfirst($barista_info->user_name)}}</td>
    </tr>
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td align="left"><span style="color:#F60">Participants (attended the meeting)</span><br />
        <br />
        @foreach($par_info as $pinfo) <img src="{{url('user/images/tick.png')}}" alt="tick" >&nbsp;{{$pinfo->remailid}}<br />
        @endforeach
        <?php if(count($par_info) == 0) { echo "Sorry no attended participants.";?>
        <?php } ?>
      </td>
    </tr>
    <?php if(count($par_info_removed) != 0) { ?>
    <tr>
      <td align="left"><span style="color:#F60">Participants (removed from the meeting)</span><br />
        <br />
        @foreach($par_info_removed as $pinfo) <img src="{{url('user/images/wrong.jpg')}}" alt="wrong" >&nbsp;{{$pinfo->remailid}}<br />
        @endforeach </td>
    </tr>
    <?php } ?>
    <?php if(count($par_info_not) != 0) {  ?>
    <tr>
      <td align="left"><span style="color:#F60">Participants (not attended the meeting)</span><br />
        <br />
        @foreach($par_info_not as $pinfo) <img src="{{url('user/images/warning.jpg')}}" alt="warning" >&nbsp;{{$pinfo->remailid}}<br />
        @endforeach </td>
    </tr>
    <?php } ?>
    <tr>
      <td>&nbsp;</td>
    </tr>
    @if($guest_count != 0)
    <tr>
      <td align="left"><span style="color:#F60">Guests (attended the meeting)</span><br />
        <br />
        @foreach($guest_info as $ginfo) <img src="{{url('user/images/tick.png')}}" alt="tick" >&nbsp;Guest name - {{$ginfo->user_name}}<br />
        @endforeach </td>
    </tr>
    @if(count($guest_info_removed) != 0)
    <tr>
      <td align="left"><span style="color:#F60">Guests (removed from the meeting)</span><br />
        <br />
        @foreach($guest_info_removed as $ginfo) <img src="{{url('user/images/wrong.jpg')}}" alt="wrong">&nbsp;Guest name - {{$ginfo->user_name}}<br />
        @endforeach </td>
    </tr>
    @endif
    
    @endif
    
    
    @if($ainfo != '')
    <tr>
      <td>&nbsp;</td>
    </tr>
    <tr>
      <td align="left"><span style="color:#F60">Summary</span><br />
        {{$ainfo}} </td>
    </tr>
    @endif
    <tr>
      <td><div class="page-break"></div></td>
    </tr>
    <tr>
      <td></td>
    </tr>
    <tr>
      <td align="left"><span style="font-size:24px;">{{$meeting_by->row_title1}}</span></td>
    </tr>
    <tr>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($c1) != 0) 
              @foreach($c1 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c2) != 0) 
              @foreach($c2 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c3) != 0) 
              @foreach($c3 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c4) != 0) 
              @foreach($c4 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c5) != 0) 
              @foreach($c5 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c6) != 0) 
              @foreach($c6 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c7) != 0) 
              @foreach($c7 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c8) != 0) 
              @foreach($c8 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c9) != 0) 
              @foreach($c9 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c10) != 0) 
              @foreach($c10 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <tr>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($meeting_by->rowstatus == '1') style="display:none" @endif>
      <td align="left"><span style="font-size:24px;">{{$meeting_by->row_title2}}</span></td>
    </tr>
    <tr @if($meeting_by->rowstatus == '1') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($c11) != 0) 
              @foreach($c11 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c12) != 0) 
              @foreach($c12 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c13) != 0) 
              @foreach($c13 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c14) != 0) 
              @foreach($c14 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c15) != 0) 
              @foreach($c15 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c16) != 0) 
              @foreach($c16 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c17) != 0) 
              @foreach($c17 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c18) != 0) 
              @foreach($c18 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c19) != 0) 
              @foreach($c19 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c20) != 0) 
              @foreach($c20 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    
 <tr>
      <td><div class="page-break"></div></td>
    </tr>
    <tr >
      <td align="left"><span style="font-size:24px;">{{$meeting_by->row_title3}}</span></td>
    </tr>
    <tr>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($c21) != 0) 
              @foreach($c21 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c22) != 0) 
              @foreach($c22 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c23) != 0) 
              @foreach($c23 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c24) != 0) 
              @foreach($c24 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c25) != 0) 
              @foreach($c25 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c26) != 0) 
              @foreach($c26 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c27) != 0) 
              @foreach($c27 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c28) != 0) 
              @foreach($c28 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c29) != 0) 
              @foreach($c29 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($c30) != 0) 
              @foreach($c30 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    
        
    <!-- Release 1 starts here -->
    <tr>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[0]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[0]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[0]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row1) != 0) 
              @foreach($row1 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>
              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row2) != 0) 
              @foreach($row2 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row3) != 0) 
              @foreach($row3 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row4) != 0) 
              @foreach($row4 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row5) != 0) 
              @foreach($row5 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row6) != 0) 
              @foreach($row6 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row7) != 0) 
              @foreach($row7 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row8) != 0) 
              @foreach($row8 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row9) != 0) 
              @foreach($row9 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row10) != 0) 
              @foreach($row10 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 1 ends here -->
    
    <!-- Release 2 starts here -->
    <tr @if($releaseinfos[1]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[1]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[1]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[1]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row11) != 0) 
              @foreach($row11 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row12) != 0) 
              @foreach($row12 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row13) != 0) 
              @foreach($row13 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row14) != 0) 
              @foreach($row14 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row15) != 0) 
              @foreach($row15 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row16) != 0) 
              @foreach($row16 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row17) != 0) 
              @foreach($row17 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row18) != 0) 
              @foreach($row18 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row19) != 0) 
              @foreach($row19 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row20) != 0) 
              @foreach($row20 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 2 ends here -->
    
    <!-- Release 3 starts here -->
    <tr @if($releaseinfos[2]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[2]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[2]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[2]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row21) != 0) 
              @foreach($row21 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row22) != 0) 
              @foreach($row22 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row23) != 0) 
              @foreach($row23 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row24) != 0) 
              @foreach($row24 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row25) != 0) 
              @foreach($row25 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row26) != 0) 
              @foreach($row26 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row27) != 0) 
              @foreach($row27 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row28) != 0) 
              @foreach($row28 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row29) != 0) 
              @foreach($row29 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row30) != 0) 
              @foreach($row30 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 3 ends here -->
    
    <!-- Release 4 starts here -->
    <tr @if($releaseinfos[3]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[3]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[3]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[3]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row31) != 0) 
              @foreach($row31 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row32) != 0) 
              @foreach($row32 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row33) != 0) 
              @foreach($row33 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row34) != 0) 
              @foreach($row34 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row35) != 0) 
              @foreach($row35 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row36) != 0) 
              @foreach($row36 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row37) != 0) 
              @foreach($row37 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row38) != 0) 
              @foreach($row38 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row39) != 0) 
              @foreach($row39 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row40) != 0) 
              @foreach($row40 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 4 ends here -->
    
    <!-- Release 5 starts here -->
    <tr @if($releaseinfos[4]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[4]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[4]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[4]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row41) != 0) 
              @foreach($row41 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row42) != 0) 
              @foreach($row42 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row43) != 0) 
              @foreach($row43 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row44) != 0) 
              @foreach($row44 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row45) != 0) 
              @foreach($row45 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row46) != 0) 
              @foreach($row46 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row47) != 0) 
              @foreach($row47 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row48) != 0) 
              @foreach($row48 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row49) != 0) 
              @foreach($row49 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row50) != 0) 
              @foreach($row50 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 5 ends here -->
    
    <!-- Release 6 starts here -->
    <tr @if($releaseinfos[5]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[5]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[5]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[5]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row51) != 0) 
              @foreach($row51 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row52) != 0) 
              @foreach($row52 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row53) != 0) 
              @foreach($row53 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row54) != 0) 
              @foreach($row54 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row55) != 0) 
              @foreach($row55 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row56) != 0) 
              @foreach($row56 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row57) != 0) 
              @foreach($row57 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row58) != 0) 
              @foreach($row58 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row59) != 0) 
              @foreach($row59 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row60) != 0) 
              @foreach($row60 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 6 ends here -->
    
    <!-- Release 7 starts here -->
    <tr @if($releaseinfos[6]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[6]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[6]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[6]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row61) != 0) 
              @foreach($row61 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row62) != 0) 
              @foreach($row62 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row63) != 0) 
              @foreach($row63 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row64) != 0) 
              @foreach($row64 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row65) != 0) 
              @foreach($row65 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row66) != 0) 
              @foreach($row66 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row67) != 0) 
              @foreach($row67 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row68) != 0) 
              @foreach($row68 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row69) != 0) 
              @foreach($row69 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row70) != 0) 
              @foreach($row70 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 7 ends here -->
    
    <!-- Release 8 starts here -->
    <tr @if($releaseinfos[7]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[7]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[7]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[7]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row71) != 0) 
              @foreach($row71 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row72) != 0) 
              @foreach($row72 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row73) != 0) 
              @foreach($row73 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row74) != 0) 
              @foreach($row74 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row75) != 0) 
              @foreach($row75 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row76) != 0) 
              @foreach($row76 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row77) != 0) 
              @foreach($row77 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row78) != 0) 
              @foreach($row78 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row79) != 0) 
              @foreach($row79 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row80) != 0) 
              @foreach($row80 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 8 ends here -->
    
    <!-- Release 9 starts here -->
    <tr @if($releaseinfos[8]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[8]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[8]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[8]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row81) != 0) 
              @foreach($row81 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row82) != 0) 
              @foreach($row82 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row83) != 0) 
              @foreach($row83 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row84) != 0) 
              @foreach($row84 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row85) != 0) 
              @foreach($row85 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row86) != 0) 
              @foreach($row86 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row87) != 0) 
              @foreach($row87 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row88) != 0) 
              @foreach($row88 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row89) != 0) 
              @foreach($row89 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row90) != 0) 
              @foreach($row90 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 9 ends here -->
    
    <!-- Release 10 starts here -->
    <tr @if($releaseinfos[9]->rstatus == 'hide') style="display:none" @endif>
      <td><div class="page-break"></div></td>
    </tr>
    <tr @if($releaseinfos[9]->rstatus == 'hide') style="display:none" @endif>
      <td align="left"><span id="r_101" style="text-transform:capitalize">{{$releaseinfos[9]->rname}}</span></td>
    </tr>
    <tr  @if($releaseinfos[9]->rstatus == 'hide') style="display:none" @endif>
      <td><table width="100%" border="1" cellspacing="0" cellpadding="0" align="center" id="lcb">
          <tr>
            <td>@if(count($row91) != 0) 
              @foreach($row91 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row92) != 0) 
              @foreach($row92 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row93) != 0) 
              @foreach($row93 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row94) != 0) 
              @foreach($row94 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row95) != 0) 
              @foreach($row95 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row96) != 0) 
              @foreach($row96 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row97) != 0) 
              @foreach($row97 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row98) != 0) 
              @foreach($row98 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row99) != 0) 
              @foreach($row99 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
          <tr>
            <td>@if(count($row100) != 0) 
              @foreach($row100 as $dt)
              <p style="padding:10px;">{{ucfirst($dt->topic_name)}} </p>
<p style="padding:10px;">Discussed: {{$dt->topic_discussed_counts}} time(s)</p>
<p style="padding:10px;">Created by: {{ucfirst($dt->user_name)}}</p>    
<p style="padding:10px;">Actions:</p>
@foreach($action_infos as $ainfo)
@if($ainfo->a_topicid == $dt->topic_id)
<ul>
<li>{{$ainfo->a_title}}<br />
{{$ainfo->a_description}}</li>
</ul>
@endif
@endforeach
<p style="padding:10px;">Comments:</p>
@foreach($topic_messages as $tpm)
@if($tpm->d_topic_id == $dt->topic_id)
<p align="left" style="padding-left:5px; color:#000000" class="myinfo"><span style="color:#F60">{{ucfirst($tpm->user_name)}}</span><br>
{{$tpm->d_message}}<br>
{{$tpm->d_time}} </p>
@endif
@endforeach
<p style="padding:10px;">
<hr /><div class="page-break"></div>
</p>

              @endforeach
              
              @endif</td>
          </tr>
        </table></td>
    </tr>
    <!-- Release 10 ends here -->
    
                                        
  </table>
</main>
</body>
</html>
