@include('common.adminheader')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <section class="content-header">
      <div class="container-fluid">
        <div class="row mb-2">
          <div class="col-sm-6">
            <h1>Edit Profile</h1>
          </div>
          <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
              <li class="breadcrumb-item"><a href="{{url('admin/home')}}">Home</a></li>
              <li class="breadcrumb-item"><a href="{{url('admin/profile')}}">Profile</a></li>
              <li class="breadcrumb-item active">Edit Profile</li>
            </ol>
          </div>
        </div>
      </div><!-- /.container-fluid -->
    </section>

    <!-- Main content -->
    <section class="content">
    @if($errors->any())
  <div class="alert alert-danger">
    <ul>
      @foreach ($errors->all() as $error)
      <li>{{ $error }}</li>
      @endforeach
    </ul>
  </div>
  <br />
  @endif 
      <form method="post" action="" name="profile_edit_form" id="profile_edit_form" enctype="multipart/form-data">
       {{ csrf_field() }}
      <div class="row">
        <div class="col-md-12">
          <div class="card card-primary">
            <div class="card-header"></div>
            <div class="card-body">
            <div class="form-group">
                    <label for="exampleInputFile">Profile Image</label>
                    <div class="input-group">
                      <div class="custom-file">
                        <input type="file" name="exampleInputFile" class="custom-file-input" id="exampleInputFile" >
                        <label class="custom-file-label" for="exampleInputFile">Choose image</label>
                      </div>
                      <?php 
				if($user_info->profile_image != '')
				{
					$pimage = 'admin/dist/img/thumbnail/'.$user_info->profile_image;	
				}
				else
				{
					$pimage = 'admin/dist/img/noimage.png';
				}
				?> 
                    </div><br /><div id="profileImage"><img class="profile-user-img img-fluid img-circle" src="{{url($pimage)}}" alt="Profile Image" title="Profile Image"></div>
                  </div>
              <div class="form-group">
                <label for="inputName">First Name</label>
                <input type="text" id="firstname" name="firstname" class="form-control" value="{{$user_info->firstname}}">
              </div>
              <div class="form-group">
                <label for="inputName">Last Name</label>
                <input type="text" id="lastname" name="lastname" class="form-control" value="{{$user_info->lastname}}">
              </div>
              <div class="form-group">
                <label for="inputName">Email ID</label>
                <input type="text" id="emailid" name="emailid" class="form-control" value="{{$user_info->emailid}}">
              </div>              
              <div class="form-group">
                <label for="inputName">Education</label>
                <input type="text" id="education" name="education" class="form-control" value="{{$user_info->edutcationinfo}}">
              </div>
              <div class="form-group">
                <label for="inputName">Job</label>
                <input type="text" id="job" name="job" class="form-control" value="{{$user_info->employeeinfo}}">
              </div>   
              <div class="form-group">
                <label for="inputName">Skills</label>
                <input type="text" id="skills" name="skills" class="form-control" value="{{$user_info->skillsinfo}}">
              </div>                         
              <div class="form-group">
                <label for="inputStatus">Country</label>
                <select class="form-control select2" name="country" id="country">
                  <option value="">Select one</option>
                  @foreach($allcountries as $country)
                  <option value="{{$country->id}}" @if($country->id == $user_info->country) selected="selected" @endif>{{$country->name}}</option>
            	  @endforeach	 
                </select>                               
              </div><div id="country_error" class="myerror"></div>
              <div class="form-group">
                <label for="inputStatus">State</label>
                <select class="form-control select2" name="state" id="state">  
                  @foreach($allstates as $state)
                  <option value="{{$state->id}}" @if($state->id == $user_info->state) selected="selected" @endif>{{$state->name}}</option>
            	  @endforeach                                
                </select>                               
              </div><div id="state_error" class="myerror"></div>
              <div class="form-group">
                <label for="inputStatus">City</label>
                <select class="form-control select2" name="city" id="city"> 
                  @foreach($allcities as $city)
                  <option value="{{$city->id}}" @if($city->id == $user_info->city) selected="selected" @endif>{{$city->name}}</option>
            	  @endforeach                                  
                </select>                               
              </div><div id="city_error" class="myerror"></div>
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
        </div>
        
      </div>
      <div class="row">
        <div class="col-12">
          <a href="{{url('admin/profile')}}" class="btn btn-secondary">CANCEL</a>
          <input type="submit" value="Edit Profile" class="btn btn-success float-right">
        </div>
      </div>
      <div>&nbsp;</div>
      </form>
    </section>
    <!-- /.content -->
  </div>
@include('common.adminfooter')
<script type="text/javascript">

function showPreview(objFileInput) {
    if (objFileInput.files[0]) {
        var fileReader = new FileReader();
        fileReader.onload = function (e) {
            //$('#blah').attr('src', e.target.result);
			$("#profileImage").html('<img class="profile-user-img img-fluid img-circle" src="'+e.target.result+'" width="150px" height="150px" class="upload-preview" />');
			$("#profileImage").css('opacity','0.7');
			//$(".icon-choose-image").css('opacity','0.5');
        }
		fileReader.readAsDataURL(objFileInput.files[0]);
    }
}


$('#country').change(function(){
        var cid = $(this).val();
        if(cid){
        $.ajax({
           type:"get",
           url:"state/"+cid, 
           success:function(res)
           {       
                if(res)
                {
                    $("#state").empty();
                    $("#city").empty();
                    $("#state").append('<option>Select State</option>');
                    $.each(res,function(key,value){
                        $("#state").append('<option value="'+key+'">'+value+'</option>');
                    });
                }
           }

        });
        }
    });
	
$('#state').change(function(){
        var cid = $(this).val();
        if(cid){
        $.ajax({
           type:"get",
           url:"city/"+cid, 
           success:function(res)
           {       
                if(res)
                {
                    
                    $("#city").empty();
                    $("#city").append('<option>Select City</option>');
                    $.each(res,function(key,value){
                        $("#city").append('<option value="'+key+'">'+value+'</option>');
                    });
                }
           }

        });
        }
    });	
</script>
<!-- Form validation starts here -->
<script type="text/javascript" src="{{url('admin/dist/js/jquery.validate.min.js')}}"></script>
<script type="text/javascript">

$(document).ready(function() {
	
	jQuery.validator.addMethod(
	'text_only',
	function (value) { 
	return /^[a-zA-Z ]*$/.test(value); 
	},  
	'Text Only'
	);
	
	
	jQuery.validator.addMethod(
	'aprvd_txt',
	function (value) { 
	return /^[a-zA-Z0-9-,.)(\/ ]*$/.test(value); 
	},  
	'<p>Alpha Numeric charectar Only</p>'
	);
	
	
$("#profile_edit_form").validate({

		errorPlacement: function(error, element) {
		if (element.attr("name") == "country") {
		error.insertAfter('#country_error');
		}
		else if (element.attr("name") == "state") {
		error.insertAfter('#state_error');
		}
		else if (element.attr("name") == "city") {
		error.insertAfter('#city_error');
		}		
		else {
		error.insertAfter(element);
		}
		
		},	
		
rules: {
firstname: {
required: true,
aprvd_txt:true	
},
lastname: {
aprvd_txt:true	
},
emailid:{
required: true,
email:true
},
education: {
required: true,
aprvd_txt:true	
},
job: {
required: true,
aprvd_txt:true	
},
skills: {
required: true,
aprvd_txt:true	
},
country: {
required: true
},
state: {
required: true	
},
city: {
required: true
}			
},	
messages: {
firstname: {
required: '<span class="myerror">Please enter your firstname</span>',
aprvd_txt: '<span class="myerror">Special Characters not allowed</span>'
},
lastname: {
aprvd_txt: '<span class="myerror">Special Characters not allowed</span>'
},
emailid: {
required: '<span class="myerror">Please enter your emailid</span>',
email: '<span class="myerror">Please enter valid emailid</span>'
},
education: {
required: '<span class="myerror">Please enter your education details</span>',
aprvd_txt: '<span class="myerror">Special Characters not allowed</span>'
},
job: {
required: '<span class="myerror">Please enter your job details</span>',
aprvd_txt: '<span class="myerror">Special Characters not allowed</span>'
},
skills: {
required: '<span class="myerror">Please enter your skills details</span>',
aprvd_txt: '<span class="myerror">Special Characters not allowed</span>'
},
country: {
required: '<span class="myerror">Please select your country name</span>'
},
state: {
required: '<span class="myerror">Please select your state name</span>'
},
city: {
required: '<span class="myerror">Please select your city name</span>'
}
}
});
});

</script>
<!-- Form validation ends here -->