<meta name="csrf-token" content="{{ csrf_token() }}">
@include('common.adminheader')
<div class="content-wrapper">
  <!-- Content Header (Page header) -->
  <section class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1>Clients</h1>
        </div>
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('admin/home')}}">Home</a></li>           
            <li class="breadcrumb-item active">Clients</li>
          </ol>
        </div>
      </div>
    </div>
    <!-- /.container-fluid -->
  </section>
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">
      <div class="row">
        <div class="col-md-12">
          <div class="card">
          <div class="card-header"><div class="card-tools"><a href="{{url('admin/newclient/')}}" class="btn btn-block btn-success btn-sm">ADD NEW CLIENTS</a></div></div>
            <!-- /.card-header -->
            <div class="card-body">
             @if(count($allsponsors)>0)
              <table class="table table-bordered" id="example2">
                <thead>
                  <tr>
                    <th style="width: 50px">#</th>
                    <th>Image</th> 
                    <th>Link</th> 
                    <th>Status</th>
                    <th>Action</th>                   
                  </tr>
                </thead>
                <tbody>
                @foreach($allsponsors as $sponsors)
                   <tr id="sponsors_id_{{$sponsors->sid}}">
                    <td>{{ $loop->iteration }}.</td>
                    
                    <td><?php $pimage = 'admin/dist/img/sponsorimages/'.$sponsors->simage;?>
                 <div><img class="" src="{{url($pimage)}}" alt="Client Image" title="Client Image"></div>
                    </td>
                    <td><a href='{{$sponsors->slink}}' target="_blank" class="badge badge-success">Link</a></td>
                    <td>
                     @if($sponsors->sstatus == '1')
                <span class="badge badge-success">ACTIVE</span>
                @else
                <span class="badge badge-danger">IN - ACTIVE</span>
                @endif
                    </td>
					<td><a class="btn btn-info btn-sm" href="{{url('admin/editclient')}}/{{$sponsors->sid}}" alt="Edit" title="Edit"><i class="fas fa-pencil-alt"></i></a>
                    &nbsp;&nbsp;<a class="btn btn-danger btn-sm delete-sponsors"  data-id="{{ $sponsors->sid }}" href="javascript:void(0)" alt="Delete" title="Delete"><i class="fas fa-trash"></i></a>
                    </td>
				 </tr>
                @endforeach
                </tbody>
              </table>
              @else
              <p align="center">Sorry no details available.</p>
              @endif
            </div>
            <!-- /.card-body -->
          </div>
          <!-- /.card -->
          <!-- /.card -->
        </div>
        <!-- /.col -->
        <!-- /.col -->
      </div>
      <!-- /.row -->
      <!-- /.row -->
      <!-- /.row -->
    </div>
    <!-- /.container-fluid -->
  </section>
  <!-- /.content -->
</div>
@include('common.adminfooter')

<script>
  $(document).ready(function () {
    $.ajaxSetup({
        headers: {
            'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
        }
    });
    /*  When user click add user button */

 

     $(".delete-sponsors").click(function() {
        var sponsors_id = $(this).data("id");
		
        var k = confirm("Are You sure want to delete !");
 		if(k == true)
		{
        $.ajax({
            type: "POST",
            url: "{{ url('admin/deleteclient')}}"+'/'+sponsors_id,
            success: function (data) {			
                $("#sponsors_id_" + sponsors_id).remove();
            },
            error: function (data) {
                console.log('Error:', data);
            }
        });
	 	}
    });   
  });
 

   
  
</script>