<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateChatMessageTable extends Migration
{
    public function up()
    {
        Schema::create('chat_message', function (Blueprint $table) {

		$table->bigIncrements('id');
		$table->integer('usr_type')->default('0');
		$table->integer('c_from')->default('0');
		$table->integer('c_to')->default('0');
		$table->integer('c_meet_id')->default('0');
		$table->integer('c_typ')->default('1');
		$table->longtext('c_message')->nullable();
		$table->text('c_emoji')->nullable();
		$table->text('c_file_name')->nullable();
		$table->text('c_file_path')->nullable();
		$table->integer('c_view_status')->default('0');
		$table->datetime('c_created_at')->nullable();
		$table->datetime('c_updated_at')->nullable();

        });
    }

    public function down()
    {
        Schema::dropIfExists('chat_message');
    }
}