<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateBoardsTable extends Migration
{
    public function up()
    {
        Schema::create('boards', function (Blueprint $table) {

		$table->bigIncrements('meeting_id');
		$table->string('meeting_name',255);
		$table->string('meeting_rand',255);
		$table->integer('meeting_by');
		$table->date('meeting_date_created');
		$table->integer('meeting_status');
		$table->integer('meeting_type');
		$table->integer('meeting_name_dsiplay');
		$table->integer('meeting_sound')->default('3');
		$table->integer('meeting_start_status');
		$table->integer('meeting_no_guests');
		$table->text('meeting_conf_link')->nullable();
		$table->integer('meeting_conf_status');
		$table->string('meeting_password',100)->nullable();
		$table->integer('meeting_host_by')->nullable();
		$table->integer('meeting_end_status')->default('0');
		$table->integer('meeting_votes_fixed')->default('0');
		$table->text('meeting_opened_topics')->nullable();
		$table->timestamp('meeting_created_time')->default(DB::raw('CURRENT_TIMESTAMP'));
		$table->string('meeting_version',255)->nullable();
		$table->string('row_title1')->nullable();
		$table->string('row_title2')->nullable();
		$table->string('row_title3')->nullable();
		$table->integer('rowstatus')->default('0');
        });
    }

    public function down()
    {
        Schema::dropIfExists('boards');
    }
}