<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    return "Cache cleared";
});

Route::get('/remainder-status', function() {
    Artisan::call('remainder:status');
    return "check working or not";
});




Route::get('/config-cache', function() {
    Artisan::call('config:cache');
    return "config done";
});

Route::match(['get', 'post'], '/paypalsuccess', 'RegLoginController@paypalsuccess')->name('paypalsuccess');
Route::match(['get', 'post'], '/advancepaypalsuccess', 'RegLoginController@advancepaypalsuccess')->name('advancepaypalsuccess');
Route::match(['get', 'post'], '/paypalfailure/{id}', 'RegLoginController@paypalfailure');


Route::match(['get', 'post'], '/createpdfcheck/{current_mid}', 'BoardsController@createpdfcheck');

// user side
Route::match(['get', 'post'], '/forgetpassword', 'RegLoginController@forgetpassword');
Route::match(['get', 'post'], '/remainderstatus', 'UserController@remainderstatus');
Route::match(['get', 'post'], '/remainderstatus_four', 'UserController@remainderstatus_four');
Route::match(['get', 'post'], '/remainderstatus_six', 'UserController@remainderstatus_six');
Route::match(['get', 'post'], '/trialstatus', 'UserController@trialstatus');


Route::match(['get', 'post'], '/print-pdf', 'BoardsController@printPDF');
Route::match(['get', 'post'], '/', 'UserController@index');
Route::match(['get', 'post'], '/index', 'UserController@index');
Route::match(['get', 'post'], '/whatisleancoffeebrew', 'UserController@whatisleancoffeebrew');
Route::match(['get', 'post'], '/news', 'UserController@news');
Route::match(['get', 'post'], '/meetupstyles', 'UserController@meetupstyles');
Route::match(['get', 'post'], '/meetupstyles/{id}', 'UserController@meetupstyles');
Route::match(['get', 'post'], '/viewmeetupstyles/{id}', 'UserController@viewmeetupstyles');
Route::match(['get', 'post'], '/viewnews/{id}', 'UserController@viewnews');
Route::match(['get', 'post'], '/price', 'UserController@price');
Route::match(['get', 'post'], '/faq', 'UserController@faq');
Route::match(['get', 'post'], '/help', 'UserController@help');
Route::match(['get', 'post'], '/faq_help', 'UserController@faq_help');
Route::match(['get', 'post'], '/termsandconditions', 'UserController@termsandconditions');
Route::match(['get', 'post'], '/privacynotice', 'UserController@privacynotice');
Route::match(['get', 'post'], '/complaintprocedure', 'UserController@complaintprocedure');
Route::match(['get', 'post'], '/getfaqconents/{id}', 'UserController@getfaqconents');

Route::match(['get', 'post'], '/contactus', 'UserController@contactus');
Route::match(['get', 'post'], '/signin', 'RegLoginController@signin');
Route::match(['get', 'post'], '/signin/{id}/{email}', 'RegLoginController@signin');
Route::match(['get', 'post'], '/register', 'RegLoginController@register');
Route::match(['get', 'post'], '/checkemail', 'RegLoginController@checkemail');	
Route::match(['get', 'post'], '/meetingboard/{id}/{email}', 'BoardsController@meetingboard');
Route::match(['get', 'post'], '/guestuser/{id}', 'BoardsController@guestuser');
Route::match(['get', 'post'], '/guestloginarea', 'RegLoginController@guestloginarea');
// user side

Route::get('/redirect', 'SocialAuthGoogleController@redirect');
Route::get('/callback', 'SocialAuthGoogleController@callback');
Route::get('/fbredirect', 'SocialAuthFacebookController@fbredirect');
Route::get('/fbcallback', 'SocialAuthFacebookController@fbcallback');
Route::get('/googlelogin', 'SocialAuthGoogleController@googlelogin');
Route::match(['get', 'post'], '/mailview', 'RegLoginController@mailview');


// after login
Route::middleware(['userID'])->group(function() {

Route::match(['get', 'post'], '/getfirsttwocolumnsdatas/{id}', 'BoardsController@getfirsttwocolumnsdatas');
Route::match(['get', 'post'], '/getlcbparticipants/{id}', 'BoardsController@getlcbparticipants');
Route::match(['get', 'post'], '/upgrade_subscription', 'FacilitatorsController@upgrade_subscription');
Route::match(['get', 'post'], '/home', 'RegLoginController@home');
Route::match(['get', 'post'], '/customerhome', 'RegLoginController@customerhome');
Route::match(['get', 'post'], '/attendeehome', 'RegLoginController@attendeehome');
Route::match(['get', 'post'], '/signout', 'RegLoginController@signout');
Route::match(['get', 'post'], '/editprofile', 'RegLoginController@editprofile');
Route::match(['get', 'post'], '/choice', 'FacilitatorsController@choice');
Route::match(['get', 'post'], '/choice/{id}', 'FacilitatorsController@choice');
Route::match(['get', 'post'], '/beforeyoustart', 'FacilitatorsController@beforeyoustart');
Route::match(['get', 'post'], '/subscription', 'FacilitatorsController@subscription');
Route::match(['get', 'post'], '/customersubscription', 'FacilitatorsController@customersubscription');
Route::match(['get', 'post'], '/attendeesubscription', 'FacilitatorsController@attendeesubscription');
Route::match(['get', 'post'], '/verification', 'FacilitatorsController@verification');
Route::match(['get', 'post'], '/sendanothercode', 'FacilitatorsController@sendanothercode');
Route::match(['get', 'post'], '/checkeuseralready', 'FacilitatorsController@checkeuseralready');
Route::match(['get', 'post'], '/showrelatedpricedetails', 'FacilitatorsController@showrelatedpricedetails');
Route::match(['get', 'post'], '/addrequest', 'FacilitatorsController@addrequest');
Route::match(['get', 'post'], '/createmeeting', 'BoardsController@createmeeting');
Route::match(['get', 'post'], '/addattendeerequest', 'BoardsController@addattendeerequest');
Route::match(['get', 'post'], '/editattendeerequest', 'BoardsController@editattendeerequest');
Route::match(['get', 'post'], '/removefacilitators/{id}', 'FacilitatorsController@removefacilitators');
Route::match(['get', 'post'], '/removethisattendee/{id}', 'BoardsController@removethisattendee');
Route::match(['get', 'post'], '/leavethisgroup', 'FacilitatorsController@leavethisgroup');
Route::match(['get', 'post'], '/updateaccountdetails', 'RegLoginController@updateaccountdetails');
Route::match(['get', 'post'], '/updatebillingdetails', 'RegLoginController@updatebillingdetails');
Route::match(['get', 'post'], '/state/{id}', 'Admin\AdminController@getStates');
Route::match(['get', 'post'], '/city/{id}', 'Admin\AdminController@getCities');
Route::match(['get', 'post'], '/boards', 'BoardsController@boards');
Route::match(['get', 'post'], '/deletemeeting/{id}', 'BoardsController@deletemeeting');
Route::match(['get', 'post'], '/removevote/{id}', 'BoardsController@removevote');
Route::match(['get', 'post'], '/removevote/{id}/{mid}', 'BoardsController@removevote');
Route::match(['get', 'post'], '/deletetopics/{id}', 'BoardsController@deletetopics');
Route::match(['get', 'post'], '/deletetopics/{id}/{mid}', 'BoardsController@deletetopics');
Route::match(['get', 'post'], '/votetopics/{id}/{mid}', 'BoardsController@votetopics');
Route::match(['get', 'post'], '/checkattendeeornot', 'BoardsController@checkattendeeornot');
Route::match(['get', 'post'], '/editmeeting/{id}', 'BoardsController@editmeeting');
Route::match(['get', 'post'], '/yourboards', 'BoardsController@yourboards');
Route::match(['get', 'post'], '/updatelcbvalue', 'FacilitatorsController@updatelcbvalue');
Route::match(['get', 'post'], '/topics/{id}', 'BoardsController@topics');
Route::match(['get', 'post'], '/mtopics/{id}', 'BoardsController@mtopics');
Route::match(['get', 'post'], '/mycreatetopic', 'BoardsController@mycreatetopic');
Route::match(['get', 'post'], '/updatemeetingname', 'BoardsController@updatemeetingname');
Route::match(['get', 'post'], '/updatemeetinglink', 'BoardsController@updatemeetinglink');
Route::match(['get', 'post'], '/discussion/{id}', 'BoardsController@discussion');
Route::match(['get', 'post'], '/newdiscussion/{id}', 'BoardsController@newdiscussion');
Route::match(['get', 'post'], '/testdiscussion/{id}', 'BoardsController@testdiscussion');
Route::match(['get', 'post'], '/updatetopicname/', 'BoardsController@updatetopicname');
Route::match(['get', 'post'], '/updatetopicstatus/', 'BoardsController@updatetopicstatus');
Route::match(['get', 'post'], '/updatetopicstatusanother/', 'BoardsController@updatetopicstatusanother');
Route::match(['get', 'post'], '/showmovedtopics/{id}', 'BoardsController@showmovedtopics');
Route::match(['get', 'post'], '/discussingtopics/{id}', 'BoardsController@discussingtopics');
Route::match(['get', 'post'], '/changetopicstatus/', 'BoardsController@changetopicstatus');
Route::match(['get', 'post'], '/updatetimefortopic/', 'BoardsController@updatetimefortopic');
Route::match(['get', 'post'], '/messageentry/', 'BoardsController@messageentry');
Route::match(['get', 'post'], '/topicdiscussionmessage/{id}', 'BoardsController@topicdiscussionmessage');
Route::match(['get', 'post'], '/updateremainingtimes/', 'BoardsController@updateremainingtimes');
Route::match(['get', 'post'], '/tocheckanyactivedicussion/', 'BoardsController@tocheckanyactivedicussion');
Route::match(['get', 'post'], '/addactiondetails/', 'BoardsController@addactiondetails');
Route::match(['get', 'post'], '/getactiondetails/{id}', 'BoardsController@getactiondetails');
Route::match(['get', 'post'], '/getactiondetailsd/{id}', 'BoardsController@getactiondetailsd');
Route::match(['get', 'post'], '/removeactions/{id}', 'BoardsController@removeactions');
Route::match(['get', 'post'], '/createpdf', 'BoardsController@createpdf');
Route::match(['get', 'post'], '/createpdf/{id}', 'BoardsController@createpdf');
Route::match(['get', 'post'], '/currentdiscussingtopics/{id}', 'BoardsController@currentdiscussingtopics');
Route::match(['get', 'post'], '/gettopicsdetails/{id}', 'BoardsController@gettopicsdetails');
Route::match(['get', 'post'], '/viewalltopics/{id}', 'BoardsController@viewalltopics');
Route::match(['get', 'post'], '/gettopicnamedetails/{id}', 'BoardsController@gettopicnamedetails');
Route::match(['get', 'post'], '/columnone_topics/{id}', 'BoardsController@columnone_topics');
Route::match(['get', 'post'], '/columntwo_topics/{id}', 'BoardsController@columntwo_topics');
Route::match(['get', 'post'], '/columnthree_topics/{id}', 'BoardsController@columnthree_topics');
Route::match(['get', 'post'], '/removeallvotes/{id}', 'BoardsController@removeallvotes');
Route::match(['get', 'post'], '/deletealltopics/{id}', 'BoardsController@deletealltopics');
Route::match(['get', 'post'], '/shownamestatus', 'BoardsController@shownamestatus');
Route::match(['get', 'post'], '/printPDF', 'BoardsController@printPDF');
Route::match(['get', 'post'], '/exporttocsv/{id}', 'BoardsController@exporttocsv');
Route::match(['get', 'post'], '/changetimersound', 'BoardsController@changetimersound');
Route::match(['get', 'post'], '/topics_sorting/{id}', 'BoardsController@topics_sorting');
Route::match(['get', 'post'], '/setconferencestatus/{id}/{sid}', 'BoardsController@setconferencestatus');
Route::match(['get', 'post'], '/mergetopics', 'BoardsController@mergetopics');
Route::match(['get', 'post'], '/gettopicsonly/{id}', 'BoardsController@gettopicsonly');



Route::match(['get', 'post'], '/firstcolumn_topics/{id}', 'BoardsController@firstcolumn_topics');
Route::match(['get', 'post'], '/secondcolumn_topics/{id}', 'BoardsController@secondcolumn_topics');
Route::match(['get', 'post'], '/thirdcolumn_topics/{id}', 'BoardsController@thirdcolumn_topics');
Route::match(['get', 'post'], '/fourthcolumn_topics/{id}', 'BoardsController@fourthcolumn_topics');
Route::match(['get', 'post'], '/topics_load/{id}', 'BoardsController@topics_load');
Route::match(['get', 'post'], '/topics_load_vote_only/{id}', 'BoardsController@topics_load_vote_only');

// for agenda meeting


Route::match(['get', 'post'], '/checkagendameetinglivestatus/{id}', 'AgendaController@checkagendameetinglivestatus');
Route::match(['get', 'post'], '/agendameeting/{id}', 'AgendaController@agendameeting');
Route::match(['get', 'post'], '/delete_agenda_meeting/{id}', 'AgendaController@delete_agenda_meeting');
Route::match(['get', 'post'], '/addattendeerequest_agenda', 'AgendaController@addattendeerequest_agenda');
Route::match(['get', 'post'], '/removethisattendee_agenda/{id}', 'AgendaController@removethisattendee_agenda');
Route::match(['get', 'post'], '/addagendameeting', 'AgendaController@addagendameeting');
Route::match(['get', 'post'], '/editagendameeting', 'AgendaController@editagendameeting');
Route::match(['get', 'post'], '/addagendameetingitem', 'AgendaController@addagendameetingitem');
Route::match(['get', 'post'], '/showagendadiscussiondetails', 'AgendaController@showagendadiscussiondetails');
Route::match(['get', 'post'], '/agendameeting/{id}/{item_id}', 'AgendaController@agendameeting');
Route::match(['get', 'post'], '/addlinksfor_agenda', 'AgendaController@addlinksfor_agenda');
Route::match(['get', 'post'], '/removelinkid/{id}', 'AgendaController@removelinkid');
Route::match(['get', 'post'], '/agenda_item_notes_entry', 'AgendaController@agenda_item_notes_entry');
Route::match(['get', 'post'], '/agenda_links_notes_actions/{id}', 'AgendaController@agenda_links_notes_actions');
Route::match(['get', 'post'], '/getallnotes/{id}', 'AgendaController@getallnotes');
Route::match(['get', 'post'], '/removenotesid/{id}', 'AgendaController@removenotesid');
Route::match(['get', 'post'], '/agenda_item_actions_entry', 'AgendaController@agenda_item_actions_entry');
Route::match(['get', 'post'], '/getallactions/{id}', 'AgendaController@getallactions');
Route::match(['get', 'post'], '/removeactionsid/{id}', 'AgendaController@removeactionsid');
Route::match(['get', 'post'], '/editagendameetingitem', 'AgendaController@editagendameetingitem');
Route::match(['get', 'post'], '/delete_agenda_items/{id}/{mid}', 'AgendaController@delete_agenda_items');
Route::match(['get', 'post'], '/startthismeeting/{id}', 'AgendaController@startthismeeting');
Route::match(['get', 'post'], '/endthismeeting/{id}', 'AgendaController@endthismeeting');
Route::match(['get', 'post'], '/createagendapdf', 'AgendaController@createagendapdf');
Route::match(['get', 'post'], '/createagendapdf/{current_mid}', 'AgendaController@createagendapdf');
Route::match(['get', 'post'], '/agenda_sorting/{id}', 'AgendaController@agenda_sorting');
Route::match(['get', 'post'], '/guest_choice/{mid}/{id}', 'AgendaController@guest_choice');
// for agenda meeting

Route::match(['get', 'post'], '/paypalpayment', 'RegLoginController@paypalpayment');
Route::match(['get', 'post'], '/advancepaypalpayment', 'RegLoginController@advancepaypalpayment');


});
// after login


// admin side

Route::match(['get', 'post'], '/admin/index', 'Admin\AdminController@index');
Route::match(['get', 'post'], '/admin/forgetpassword', 'Admin\AdminController@forgetpassword');

Route::middleware(['adminID'])->group(function() {

Route::match(['get', 'post'], '/admin/home', 'Admin\AdminController@home');
Route::match(['get', 'post'], '/admin/logout', 'Admin\AdminController@logout');
Route::match(['get', 'post'], '/admin/profile', 'Admin\AdminController@profile');

Route::match(['get', 'post'], '/admin/changepassword', 'Admin\AdminController@changepassword');

Route::match(['get', 'post'], '/admin/faq', 'Admin\AdminController@faq');
Route::match(['get', 'post'], '/admin/newfaq', 'Admin\AdminController@newfaq');
Route::match(['get', 'post'], '/admin/editfaq/{id}', 'Admin\AdminController@editfaq');
Route::match(['get', 'post'], '/admin/deletefaq/{id}', 'Admin\AdminController@deletefaq');

Route::match(['get', 'post'], '/admin/clients', 'Admin\AdminController@clients');
Route::match(['get', 'post'], '/admin/newclient', 'Admin\AdminController@newclient');
Route::match(['get', 'post'], '/admin/editclient/{id}', 'Admin\AdminController@editclient');
Route::match(['get', 'post'], '/admin/deleteclient/{id}', 'Admin\AdminController@deleteclient');

Route::match(['get', 'post'], '/admin/headerbanners', 'Admin\AdminController@headerbanners');
Route::match(['get', 'post'], '/admin/newheaderbanner', 'Admin\AdminController@newheaderbanner');
Route::match(['get', 'post'], '/admin/editheaderbanner/{id}', 'Admin\AdminController@editheaderbanner');

Route::match(['get', 'post'], '/admin/contactdetails', 'Admin\AdminController@contactdetails');
Route::match(['get', 'post'], '/admin/whatislcb', 'Admin\AdminController@whatislcb');

Route::match(['get', 'post'], '/admin/helpcategory', 'Admin\AdminController@helpcategory');
Route::match(['get', 'post'], '/admin/newhelpcategory', 'Admin\AdminController@newhelpcategory');
Route::match(['get', 'post'], '/admin/edithelpcategory/{id}', 'Admin\AdminController@edithelpcategory');
Route::match(['get', 'post'], '/admin/deletehelpcategory/{id}', 'Admin\AdminController@deletehelpcategory');

Route::match(['get', 'post'], '/admin/helpsubcategory/{catid}', 'Admin\AdminController@helpsubcategory');
Route::match(['get', 'post'], '/admin/newhelpsubcategory/{catid}', 'Admin\AdminController@newhelpsubcategory');
Route::match(['get', 'post'], '/admin/edithelpsubcategory/{catid}/{id}', 'Admin\AdminController@edithelpsubcategory');
Route::match(['get', 'post'], '/admin/deletehelpsubcategory/{id}', 'Admin\AdminController@deletehelpsubcategory');

Route::match(['get', 'post'], '/admin/help', 'Admin\AdminController@help');
Route::match(['get', 'post'], '/admin/newhelp', 'Admin\AdminController@newhelp');
Route::match(['get', 'post'], '/admin/edithelp/{id}', 'Admin\AdminController@edithelp');
Route::match(['get', 'post'], '/admin/subcat/{id}', 'Admin\AdminController@getSubcat');
Route::match(['get', 'post'], '/admin/deletehelp/{id}', 'Admin\AdminController@deletehelp');


Route::match(['get', 'post'], '/admin/pricing', 'Admin\AdminController@pricing');
Route::match(['get', 'post'], '/admin/newpricing', 'Admin\AdminController@newpricing');
Route::match(['get', 'post'], '/admin/editpricing/{id}', 'Admin\AdminController@editpricing');
Route::match(['get', 'post'], '/admin/deletepricing/{id}', 'Admin\AdminController@deletepricing');

Route::match(['get', 'post'], '/admin/cms', 'Admin\AdminController@cms');
Route::match(['get', 'post'], '/admin/editcms/{id}', 'Admin\AdminController@editcms');

Route::match(['get', 'post'], '/admin/functionality', 'Admin\AdminController@functionality');
Route::match(['get', 'post'], '/admin/newfunctionality', 'Admin\AdminController@newfunctionality');
Route::match(['get', 'post'], '/admin/editfunctionality/{id}', 'Admin\AdminController@editfunctionality');
Route::match(['get', 'post'], '/admin/deletefunctionality/{id}', 'Admin\AdminController@deletefunctionality');

Route::match(['get', 'post'], '/admin/news', 'Admin\AdminController@news');
Route::match(['get', 'post'], '/admin/newnews', 'Admin\AdminController@newnews');
Route::match(['get', 'post'], '/admin/editnews/{id}', 'Admin\AdminController@editnews');
Route::match(['get', 'post'], '/admin/deletenews/{id}', 'Admin\AdminController@deletenews');
Route::match(['get', 'post'], '/admin/viewnews/{id}', 'Admin\AdminController@viewnews');

Route::match(['get', 'post'], '/admin/cropimage', 'Admin\AdminController@cropimage');
Route::match(['get', 'post'], '/admin/cropimagetwo', 'Admin\AdminController@cropimagetwo');

Route::match(['get', 'post'], '/admin/social_links', 'Admin\AdminController@social_links');
Route::match(['get', 'post'], '/admin/contactlist', 'Admin\AdminController@contactlist');
Route::match(['get', 'post'], '/admin/deletecontact/{id}', 'Admin\AdminController@deletecontact');

Route::match(['get', 'post'], '/admin/userfaq', 'Admin\AdminController@userfaq');
Route::match(['get', 'post'], '/admin/deleteuserfaq/{id}', 'Admin\AdminController@deleteuserfaq');
Route::match(['get', 'post'], '/admin/subscribers', 'Admin\AdminController@subscribers');
Route::match(['get', 'post'], '/admin/deletesubscribers/{id}', 'Admin\AdminController@deletesubscribers');

Route::match(['get', 'post'], '/admin/imageupload', 'Admin\AdminController@imageupload');
Route::match(['get', 'post'], '/admin/uploadimage', 'Admin\AdminController@uploadimage');

Route::match(['get', 'post'], '/admin/editprofile', 'Admin\AdminController@editprofile');
Route::match(['get', 'post'], '/admin/state/{id}', 'Admin\AdminController@getStates');
Route::match(['get', 'post'], '/admin/city/{id}', 'Admin\AdminController@getCities');


Route::match(['get', 'post'], '/admin/facilitators', 'Admin\AdminController@facilitators');
Route::match(['get', 'post'], '/admin/attendees', 'Admin\AdminController@attendees');


});
// admin side