<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/


Route::get('/chat', 'ChatController@index')->name('chat');
Route::post('/sendvchat', 'ChatController@sendchat')->name('sendchat');
Route::post('/getchatdetail/{id}', 'ChatController@getchatdetail')->name('getchatdetail');


Route::get('/clear-cache', function() {
    Artisan::call('cache:clear');
    return "Cache cleared";
});

Route::get('/key-generate', function() {
    Artisan::call('key:generate');
    return "key generated";
});

Route::get('/remainder-status', function() {
    Artisan::call('remainder:status');
    return "check working or not";
});




Route::get('/config-cache', function() {
    Artisan::call('config:cache');
    return "config done";
});

Route::match(['get', 'post'], '/paypalsuccess', 'RegLoginController@paypalsuccess')->name('paypalsuccess');
Route::match(['get', 'post'], '/advancepaypalsuccess', 'RegLoginController@advancepaypalsuccess')->name('advancepaypalsuccess');
Route::match(['get', 'post'], '/upgradepaypalsuccess', 'RegLoginController@upgradepaypalsuccess')->name('upgradepaypalsuccess');
Route::match(['get', 'post'], '/paypalfailure/{id}', 'RegLoginController@paypalfailure');


Route::match(['get', 'post'], '/cleartable', 'RegLoginController@cleartable')->name('cleartable');

Route::match(['get', 'post'], '/advanceauthorizednetpayment', 'RegLoginController@advanceauthorizednetpayment')->name('advanceauthorizednetpayment');
Route::match(['post'], '/advance_authorizednet_payment', 'RegLoginController@advance_authorizednet_payment');

Route::match(['get', 'post'], '/authorizednetpayment', 'RegLoginController@authorizednetpayment')->name('authorizednetpayment');
Route::match(['post'], '/authorizednet_payment', 'RegLoginController@authorizednet_payment');

Route::match(['get', 'post'], '/sendemailtoparticipant_test', 'EmailController_test@sendemailtoparticipant');

Route::match(['get', 'post'], '/sendemailtoparticipant', 'EmailController@sendemailtoparticipant');

Route::match(['get', 'post'], '/createpdfcheck/{current_mid}', 'BoardsController@createpdfcheck');

// user side
Route::match(['get', 'post'], '/autologoutsession', 'UserController@autologoutsession');
Route::match(['get', 'post'], '/forgetpassword', 'RegLoginController@forgetpassword');
Route::match(['get', 'post'], '/remainderstatus', 'UserController@remainderstatus');
Route::match(['get', 'post'], '/remainderstatus_four', 'UserController@remainderstatus_four');
Route::match(['get', 'post'], '/remainderstatus_six', 'UserController@remainderstatus_six');
Route::match(['get', 'post'], '/trialstatus', 'UserController@trialstatus');


Route::match(['get', 'post'], '/print-pdf', 'BoardsController@printPDF');
Route::match(['get', 'post'], '/', 'UserController@index');
Route::match(['get', 'post'], '/index', 'UserController@index');
Route::match(['get', 'post'], '/whatisleancoffeebrew', 'UserController@whatisleancoffeebrew');
Route::match(['get', 'post'], '/news', 'UserController@news');
Route::match(['get', 'post'], '/meetupstyles', 'UserController@meetupstyles');
Route::match(['get', 'post'], '/meetupstyles/{id}', 'UserController@meetupstyles');
Route::match(['get', 'post'], '/viewmeetupstyles/{id}', 'UserController@viewmeetupstyles');
Route::match(['get', 'post'], '/viewnews/{id}', 'UserController@viewnews');
Route::match(['get', 'post'], '/price', 'UserController@price');
Route::match(['get', 'post'], '/faq', 'UserController@faq');
Route::match(['get', 'post'], '/help', 'UserController@help');
Route::match(['get', 'post'], '/faq_help', 'UserController@faq_help');
Route::match(['get', 'post'], '/termsandconditions', 'UserController@termsandconditions');
Route::match(['get', 'post'], '/privacynotice', 'UserController@privacynotice');
Route::match(['get', 'post'], '/complaintprocedure', 'UserController@complaintprocedure');
Route::match(['get', 'post'], '/getfaqconents/{id}', 'UserController@getfaqconents');

Route::match(['get', 'post'], '/contactus', 'UserController@contactus');
Route::match(['get', 'post'], '/signin', 'RegLoginController@signin');
Route::match(['get', 'post'], '/signin/{id}/{email}', 'RegLoginController@signin');
Route::match(['get', 'post'], '/register', 'RegLoginController@register');
Route::match(['get', 'post'], '/checkemail', 'RegLoginController@checkemail');	
Route::match(['get', 'post'], '/meetingboard/{id}/{email}', 'BoardsController@meetingboard');
Route::match(['get', 'post'], '/guestuser/{id}', 'BoardsController@guestuser');
Route::match(['get', 'post'], '/guestloginarea', 'RegLoginController@guestloginarea');
// user side

Route::get('/redirect', 'SocialAuthGoogleController@redirect');
Route::get('/callback', 'SocialAuthGoogleController@callback');
Route::get('/fbredirect', 'SocialAuthFacebookController@fbredirect');
Route::get('/fbcallback', 'SocialAuthFacebookController@fbcallback');
Route::get('/googlelogin', 'SocialAuthGoogleController@googlelogin');
Route::match(['get', 'post'], '/mailview', 'RegLoginController@mailview');


// after login
Route::middleware(['userID'])->group(function() {


Route::match(['get', 'post'], '/changejoinstatusparticipants/{id}', 'BoardsController@changejoinstatusparticipants');
Route::match(['get', 'post'], '/changeleftstatusparticipants/{id}', 'BoardsController@changeleftstatusparticipants');


Route::match(['get', 'post'], '/changejoinstatusguest/{id}', 'BoardsController@changejoinstatusguest');
Route::match(['get', 'post'], '/changeleftstatusguest/{id}', 'BoardsController@changeleftstatusguest');


Route::match(['get', 'post'], '/getmonths/{monthid}', 'BoardsController@getmonths');
Route::match(['get', 'post'], '/resettimetozero', 'BoardsController@resettimetozero');

Route::match(['get', 'post'], '/takehostback/{userid}/{mid}', 'BoardsController@takehostback');

Route::match(['get', 'post'], '/find_session_name', 'RegLoginController@find_session_name');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas/{id}', 'BoardsController@getfirsttwocolumnsdatas');

Route::match(['get', 'post'], '/getlcbparticipants/{id}', 'BoardsController@getlcbparticipants');
Route::match(['get', 'post'], '/getlcbparticipants_ps/{id}', 'BoardsController@getlcbparticipants_ps');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps/{id}', 'BoardsController@removepsgetlcbparticipants_ps');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps/{id}', 'BoardsController@removepsgetlcbguest_ps');

Route::match(['get', 'post'], '/upgrade_subscription', 'FacilitatorsController@upgrade_subscription');
Route::match(['get', 'post'], '/home', 'RegLoginController@home');
Route::match(['get', 'post'], '/customerhome', 'RegLoginController@customerhome');
Route::match(['get', 'post'], '/attendeehome', 'RegLoginController@attendeehome');
Route::match(['get', 'post'], '/signout', 'RegLoginController@signout');
Route::match(['get', 'post'], '/signoutandremoved', 'RegLoginController@signoutandremoved');
Route::match(['get', 'post'], '/signoutandleave', 'RegLoginController@signoutandleave');
Route::match(['get', 'post'], '/editprofile', 'RegLoginController@editprofile');
Route::match(['get', 'post'], '/choice', 'FacilitatorsController@choice');
Route::match(['get', 'post'], '/choice/{id}', 'FacilitatorsController@choice');
Route::match(['get', 'post'], '/beforeyoustart', 'FacilitatorsController@beforeyoustart');
Route::match(['get', 'post'], '/subscription', 'FacilitatorsController@subscription');
Route::match(['get', 'post'], '/customersubscription', 'FacilitatorsController@customersubscription');
Route::match(['get', 'post'], '/attendeesubscription', 'FacilitatorsController@attendeesubscription');
Route::match(['get', 'post'], '/verification', 'FacilitatorsController@verification');
Route::match(['get', 'post'], '/sendanothercode', 'FacilitatorsController@sendanothercode');
Route::match(['get', 'post'], '/checkeuseralready', 'FacilitatorsController@checkeuseralready');
Route::match(['get', 'post'], '/showrelatedpricedetails', 'FacilitatorsController@showrelatedpricedetails');
Route::match(['get', 'post'], '/addrequest', 'FacilitatorsController@addrequest');
Route::match(['get', 'post'], '/createmeeting', 'BoardsController@createmeeting');
Route::match(['get', 'post'], '/addattendeerequest', 'BoardsController@addattendeerequest');
Route::match(['get', 'post'], '/editattendeerequest', 'BoardsController@editattendeerequest');
Route::match(['get', 'post'], '/editimportattendeerequest', 'BoardsController@editimportattendeerequest');
Route::match(['get', 'post'], '/addimportattendeerequest', 'BoardsController@addimportattendeerequest');
Route::match(['get', 'post'], '/justchangeremovedstatus', 'BoardsController@justchangeremovedstatus');
Route::match(['get', 'post'], '/leavemeetingnow/{id}/{mid}', 'BoardsController@leavemeetingnow');

Route::match(['get', 'post'], '/removefacilitators/{id}', 'FacilitatorsController@removefacilitators');
Route::match(['get', 'post'], '/removethisattendee/{id}', 'BoardsController@removethisattendee');
Route::match(['get', 'post'], '/removethisattendee/{id}/{mid}/{emid}', 'BoardsController@removethisattendee');


Route::match(['get', 'post'], '/leavethisgroup', 'FacilitatorsController@leavethisgroup');
Route::match(['get', 'post'], '/updateaccountdetails', 'RegLoginController@updateaccountdetails');
Route::match(['get', 'post'], '/updatebillingdetails', 'RegLoginController@updatebillingdetails');
Route::match(['get', 'post'], '/state/{id}', 'Admin\AdminController@getStates');
Route::match(['get', 'post'], '/city/{id}', 'Admin\AdminController@getCities');
Route::match(['get', 'post'], '/boards', 'BoardsController@boards');
Route::match(['get', 'post'], '/boardsnewway', 'BoardsController@boardsnewway');
Route::match(['get', 'post'], '/deletemeeting/{id}', 'BoardsController@deletemeeting');
Route::match(['get', 'post'], '/removevote/{id}', 'BoardsController@removevote');
Route::match(['get', 'post'], '/removevote/{id}/{mid}', 'BoardsController@removevote');
Route::match(['get', 'post'], '/deletetopics/{id}', 'BoardsController@deletetopics');
Route::match(['get', 'post'], '/deletetopics/{id}/{mid}', 'BoardsController@deletetopics');
Route::match(['get', 'post'], '/makehost/{id}/{mid}', 'BoardsController@makehost');
Route::match(['get', 'post'], '/takehost/{id}/{mid}', 'BoardsController@takehost');
Route::match(['get', 'post'], '/votetopics/{id}/{mid}', 'BoardsController@votetopics');
Route::match(['get', 'post'], '/checkattendeeornot', 'BoardsController@checkattendeeornot');
Route::match(['get', 'post'], '/editmeeting/{id}', 'BoardsController@editmeeting');
Route::match(['get', 'post'], '/yourboards', 'BoardsController@yourboards');
Route::match(['get', 'post'], '/updatelcbvalue', 'FacilitatorsController@updatelcbvalue');
Route::match(['get', 'post'], '/topics/{id}', 'BoardsController@topics');
Route::match(['get', 'post'], '/mtopics/{id}', 'BoardsController@mtopics');
Route::match(['get', 'post'], '/mycreatetopic', 'BoardsController@mycreatetopic');
Route::match(['get', 'post'], '/getvotelistbarista/{id}', 'BoardsController@getvotelistbarista');
Route::match(['get', 'post'], '/updatemeetingname', 'BoardsController@updatemeetingname');
Route::match(['get', 'post'], '/updatemeetingversion', 'BoardsController@updatemeetingversion');
Route::match(['get', 'post'], '/updatemeetingvotes', 'BoardsController@updatemeetingvotes');
Route::match(['get', 'post'], '/updatemeetingvotes_edit', 'BoardsController@updatemeetingvotes_edit');
Route::match(['get', 'post'], '/updatemeetingnameandvotes', 'BoardsController@updatemeetingnameandvotes');
Route::match(['get', 'post'], '/updatemeetinglink', 'BoardsController@updatemeetinglink');
Route::match(['get', 'post'], '/discussion/{id}', 'BoardsController@discussion');
Route::match(['get', 'post'], '/discussion-preview/{id}', 'BoardsController@previewdiscussion');
Route::match(['get', 'post'], '/swotdiscussion/{id}', 'SwotController@swotdiscussion');
Route::match(['get', 'post'], '/swotdiscussion-preview/{id}', 'SwotController@previewswotdiscussion');
Route::match(['get', 'post'], '/updatetopicname_swot/', 'SwotController@updatetopicname_swot');
Route::match(['get', 'post'], '/getcommentdetails_swot/{id}/{mid}', 'SwotController@getcommentdetails_swot');
Route::match(['get', 'post'], '/messageentry_comment_swot/', 'SwotController@messageentry_comment_swot');
Route::match(['get', 'post'], '/deleteallcomments_swot/{id}', 'SwotController@deleteallcomments_swot');


Route::match(['get', 'post'], '/productvision/{id}', 'ProductvisionController@productvisiondiscussion');
Route::match(['get', 'post'], '/productvision-preview/{id}', 'ProductvisionController@previewproductvisiondiscussion');

Route::match(['get', 'post'], '/addtopicname_pv', 'ProductvisionController@addtopicname_pv');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_pv/{id}', 'ProductvisionController@getfirsttwocolumnsdatas_pv');
Route::match(['get', 'post'], '/exporttocsv_pv/{id}', 'ProductvisionController@exporttocsv_pv');
Route::match(['get', 'post'], '/updatetopicstatus_pv/', 'ProductvisionController@updatetopicstatus_pv');
Route::match(['get', 'post'], '/createpdf_pv', 'ProductvisionController@createpdf_pv');
Route::match(['get', 'post'], '/createpdf_pv/{id}', 'ProductvisionController@createpdf_pv');
Route::match(['get', 'post'], '/getlcbparticipants_ps_pv/{id}', 'ProductvisionController@getlcbparticipants_ps_pv');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_pv/{id}', 'ProductvisionController@removepsgetlcbparticipants_ps_pv');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_pv/{id}', 'ProductvisionController@removepsgetlcbguest_ps_pv');
Route::match(['get', 'post'], '/getlcbparticipants_pv/{id}', 'ProductvisionController@getlcbparticipants_pv');
Route::match(['get', 'post'], '/updatetopicstatusanother_pv/', 'ProductvisionController@updatetopicstatusanother_pv');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_pv/', 'ProductvisionController@tocheckanyactivedicussion_pv');
Route::match(['get', 'post'], '/updateremainingtimes_pv/', 'ProductvisionController@updateremainingtimes_pv');
Route::match(['get', 'post'], '/getactiondetails_pv/{id}', 'ProductvisionController@getactiondetails_pv');
Route::match(['get', 'post'], '/updatetimefortopic_pv/', 'ProductvisionController@updatetimefortopic_pv');
Route::match(['get', 'post'], '/deletetopics_pv/{id}/{mid}', 'ProductvisionController@deletetopics_pv');
Route::match(['get', 'post'], '/updatetopicname_pv/', 'ProductvisionController@updatetopicname_pv');
Route::match(['get', 'post'], '/getcommentdetails_pv/{id}/{mid}', 'ProductvisionController@getcommentdetails_pv');
Route::match(['get', 'post'], '/messageentry_comment_pv/', 'ProductvisionController@messageentry_comment_pv');
Route::match(['get', 'post'], '/deleteallcomments_pv/{id}', 'ProductvisionController@deleteallcomments_pv');
Route::match(['get', 'post'], '/addtoopenclose_pv/{tid}/{mid}/{option}', 'ProductvisionController@addtoopenclose_pv');
Route::match(['get', 'post'], '/addcollapsed_pv/{tid}/{toption}', 'ProductvisionController@addcollapsed_pv');
Route::match(['get', 'post'], '/gettopicnamedetails_pv/{id}', 'ProductvisionController@gettopicnamedetails_pv');


Route::match(['get', 'post'], '/sailboat/{id}', 'SailboatController@sailboatdiscussion');
Route::match(['get', 'post'], '/sailboat-preview/{id}', 'SailboatController@previewsailboatdiscussion');

Route::match(['get', 'post'], '/addtopicname_sb', 'SailboatController@addtopicname_sb');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_sb/{id}', 'SailboatController@getfirsttwocolumnsdatas_sb');
Route::match(['get', 'post'], '/exporttocsv_sb/{id}', 'SailboatController@exporttocsv_sb');
Route::match(['get', 'post'], '/updatetopicstatus_sb/', 'SailboatController@updatetopicstatus_sb');
Route::match(['get', 'post'], '/createpdf_sb', 'SailboatController@createpdf_sb');
Route::match(['get', 'post'], '/createpdf_sb/{current_mid}', 'SailboatController@createpdf_sb');
Route::match(['get', 'post'], '/getlcbparticipants_ps_sb/{id}', 'SailboatController@getlcbparticipants_ps_sb');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_sb/{id}', 'SailboatController@removepsgetlcbparticipants_ps_sb');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_sb/{id}', 'SailboatController@removepsgetlcbguest_ps_sb');
Route::match(['get', 'post'], '/getlcbparticipants_sb/{id}', 'SailboatController@getlcbparticipants_sb');
Route::match(['get', 'post'], '/updatetopicstatusanother_sb/', 'SailboatController@updatetopicstatusanother_sb');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_sb/', 'SailboatController@tocheckanyactivedicussion_sb');
Route::match(['get', 'post'], '/updateremainingtimes_sb/', 'SailboatController@updateremainingtimes_sb');
Route::match(['get', 'post'], '/getactiondetails_sb/{id}', 'SailboatController@getactiondetails_sb');
Route::match(['get', 'post'], '/updatetimefortopic_sb/', 'SailboatController@updatetimefortopic_sb');
Route::match(['get', 'post'], '/deletetopics_sb/{id}/{mid}', 'SailboatController@deletetopics_sb');
Route::match(['get', 'post'], '/updatetopicname_sb/', 'SailboatController@updatetopicname_sb');
Route::match(['get', 'post'], '/getcommentdetails_sb/{id}/{mid}', 'SailboatController@getcommentdetails_sb');
Route::match(['get', 'post'], '/messageentry_comment_sb/', 'SailboatController@messageentry_comment_sb');
Route::match(['get', 'post'], '/deleteallcomments_sb/{id}', 'SailboatController@deleteallcomments_sb');
Route::match(['get', 'post'], '/addtoopenclose_sb/{tid}/{mid}/{option}', 'SailboatController@addtoopenclose_sb');
Route::match(['get', 'post'], '/addcollapsed_sb/{tid}/{toption}', 'SailboatController@addcollapsed_sb');
Route::match(['get', 'post'], '/gettopicnamedetails_sb/{id}', 'SailboatController@gettopicnamedetails_sb');

Route::match(['get', 'post'], '/leancanvas-preview/{id}', 'LeanCanvasController@previewleancanvasdiscussion');
Route::match(['get', 'post'], '/leancanvas/{id}', 'LeanCanvasController@leancanvasdiscussion');
Route::match(['get', 'post'], '/addtopicname_lc', 'LeanCanvasController@addtopicname_lc');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_lc/{id}', 'LeanCanvasController@getfirsttwocolumnsdatas_lc');
Route::match(['get', 'post'], '/exporttocsv_lc/{id}', 'LeanCanvasController@exporttocsv_lc');
Route::match(['get', 'post'], '/updatetopicstatus_lc/', 'LeanCanvasController@updatetopicstatus_lc');
Route::match(['get', 'post'], '/createpdf_lc', 'LeanCanvasController@createpdf_lc');
Route::match(['get', 'post'], '/createpdf_lc/{current_mid}', 'LeanCanvasController@createpdf_lc');
Route::match(['get', 'post'], '/getlcbparticipants_ps_lc/{id}', 'LeanCanvasController@getlcbparticipants_ps_lc');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_lc/{id}', 'LeanCanvasController@removepsgetlcbparticipants_ps_lc');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_lc/{id}', 'LeanCanvasController@removepsgetlcbguest_ps_lc');
Route::match(['get', 'post'], '/getlcbparticipants_lc/{id}', 'LeanCanvasController@getlcbparticipants_lc');
Route::match(['get', 'post'], '/updatetopicstatusanother_lc/', 'LeanCanvasController@updatetopicstatusanother_lc');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_lc/', 'LeanCanvasController@tocheckanyactivedicussion_lc');
Route::match(['get', 'post'], '/updateremainingtimes_lc/', 'LeanCanvasController@updateremainingtimes_lc');
Route::match(['get', 'post'], '/getactiondetails_lc/{id}', 'LeanCanvasController@getactiondetails_lc');
Route::match(['get', 'post'], '/updatetimefortopic_lc/', 'LeanCanvasController@updatetimefortopic_lc');
Route::match(['get', 'post'], '/deletetopics_lc/{id}/{mid}', 'LeanCanvasController@deletetopics_lc');
Route::match(['get', 'post'], '/updatetopicname_lc/', 'LeanCanvasController@updatetopicname_lc');
Route::match(['get', 'post'], '/getcommentdetails_lc/{id}/{mid}', 'LeanCanvasController@getcommentdetails_lc');
Route::match(['get', 'post'], '/messageentry_comment_lc/', 'LeanCanvasController@messageentry_comment_lc');
Route::match(['get', 'post'], '/deleteallcomments_lc/{id}', 'LeanCanvasController@deleteallcomments_lc');
Route::match(['get', 'post'], '/addtoopenclose_lc/{tid}/{mid}/{option}', 'LeanCanvasController@addtoopenclose_lc');
Route::match(['get', 'post'], '/addcollapsed_lc/{tid}/{toption}', 'LeanCanvasController@addcollapsed_lc');
Route::match(['get', 'post'], '/gettopicnamedetails_lc/{id}', 'LeanCanvasController@gettopicnamedetails_lc');


Route::match(['get', 'post'], '/portfoliocanvas-preview/{id}', 'PortfolioCanvasController@previewportfoliocanvasdiscussion');


Route::match(['get', 'post'], '/portfoliocanvas/{id}', 'PortfolioCanvasController@portfoliocanvasdiscussion');
Route::match(['get', 'post'], '/addtopicname_pc', 'PortfolioCanvasController@addtopicname_pc');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_pc/{id}', 'PortfolioCanvasController@getfirsttwocolumnsdatas_pc');
Route::match(['get', 'post'], '/exporttocsv_pc/{id}', 'PortfolioCanvasController@exporttocsv_pc');
Route::match(['get', 'post'], '/updatetopicstatus_pc/', 'PortfolioCanvasController@updatetopicstatus_pc');
Route::match(['get', 'post'], '/createpdf_pc', 'PortfolioCanvasController@createpdf_pc');
Route::match(['get', 'post'], '/createpdf_pc/{current_mid}', 'PortfolioCanvasController@createpdf_pc');
Route::match(['get', 'post'], '/getlcbparticipants_ps_pc/{id}', 'PortfolioCanvasController@getlcbparticipants_ps_pc');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_pc/{id}', 'PortfolioCanvasController@removepsgetlcbparticipants_ps_pc');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_pc/{id}', 'PortfolioCanvasController@removepsgetlcbguest_ps_pc');
Route::match(['get', 'post'], '/getlcbparticipants_pc/{id}', 'PortfolioCanvasController@getlcbparticipants_pc');
Route::match(['get', 'post'], '/updatetopicstatusanother_pc/', 'PortfolioCanvasController@updatetopicstatusanother_pc');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_pc/', 'PortfolioCanvasController@tocheckanyactivedicussion_pc');
Route::match(['get', 'post'], '/updateremainingtimes_pc/', 'PortfolioCanvasController@updateremainingtimes_pc');
Route::match(['get', 'post'], '/getactiondetails_pc/{id}', 'PortfolioCanvasController@getactiondetails_pc');
Route::match(['get', 'post'], '/updatetimefortopic_pc/', 'PortfolioCanvasController@updatetimefortopic_pc');
Route::match(['get', 'post'], '/deletetopics_pc/{id}/{mid}', 'PortfolioCanvasController@deletetopics_pc');
Route::match(['get', 'post'], '/updatetopicname_pc/', 'PortfolioCanvasController@updatetopicname_pc');
Route::match(['get', 'post'], '/getcommentdetails_pc/{id}/{mid}', 'PortfolioCanvasController@getcommentdetails_pc');
Route::match(['get', 'post'], '/messageentry_comment_pc/', 'PortfolioCanvasController@messageentry_comment_pc');
Route::match(['get', 'post'], '/deleteallcomments_pc/{id}', 'PortfolioCanvasController@deleteallcomments_pc');
Route::match(['get', 'post'], '/addtoopenclose_pc/{tid}/{mid}/{option}', 'PortfolioCanvasController@addtoopenclose_pc');
Route::match(['get', 'post'], '/addcollapsed_pc/{tid}/{toption}', 'PortfolioCanvasController@addcollapsed_pc');
Route::match(['get', 'post'], '/gettopicnamedetails_pc/{id}', 'PortfolioCanvasController@gettopicnamedetails_pc');


Route::match(['get', 'post'], '/updateload_1', 'LeanPlanningController@updateload_1');
Route::match(['get', 'post'], '/updateload_2', 'LeanPlanningController@updateload_2');
Route::match(['get', 'post'], '/updateload_3', 'LeanPlanningController@updateload_3');
Route::match(['get', 'post'], '/updateload_4', 'LeanPlanningController@updateload_4');
Route::match(['get', 'post'], '/updateload_5', 'LeanPlanningController@updateload_5');
Route::match(['get', 'post'], '/updateload_6', 'LeanPlanningController@updateload_6');

Route::match(['get', 'post'], '/updatecapacity_1', 'LeanPlanningController@updatecapacity_1');
Route::match(['get', 'post'], '/updatecapacity_2', 'LeanPlanningController@updatecapacity_2');
Route::match(['get', 'post'], '/updatecapacity_3', 'LeanPlanningController@updatecapacity_3');
Route::match(['get', 'post'], '/updatecapacity_4', 'LeanPlanningController@updatecapacity_4');
Route::match(['get', 'post'], '/updatecapacity_5', 'LeanPlanningController@updatecapacity_5');
Route::match(['get', 'post'], '/updatecapacity_6', 'LeanPlanningController@updatecapacity_6');


Route::match(['get', 'post'], '/leanplanning-preview/{id}', 'LeanPlanningController@previewleanplanningdiscussion');
Route::match(['get', 'post'], '/leanplanning/{id}', 'LeanPlanningController@leanplanningdiscussion');
Route::match(['get', 'post'], '/addtopicname_lp', 'LeanPlanningController@addtopicname_lp');
Route::match(['get', 'post'], '/addtopicnameobjective_lp', 'LeanPlanningController@addtopicnameobjective_lp');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_lp/{id}', 'LeanPlanningController@getfirsttwocolumnsdatas_lp');
Route::match(['get', 'post'], '/exporttocsv_lp/{id}', 'LeanPlanningController@exporttocsv_lp');
Route::match(['get', 'post'], '/updatetopicstatus_lp/', 'LeanPlanningController@updatetopicstatus_lp');
Route::match(['get', 'post'], '/createpdf_lp', 'LeanPlanningController@createpdf_lp');
Route::match(['get', 'post'], '/createpdf_lp/{current_mid}', 'LeanPlanningController@createpdf_lp');
Route::match(['get', 'post'], '/getlcbparticipants_ps_lp/{id}', 'LeanPlanningController@getlcbparticipants_ps_lp');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_lp/{id}', 'LeanPlanningController@removepsgetlcbparticipants_ps_lp');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_lp/{id}', 'LeanPlanningController@removepsgetlcbguest_ps_lp');
Route::match(['get', 'post'], '/getlcbparticipants_lp/{id}', 'LeanPlanningController@getlcbparticipants_lp');
Route::match(['get', 'post'], '/updatetopicstatusanother_lp/', 'LeanPlanningController@updatetopicstatusanother_lp');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_lp/', 'LeanPlanningController@tocheckanyactivedicussion_lp');
Route::match(['get', 'post'], '/updateremainingtimes_lp/', 'LeanPlanningController@updateremainingtimes_lp');
Route::match(['get', 'post'], '/getactiondetails_lp/{id}', 'LeanPlanningController@getactiondetails_lp');
Route::match(['get', 'post'], '/updatetimefortopic_lp/', 'LeanPlanningController@updatetimefortopic_lp');
Route::match(['get', 'post'], '/deletetopics_lp/{id}/{mid}', 'LeanPlanningController@deletetopics_lp');
Route::match(['get', 'post'], '/updatetopicname_lp/', 'LeanPlanningController@updatetopicname_lp');
Route::match(['get', 'post'], '/updatetopicnamenew_lp/', 'LeanPlanningController@updatetopicnamenew_lp');
Route::match(['get', 'post'], '/getcommentdetails_lp/{id}/{mid}', 'LeanPlanningController@getcommentdetails_lp');
Route::match(['get', 'post'], '/messageentry_comment_lp/', 'LeanPlanningController@messageentry_comment_lp');
Route::match(['get', 'post'], '/deleteallcomments_lp/{id}', 'LeanPlanningController@deleteallcomments_lp');
Route::match(['get', 'post'], '/addtoopenclose_lp/{tid}/{mid}/{option}', 'LeanPlanningController@addtoopenclose_lp');
Route::match(['get', 'post'], '/addcollapsed_lp/{tid}/{toption}', 'LeanPlanningController@addcollapsed_lp');
Route::match(['get', 'post'], '/gettopicnamedetails_lp/{id}', 'LeanPlanningController@gettopicnamedetails_lp');
Route::match(['get', 'post'], '/deletealltopics_lp/{id}', 'LeanPlanningController@deletealltopics_lp');

Route::match(['get', 'post'], '/showhide_sm/{id}/{mid}', 'StoryMappingController@showhide_sm');
Route::match(['get', 'post'], '/addnewrow/{rid}/{mid}', 'StoryMappingController@addnewrow');
Route::match(['get', 'post'], '/hidethisrow/{rid}/{mid}', 'StoryMappingController@hidethisrow');
Route::match(['get', 'post'], '/storymapping/{id}', 'StoryMappingController@storymappingdiscussion');
Route::match(['get', 'post'], '/getdynamicrowcontents', 'StoryMappingController@getdynamicrowcontents');
Route::match(['get', 'post'], '/addtopicname_sm', 'StoryMappingController@addtopicname_sm');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_sm/{id}', 'StoryMappingController@getfirsttwocolumnsdatas_sm');
Route::match(['get', 'post'], '/exporttocsv_sm/{id}', 'StoryMappingController@exporttocsv_sm');
Route::match(['get', 'post'], '/updatetopicstatus_sm/', 'StoryMappingController@updatetopicstatus_sm');
Route::match(['get', 'post'], '/createpdf_sm', 'StoryMappingController@createpdf_sm');
Route::match(['get', 'post'], '/createpdf_sm/{id}', 'StoryMappingController@createpdf_sm');
Route::match(['get', 'post'], '/getlcbparticipants_ps_sm/{id}', 'StoryMappingController@getlcbparticipants_ps_sm');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_sm/{id}', 'StoryMappingController@removepsgetlcbparticipants_ps_sm');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_sm/{id}', 'StoryMappingController@removepsgetlcbguest_ps_sm');
Route::match(['get', 'post'], '/getlcbparticipants_sm/{id}', 'StoryMappingController@getlcbparticipants_sm');
Route::match(['get', 'post'], '/updatetopicstatusanother_sm/', 'StoryMappingController@updatetopicstatusanother_sm');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_sm/', 'StoryMappingController@tocheckanyactivedicussion_sm');
Route::match(['get', 'post'], '/updateremainingtimes_sm/', 'StoryMappingController@updateremainingtimes_sm');
Route::match(['get', 'post'], '/getactiondetails_sm/{id}', 'StoryMappingController@getactiondetails_sm');
Route::match(['get', 'post'], '/updatetimefortopic_sm/', 'StoryMappingController@updatetimefortopic_sm');
Route::match(['get', 'post'], '/deletetopics_sm/{id}/{mid}', 'StoryMappingController@deletetopics_sm');
Route::match(['get', 'post'], '/deletetopics_bystatus/{status}/{mid}', 'StoryMappingController@deletetopics_bystatus');
Route::match(['get', 'post'], '/updatetopicname_sm/', 'StoryMappingController@updatetopicname_sm');
Route::match(['get', 'post'], '/getcommentdetails_sm/{id}/{mid}', 'StoryMappingController@getcommentdetails_sm');
Route::match(['get', 'post'], '/messageentry_comment_sm/', 'StoryMappingController@messageentry_comment_sm');
Route::match(['get', 'post'], '/deleteallcomments_sm/{id}', 'StoryMappingController@deleteallcomments_sm');
Route::match(['get', 'post'], '/addtoopenclose_sm/{tid}/{mid}/{option}', 'StoryMappingController@addtoopenclose_sm');
Route::match(['get', 'post'], '/addcollapsed_sm/{tid}/{toption}', 'StoryMappingController@addcollapsed_sm');
Route::match(['get', 'post'], '/gettopicnamedetails_sm/{id}', 'StoryMappingController@gettopicnamedetails_sm');
Route::match(['get', 'post'], '/storymapping-preview/{id}', 'StoryMappingController@previewstorymappingdiscussion');
Route::match(['get', 'post'], '/getreleasename_sm/{rid}/{mid}', 'StoryMappingController@getreleasename_sm');
Route::match(['get', 'post'], '/updatereleasename_sm/', 'StoryMappingController@updatereleasename_sm');
Route::match(['get', 'post'], '/rowgetreleasename_sm/{rid}/{mid}', 'StoryMappingController@rowgetreleasename_sm');
Route::match(['get', 'post'], '/rowupdatereleasename_sm/', 'StoryMappingController@rowupdatereleasename_sm');

Route::match(['get', 'post'], '/addnewcolumn/{rid}/{mid}', 'OpenSpaceController@addnewcolumn');
Route::match(['get', 'post'], '/addnewrow/{rid}/{mid}', 'OpenSpaceController@addnewrow');
Route::match(['get', 'post'], '/hidethisrow_os/{rid}/{mid}', 'OpenSpaceController@hidethisrow_os');
Route::match(['get', 'post'], '/hidethiscolumn_os/{rid}/{mid}', 'OpenSpaceController@hidethiscolumn_os');
Route::match(['get', 'post'], '/openspace/{id}', 'OpenSpaceController@openspacediscussion');
Route::match(['get', 'post'], '/getdynamicrowcontents', 'OpenSpaceController@getdynamicrowcontents');
Route::match(['get', 'post'], '/addtopicname_os', 'OpenSpaceController@addtopicname_os');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_os/{id}', 'OpenSpaceController@getfirsttwocolumnsdatas_os');
Route::match(['get', 'post'], '/exporttocsv_os/{id}', 'OpenSpaceController@exporttocsv_os');
Route::match(['get', 'post'], '/updatetopicstatus_os/', 'OpenSpaceController@updatetopicstatus_os');
Route::match(['get', 'post'], '/createpdf_os', 'OpenSpaceController@createpdf_os');
Route::match(['get', 'post'], '/createpdf_os/{id}', 'OpenSpaceController@createpdf_os');
Route::match(['get', 'post'], '/getlcbparticipants_ps_os/{id}', 'OpenSpaceController@getlcbparticipants_ps_os');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_os/{id}', 'OpenSpaceController@removepsgetlcbparticipants_ps_os');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_os/{id}', 'OpenSpaceController@removepsgetlcbguest_ps_os');
Route::match(['get', 'post'], '/getlcbparticipants_os/{id}', 'OpenSpaceController@getlcbparticipants_os');
Route::match(['get', 'post'], '/updatetopicstatusanother_os/', 'OpenSpaceController@updatetopicstatusanother_os');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_os/', 'OpenSpaceController@tocheckanyactivedicussion_os');
Route::match(['get', 'post'], '/updateremainingtimes_os/', 'OpenSpaceController@updateremainingtimes_os');
Route::match(['get', 'post'], '/getactiondetails_os/{id}', 'OpenSpaceController@getactiondetails_os');
Route::match(['get', 'post'], '/updatetimefortopic_os/', 'OpenSpaceController@updatetimefortopic_os');
Route::match(['get', 'post'], '/deletetopics_os/{id}/{mid}', 'OpenSpaceController@deletetopics_os');
Route::match(['get', 'post'], '/deletetopics_bystatus/{status}/{mid}', 'OpenSpaceController@deletetopics_bystatus');
Route::match(['get', 'post'], '/updatetopicname_os/', 'OpenSpaceController@updatetopicname_os');
Route::match(['get', 'post'], '/getcommentdetails_os/{id}/{mid}', 'OpenSpaceController@getcommentdetails_os');
Route::match(['get', 'post'], '/messageentry_comment_os/', 'OpenSpaceController@messageentry_comment_os');
Route::match(['get', 'post'], '/deleteallcomments_os/{id}', 'OpenSpaceController@deleteallcomments_os');
Route::match(['get', 'post'], '/addtoopenclose_os/{tid}/{mid}/{option}', 'OpenSpaceController@addtoopenclose_os');
Route::match(['get', 'post'], '/addcollapsed_os/{tid}/{toption}', 'OpenSpaceController@addcollapsed_os');
Route::match(['get', 'post'], '/gettopicnamedetails_os/{id}', 'OpenSpaceController@gettopicnamedetails_os');
Route::match(['get', 'post'], '/openspace-preview/{id}', 'OpenSpaceController@previewopenspacediscussion');
Route::match(['get', 'post'], '/getreleasename_os/{rid}/{mid}', 'OpenSpaceController@getreleasename_os');
Route::match(['get', 'post'], '/updatereleasename_os/', 'OpenSpaceController@updatereleasename_os');
Route::match(['get', 'post'], '/pdfview/', 'OpenSpaceController@pdfview');

Route::match(['get', 'post'], '/updateostitle_1', 'OpenSpaceController@updateostitle_1');
Route::match(['get', 'post'], '/updateostitle_2', 'OpenSpaceController@updateostitle_2');
Route::match(['get', 'post'], '/updateostitle_3', 'OpenSpaceController@updateostitle_3');
Route::match(['get', 'post'], '/updateostitle_4', 'OpenSpaceController@updateostitle_4');
Route::match(['get', 'post'], '/updateostitle_5', 'OpenSpaceController@updateostitle_5');
Route::match(['get', 'post'], '/updateostitle_6', 'OpenSpaceController@updateostitle_6');
Route::match(['get', 'post'], '/updateostitle_7', 'OpenSpaceController@updateostitle_7');
Route::match(['get', 'post'], '/updateostitle_8', 'OpenSpaceController@updateostitle_8');
Route::match(['get', 'post'], '/updateostitle_9', 'OpenSpaceController@updateostitle_9');
Route::match(['get', 'post'], '/updateostitle_10', 'OpenSpaceController@updateostitle_10');
Route::match(['get', 'post'], '/updateostitle_11', 'OpenSpaceController@updateostitle_11');
Route::match(['get', 'post'], '/updateostitle_12', 'OpenSpaceController@updateostitle_12');
Route::match(['get', 'post'], '/updateostitle_13', 'OpenSpaceController@updateostitle_13');
Route::match(['get', 'post'], '/updateostitle_14', 'OpenSpaceController@updateostitle_14');
Route::match(['get', 'post'], '/updateostitle_15', 'OpenSpaceController@updateostitle_15');
Route::match(['get', 'post'], '/updateostitle_16', 'OpenSpaceController@updateostitle_16');
Route::match(['get', 'post'], '/updateostitle_17', 'OpenSpaceController@updateostitle_17');

Route::match(['get', 'post'], '/updateostitle_31', 'OpenSpaceController@updateostitle_31');
Route::match(['get', 'post'], '/updateostitle_41', 'OpenSpaceController@updateostitle_41');
Route::match(['get', 'post'], '/updateostitle_51', 'OpenSpaceController@updateostitle_51');
Route::match(['get', 'post'], '/removeallvotes_os/{id}', 'OpenSpaceController@removeallvotes_os');

Route::match(['get', 'post'], '/removevote_fb/{id}/{mid}', 'FishBoneController@removevote_fb');
Route::match(['get', 'post'], '/votetopics_fb/{id}/{mid}', 'FishBoneController@votetopics_fb');
Route::match(['get', 'post'], '/showhide_fb/{id}/{mid}', 'FishBoneController@showhide_fb');
Route::match(['get', 'post'], '/addnewrow/{rid}/{mid}', 'FishBoneController@addnewrow');
Route::match(['get', 'post'], '/hidethisrow/{rid}/{mid}', 'FishBoneController@hidethisrow');
Route::match(['get', 'post'], '/fishbone/{id}', 'FishBoneController@fishbonediscussion');
Route::match(['get', 'post'], '/testfishbone/{id}', 'FishBoneController@testfishbonediscussion');
Route::match(['get', 'post'], '/fishbone-preview/{id}', 'FishBoneController@previewfishbonediscussion');
Route::match(['get', 'post'], '/fishbone_pareto_chart/{id}', 'FishBoneController@fishbone_pareto_analysis');
Route::match(['get', 'post'], '/getdynamicrowcontents', 'FishBoneController@getdynamicrowcontents');
Route::match(['get', 'post'], '/addtopicname_fb', 'FishBoneController@addtopicname_fb');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_fb/{id}', 'FishBoneController@getfirsttwocolumnsdatas_fb');
Route::match(['get', 'post'], '/exporttocsv_fb/{id}', 'FishBoneController@exporttocsv_fb');
Route::match(['get', 'post'], '/updatetopicstatus_fb/', 'FishBoneController@updatetopicstatus_fb');
Route::match(['get', 'post'], '/createpdf_fb', 'FishBoneController@createpdf_fb');
Route::match(['get', 'post'], '/createpdf_fb/{id}', 'FishBoneController@createpdf_fb');
Route::match(['get', 'post'], '/getlcbparticipants_ps_fb/{id}', 'FishBoneController@getlcbparticipants_ps_fb');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_fb/{id}', 'FishBoneController@removepsgetlcbparticipants_ps_fb');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_fb/{id}', 'FishBoneController@removepsgetlcbguest_ps_fb');
Route::match(['get', 'post'], '/getlcbparticipants_fb/{id}', 'FishBoneController@getlcbparticipants_fb');
Route::match(['get', 'post'], '/updatetopicstatusanother_fb/', 'FishBoneController@updatetopicstatusanother_fb');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_fb/', 'FishBoneController@tocheckanyactivedicussion_fb');
Route::match(['get', 'post'], '/updateremainingtimes_fb/', 'FishBoneController@updateremainingtimes_fb');
Route::match(['get', 'post'], '/getactiondetails_fb/{id}', 'FishBoneController@getactiondetails_fb');
Route::match(['get', 'post'], '/updatetimefortopic_fb/', 'FishBoneController@updatetimefortopic_fb');
Route::match(['get', 'post'], '/deletetopics_fb/{id}/{mid}', 'FishBoneController@deletetopics_fb');
Route::match(['get', 'post'], '/deletetopics_bystatus/{status}/{mid}', 'FishBoneController@deletetopics_bystatus');
Route::match(['get', 'post'], '/updatetopicname_fb/', 'FishBoneController@updatetopicname_fb');
Route::match(['get', 'post'], '/getcommentdetails_fb/{id}/{mid}', 'FishBoneController@getcommentdetails_fb');
Route::match(['get', 'post'], '/messageentry_comment_fb/', 'FishBoneController@messageentry_comment_fb');
Route::match(['get', 'post'], '/deleteallcomments_fb/{id}', 'FishBoneController@deleteallcomments_fb');
Route::match(['get', 'post'], '/addtoopenclose_fb/{tid}/{mid}/{option}', 'FishBoneController@addtoopenclose_fb');
Route::match(['get', 'post'], '/addcollapsed_fb/{tid}/{toption}', 'FishBoneController@addcollapsed_fb');
Route::match(['get', 'post'], '/gettopicnamedetails_fb/{id}', 'FishBoneController@gettopicnamedetails_fb');
Route::match(['get', 'post'], '/getreleasename_fb/{rid}/{mid}', 'FishBoneController@getreleasename_fb');
Route::match(['get', 'post'], '/updatereleasename_fb/', 'FishBoneController@updatereleasename_fb');
Route::match(['get', 'post'], '/rowgetreleasename_fb/{rid}/{mid}', 'FishBoneController@rowgetreleasename_fb');
Route::match(['get', 'post'], '/rowupdatereleasename_fb/', 'FishBoneController@rowupdatereleasename_fb');
Route::match(['get', 'post'], '/updatefbtitle_1/', 'FishBoneController@updatefbtitle_1');
Route::match(['get', 'post'], '/updatefbtitle_2/', 'FishBoneController@updatefbtitle_2');
Route::match(['get', 'post'], '/updatefbtitle_3/', 'FishBoneController@updatefbtitle_3');
Route::match(['get', 'post'], '/updatefbtitle_4/', 'FishBoneController@updatefbtitle_4');
Route::match(['get', 'post'], '/updatefbtitle_5/', 'FishBoneController@updatefbtitle_5');

Route::match(['get', 'post'], '/updatefbtinfo_1/', 'FishBoneController@updatefbtinfo_1');
Route::match(['get', 'post'], '/updatefbtinfo_2/', 'FishBoneController@updatefbtinfo_2');
Route::match(['get', 'post'], '/updatefbtinfo_3/', 'FishBoneController@updatefbtinfo_3');
Route::match(['get', 'post'], '/updatefbtinfo_4/', 'FishBoneController@updatefbtinfo_4');
Route::match(['get', 'post'], '/updatefbtinfo_5/', 'FishBoneController@updatefbtinfo_5');
Route::match(['get', 'post'], '/updatefbtinfo_6/', 'FishBoneController@updatefbtinfo_6');
Route::match(['get', 'post'], '/removeallvotes_fb/{id}', 'FishBoneController@removeallvotes_fb');



Route::match(['get', 'post'], '/removevote_cop/{id}/{mid}', 'COPController@removevote_cop');
Route::match(['get', 'post'], '/votetopics_cop/{id}/{mid}', 'COPController@votetopics_cop');
Route::match(['get', 'post'], '/showhide_cop/{id}/{mid}', 'COPController@showhide_cop');
Route::match(['get', 'post'], '/addnewrow/{rid}/{mid}', 'COPController@addnewrow');
Route::match(['get', 'post'], '/hidethisrow/{rid}/{mid}', 'COPController@hidethisrow');
Route::match(['get', 'post'], '/communityofpractice/{id}', 'COPController@communityofpracticediscussion');
Route::match(['get', 'post'], '/testfishbone/{id}', 'COPController@testfishbonediscussion');
Route::match(['get', 'post'], '/communityofpractice-preview/{id}', 'COPController@previewcopdiscussion');
Route::match(['get', 'post'], '/getdynamicrowcontents', 'COPController@getdynamicrowcontents');
Route::match(['get', 'post'], '/addtopicname_cop', 'COPController@addtopicname_cop');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_cop/{id}', 'COPController@getfirsttwocolumnsdatas_cop');
Route::match(['get', 'post'], '/exporttocsv_cop/{id}', 'COPController@exporttocsv_cop');
Route::match(['get', 'post'], '/updatetopicstatus_cop/', 'COPController@updatetopicstatus_cop');
Route::match(['get', 'post'], '/createpdf_cop', 'COPController@createpdf_cop');
Route::match(['get', 'post'], '/createpdf_cop/{id}', 'COPController@createpdf_cop');
Route::match(['get', 'post'], '/getlcbparticipants_ps_cop/{id}', 'COPController@getlcbparticipants_ps_cop');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_cop/{id}', 'COPController@removepsgetlcbparticipants_ps_cop');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_cop/{id}', 'COPController@removepsgetlcbguest_ps_cop');
Route::match(['get', 'post'], '/getlcbparticipants_cop/{id}', 'COPController@getlcbparticipants_cop');
Route::match(['get', 'post'], '/updatetopicstatusanother_cop/', 'COPController@updatetopicstatusanother_cop');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_cop/', 'COPController@tocheckanyactivedicussion_cop');
Route::match(['get', 'post'], '/updateremainingtimes_cop/', 'COPController@updateremainingtimes_cop');
Route::match(['get', 'post'], '/getactiondetails_cop/{id}', 'COPController@getactiondetails_cop');
Route::match(['get', 'post'], '/updatetimefortopic_cop/', 'COPController@updatetimefortopic_cop');
Route::match(['get', 'post'], '/deletetopics_cop/{id}/{mid}', 'COPController@deletetopics_cop');
Route::match(['get', 'post'], '/deletetopics_bystatus/{status}/{mid}', 'COPController@deletetopics_bystatus');
Route::match(['get', 'post'], '/updatetopicname_cop/', 'COPController@updatetopicname_cop');
Route::match(['get', 'post'], '/getcommentdetails_cop/{id}/{mid}', 'COPController@getcommentdetails_cop');
Route::match(['get', 'post'], '/messageentry_comment_cop/', 'COPController@messageentry_comment_cop');
Route::match(['get', 'post'], '/deleteallcomments_cop/{id}', 'COPController@deleteallcomments_cop');
Route::match(['get', 'post'], '/addtoopenclose_cop/{tid}/{mid}/{option}', 'COPController@addtoopenclose_cop');
Route::match(['get', 'post'], '/addcollapsed_cop/{tid}/{toption}', 'COPController@addcollapsed_cop');
Route::match(['get', 'post'], '/gettopicnamedetails_cop/{id}', 'COPController@gettopicnamedetails_cop');
Route::match(['get', 'post'], '/getreleasename_cop/{rid}/{mid}', 'COPController@getreleasename_cop');
Route::match(['get', 'post'], '/updatereleasename_cop/', 'COPController@updatereleasename_cop');
Route::match(['get', 'post'], '/rowgetreleasename_cop/{rid}/{mid}', 'COPController@rowgetreleasename_cop');
Route::match(['get', 'post'], '/rowupdatereleasename_cop/', 'COPController@rowupdatereleasename_cop');

Route::match(['get', 'post'], '/removeallvotes_cop/{id}', 'COPController@removeallvotes_cop');

Route::match(['get', 'post'], '/showtherow_cop/{id}/{status}', 'COPController@showtherow_cop');


Route::match(['get', 'post'], '/removevote_mindmap/{id}/{mid}', 'MindMapController@removevote_mindmap');
Route::match(['get', 'post'], '/votetopics_mindmap/{id}/{mid}', 'MindMapController@votetopics_mindmap');
Route::match(['get', 'post'], '/showhide_mindmap/{id}/{mid}', 'MindMapController@showhide_mindmap');
Route::match(['get', 'post'], '/addnewrow/{rid}/{mid}', 'MindMapController@addnewrow');
Route::match(['get', 'post'], '/hidethisrow/{rid}/{mid}', 'MindMapController@hidethisrow');
Route::match(['get', 'post'], '/mindmap/{id}', 'MindMapController@mindmapdiscussion');
Route::match(['get', 'post'], '/testfishbone/{id}', 'MindMapController@testfishbonediscussion');
Route::match(['get', 'post'], '/mindmap-preview/{id}', 'MindMapController@previewmindmapdiscussion');
Route::match(['get', 'post'], '/getdynamicrowcontents', 'MindMapController@getdynamicrowcontents');
Route::match(['get', 'post'], '/addtopicname_mindmap', 'MindMapController@addtopicname_mindmap');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_mindmap/{id}', 'MindMapController@getfirsttwocolumnsdatas_mindmap');
Route::match(['get', 'post'], '/exporttocsv_mindmap/{id}', 'MindMapController@exporttocsv_mindmap');
Route::match(['get', 'post'], '/updatetopicstatus_mindmap/', 'MindMapController@updatetopicstatus_mindmap');
Route::match(['get', 'post'], '/createpdf_mindmap', 'MindMapController@createpdf_mindmap');
Route::match(['get', 'post'], '/createpdf_mindmap/{id}', 'MindMapController@createpdf_mindmap');
Route::match(['get', 'post'], '/getlcbparticipants_ps_mindmap/{id}', 'MindMapController@getlcbparticipants_ps_mindmap');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_mindmap/{id}', 'MindMapController@removepsgetlcbparticipants_ps_mindmap');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_mindmap/{id}', 'MindMapController@removepsgetlcbguest_ps_mindmap');
Route::match(['get', 'post'], '/getlcbparticipants_mindmap/{id}', 'MindMapController@getlcbparticipants_mindmap');
Route::match(['get', 'post'], '/updatetopicstatusanother_mindmap/', 'MindMapController@updatetopicstatusanother_mindmap');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_mindmap/', 'MindMapController@tocheckanyactivedicussion_mindmap');
Route::match(['get', 'post'], '/updateremainingtimes_mindmap/', 'MindMapController@updateremainingtimes_mindmap');
Route::match(['get', 'post'], '/getactiondetails_mindmap/{id}', 'MindMapController@getactiondetails_mindmap');
Route::match(['get', 'post'], '/updatetimefortopic_mindmap/', 'MindMapController@updatetimefortopic_mindmap');
Route::match(['get', 'post'], '/deletetopics_mindmap/{id}/{mid}', 'MindMapController@deletetopics_mindmap');
Route::match(['get', 'post'], '/deletetopics_bystatus/{status}/{mid}', 'MindMapController@deletetopics_bystatus');
Route::match(['get', 'post'], '/updatetopicname_mindmap/', 'MindMapController@updatetopicname_mindmap');
Route::match(['get', 'post'], '/getcommentdetails_mindmap/{id}/{mid}', 'MindMapController@getcommentdetails_mindmap');
Route::match(['get', 'post'], '/messageentry_comment_mindmap/', 'MindMapController@messageentry_comment_mindmap');
Route::match(['get', 'post'], '/deleteallcomments_mindmap/{id}', 'MindMapController@deleteallcomments_mindmap');
Route::match(['get', 'post'], '/addtoopenclose_mindmap/{tid}/{mid}/{option}', 'MindMapController@addtoopenclose_mindmap');
Route::match(['get', 'post'], '/addcollapsed_mindmap/{tid}/{toption}', 'MindMapController@addcollapsed_mindmap');
Route::match(['get', 'post'], '/gettopicnamedetails_mindmap/{id}', 'MindMapController@gettopicnamedetails_mindmap');
Route::match(['get', 'post'], '/copymindmapdatas/{id}', 'MindMapController@copymindmapdatas');
Route::match(['get', 'post'], '/copymindmapdatas_remove/{id}', 'MindMapController@copymindmapdatas_remove');
Route::match(['get', 'post'], '/copymindmapdatas_update/{id}', 'MindMapController@copymindmapdatas_update');
Route::match(['get', 'post'], '/getreleasename_mindmap/{rid}/{mid}', 'MindMapController@getreleasename_mindmap');
Route::match(['get', 'post'], '/updatereleasename_mindmap/', 'MindMapController@updatereleasename_mindmap');
Route::match(['get', 'post'], '/rowgetreleasename_mindmap/{rid}/{mid}', 'MindMapController@rowgetreleasename_mindmap');
Route::match(['get', 'post'], '/rowupdatereleasename_mindmap/', 'MindMapController@rowupdatereleasename_mindmap');
Route::match(['get', 'post'], '/deletealltopics_mindmap/{id}', 'MindMapController@deletealltopics_mindmap');
Route::match(['get', 'post'], '/removeallvotes_mindmap/{id}', 'MindMapController@removeallvotes_mindmap');
Route::match(['get', 'post'], '/showtherow_mindmap/{id}/{status}', 'MindMapController@showtherow_mindmap');

Route::match(['get', 'post'], '/getgroupedtopics/{id}', 'ValueStreamController@getgroupedtopics');
Route::match(['get', 'post'], '/getgroupedtopics_edit/{id}/{mid}', 'ValueStreamController@getgroupedtopics_edit');
Route::match(['get', 'post'], '/valuestream/{id}', 'ValueStreamController@valuestreamdiscussion');
Route::match(['get', 'post'], '/grouptopics_vs/', 'ValueStreamController@grouptopics_vs');
Route::match(['get', 'post'], '/grouptopics_edit_vs/', 'ValueStreamController@grouptopics_edit_vs');
Route::match(['get', 'post'], '/valuestream-preview/{id}', 'ValueStreamController@previewvaluestreamdiscussion');
Route::match(['get', 'post'], '/getthistopics_vs/{id}', 'ValueStreamController@getthistopics_vs');
Route::match(['get', 'post'], '/addtopicname_vs', 'ValueStreamController@addtopicname_vs');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_vs/{id}', 'ValueStreamController@getfirsttwocolumnsdatas_vs');
Route::match(['get', 'post'], '/exporttocsv_vs/{id}', 'ValueStreamController@exporttocsv_vs');
Route::match(['get', 'post'], '/updatetopicstatus_vs/', 'ValueStreamController@updatetopicstatus_vs');
Route::match(['get', 'post'], '/createpdf_vs', 'ValueStreamController@createpdf_vs');
Route::match(['get', 'post'], '/createpdf_vs/{id}', 'ValueStreamController@createpdf_vs');
Route::match(['get', 'post'], '/getlcbparticipants_ps_vs/{id}', 'ValueStreamController@getlcbparticipants_ps_vs');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_vs/{id}', 'ValueStreamController@removepsgetlcbparticipants_ps_vs');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_vs/{id}', 'ValueStreamController@removepsgetlcbguest_ps_vs');
Route::match(['get', 'post'], '/getlcbparticipants_vs/{id}', 'ValueStreamController@getlcbparticipants_vs');
Route::match(['get', 'post'], '/updatetopicstatusanother_vs/', 'ValueStreamController@updatetopicstatusanother_vs');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_vs/', 'ValueStreamController@tocheckanyactivedicussion_vs');
Route::match(['get', 'post'], '/updateremainingtimes_vs/', 'ValueStreamController@updateremainingtimes_vs');
Route::match(['get', 'post'], '/getactiondetails_vs/{id}', 'ValueStreamController@getactiondetails_vs');
Route::match(['get', 'post'], '/updatetimefortopic_vs/', 'ValueStreamController@updatetimefortopic_vs');
Route::match(['get', 'post'], '/deletetopics_vs/{id}/{mid}', 'ValueStreamController@deletetopics_vs');
Route::match(['get', 'post'], '/deletealltopics_vs/{id}', 'ValueStreamController@deletealltopics_vs');
Route::match(['get', 'post'], '/deletestream/{id}/{mid}', 'ValueStreamController@deletestream');
Route::match(['get', 'post'], '/updatetopicname_vs/', 'ValueStreamController@updatetopicname_vs');
Route::match(['get', 'post'], '/getcommentdetails_vs/{id}/{mid}', 'ValueStreamController@getcommentdetails_vs');
Route::match(['get', 'post'], '/messageentry_comment_vs/', 'ValueStreamController@messageentry_comment_vs');
Route::match(['get', 'post'], '/deleteallcomments_vs/{id}', 'ValueStreamController@deleteallcomments_vs');
Route::match(['get', 'post'], '/addtoopenclose_vs/{tid}/{mid}/{option}', 'ValueStreamController@addtoopenclose_vs');
Route::match(['get', 'post'], '/addcollapsed_vs/{tid}/{toption}', 'ValueStreamController@addcollapsed_vs');
Route::match(['get', 'post'], '/gettopicnamedetails_vs/{id}', 'ValueStreamController@gettopicnamedetails_vs');
Route::match(['get', 'post'], '/getrowtopics_vs/{id}/{status}', 'ValueStreamController@getrowtopics_vs');



Route::match(['get', 'post'], '/newstorymapping/{id}', 'NewStoryMappingController@newstorymappingdiscussion');
Route::match(['get', 'post'], '/getdynamicrowcontents', 'NewStoryMappingController@getdynamicrowcontents');
Route::match(['get', 'post'], '/addtopicname_sm_new', 'NewStoryMappingController@addtopicname_sm_new');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_sm_new/{id}', 'NewStoryMappingController@getfirsttwocolumnsdatas_sm_new');
Route::match(['get', 'post'], '/exporttocsv_sm_new/{id}', 'NewStoryMappingController@exporttocsv_sm_new');
Route::match(['get', 'post'], '/updatetopicstatus_sm_new/', 'NewStoryMappingController@updatetopicstatus_sm_new');
Route::match(['get', 'post'], '/createpdf_sm_new', 'NewStoryMappingController@createpdf_sm_new');
Route::match(['get', 'post'], '/createpdf_sm_new/{id}', 'NewStoryMappingController@createpdf_sm_new');
Route::match(['get', 'post'], '/getlcbparticipants_ps_sm_new/{id}', 'NewStoryMappingController@getlcbparticipants_ps_sm_new');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_sm_new/{id}', 'NewStoryMappingController@removepsgetlcbparticipants_ps_sm_new');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_sm_new/{id}', 'NewStoryMappingController@removepsgetlcbguest_ps_sm_new');
Route::match(['get', 'post'], '/getlcbparticipants_sm_new/{id}', 'NewStoryMappingController@getlcbparticipants_sm_new');
Route::match(['get', 'post'], '/updatetopicstatusanother_sm_new/', 'NewStoryMappingController@updatetopicstatusanother_sm_new');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_sm_new/', 'NewStoryMappingController@tocheckanyactivedicussion_sm_new');
Route::match(['get', 'post'], '/updateremainingtimes_sm_new/', 'NewStoryMappingController@updateremainingtimes_sm_new');
Route::match(['get', 'post'], '/getactiondetails_sm_new/{id}', 'NewStoryMappingController@getactiondetails_sm_new');
Route::match(['get', 'post'], '/updatetimefortopic_sm_new/', 'NewStoryMappingController@updatetimefortopic_sm_new');
Route::match(['get', 'post'], '/deletetopics_sm_new/{id}/{mid}', 'NewStoryMappingController@deletetopics_sm_new');
Route::match(['get', 'post'], '/deletetopics_bystatus/{status}/{mid}', 'NewStoryMappingController@deletetopics_bystatus');
Route::match(['get', 'post'], '/updatetopicname_sm_new/', 'NewStoryMappingController@updatetopicname_sm_new');
Route::match(['get', 'post'], '/getcommentdetails_sm_new/{id}/{mid}', 'NewStoryMappingController@getcommentdetails_sm_new');
Route::match(['get', 'post'], '/messageentry_comment_sm_new/', 'NewStoryMappingController@messageentry_comment_sm_new');
Route::match(['get', 'post'], '/deleteallcomments_sm_new/{id}', 'NewStoryMappingController@deleteallcomments_sm_new');
Route::match(['get', 'post'], '/addtoopenclose_sm_new/{tid}/{mid}/{option}', 'NewStoryMappingController@addtoopenclose_sm_new');
Route::match(['get', 'post'], '/addcollapsed_sm_new/{tid}/{toption}', 'NewStoryMappingController@addcollapsed_sm_new');
Route::match(['get', 'post'], '/gettopicnamedetails_sm_new/{id}', 'NewStoryMappingController@gettopicnamedetails_sm_new');




Route::match(['get', 'post'], '/addtopicname_emap', 'EmapController@addtopicname_emap');
Route::match(['get', 'post'], '/empathymap/{id}', 'EmapController@newemapdiscussion');
Route::match(['get', 'post'], '/empathymap-preview/{id}', 'EmapController@previewnewemapdiscussion');

Route::match(['get', 'post'], '/empathymapnew/{id}', 'EmapController@emapdiscussion');

Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_emapnew/{id}', 'EmapController@getfirsttwocolumnsdatas_emapnew');


Route::match(['get', 'post'], '/updatetopicstatus_emap/', 'EmapController@updatetopicstatus_emap');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_emap/{id}', 'EmapController@getfirsttwocolumnsdatas_emap');
Route::match(['get', 'post'], '/exporttocsv_emap/{id}', 'EmapController@exporttocsv_emap');
Route::match(['get', 'post'], '/createpdf_emap', 'EmapController@createpdf_emap');
Route::match(['get', 'post'], '/createpdf_emap/{id}', 'EmapController@createpdf_emap');
Route::match(['get', 'post'], '/getlcbparticipants_ps_emap/{id}', 'EmapController@getlcbparticipants_ps_emap');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_emap/{id}', 'EmapController@removepsgetlcbparticipants_ps_emap');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_emap/{id}', 'EmapController@removepsgetlcbguest_ps_emap');
Route::match(['get', 'post'], '/getlcbparticipants_emap/{id}', 'EmapController@getlcbparticipants_emap');
Route::match(['get', 'post'], '/updatetopicstatusanother_emap/', 'EmapController@updatetopicstatusanother_emap');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_emap/', 'EmapController@tocheckanyactivedicussion_emap');
Route::match(['get', 'post'], '/updateremainingtimes_emap/', 'EmapController@updateremainingtimes_emap');
Route::match(['get', 'post'], '/getactiondetails_emap/{id}', 'EmapController@getactiondetails_emap');
Route::match(['get', 'post'], '/updatetimefortopic_emap/', 'EmapController@updatetimefortopic_emap');
Route::match(['get', 'post'], '/deletetopics_emap/{id}/{mid}', 'EmapController@deletetopics_emap');
Route::match(['get', 'post'], '/updatetopicname_emap/', 'EmapController@updatetopicname_emap');
Route::match(['get', 'post'], '/getcommentdetails_emap/{id}/{mid}', 'EmapController@getcommentdetails_emap');
Route::match(['get', 'post'], '/messageentry_comment_emap/', 'EmapController@messageentry_comment_emap');
Route::match(['get', 'post'], '/deleteallcomments_emap/{id}', 'EmapController@deleteallcomments_emap');
Route::match(['get', 'post'], '/addcollapsed/{tid}/{toption}', 'EmapController@addcollapsed');
Route::match(['get', 'post'], '/addtoopenclose/{tid}/{mid}/{option}', 'EmapController@addtoopenclose');




Route::match(['get', 'post'], '/discussion11/{id}', 'BoardsController@discussion11');
Route::match(['get', 'post'], '/newdiscussion/{id}', 'BoardsController@newdiscussion');
Route::match(['get', 'post'], '/testdiscussion/{id}', 'BoardsController@testdiscussion');
Route::match(['get', 'post'], '/updatetopicname/', 'BoardsController@updatetopicname');
Route::match(['get', 'post'], '/updatetopicstatus/', 'BoardsController@updatetopicstatus');

Route::match(['get', 'post'], '/swotdiscussion/{id}', 'SwotController@swotdiscussion');


Route::match(['get', 'post'], '/newtestPDF', 'PortfolioCanvasController@newtestPDF');


Route::match(['get', 'post'], '/updatetopicstatus_swot/', 'BoardsController@updatetopicstatus_swot');
Route::match(['get', 'post'], '/getfirsttwocolumnsdatas_swot/{id}', 'SwotController@getfirsttwocolumnsdatas_swot');
Route::match(['get', 'post'], '/messageentry_comment/', 'SwotController@messageentry_comment');
Route::match(['get', 'post'], '/getcommentdetails/{id}/{mid}', 'SwotController@getcommentdetails');
Route::match(['get', 'post'], '/exporttocsv_swot/{id}', 'SwotController@exporttocsv_swot');
Route::match(['get', 'post'], '/createpdf_swot', 'SwotController@createpdf_swot');
Route::match(['get', 'post'], '/createpdf_swot/{id}', 'SwotController@createpdf_swot');
Route::match(['get', 'post'], '/getlcbparticipants_ps_swot/{id}', 'SwotController@getlcbparticipants_ps_swot');
Route::match(['get', 'post'], '/removepsgetlcbparticipants_ps_swot/{id}', 'SwotController@removepsgetlcbparticipants_ps_swot');
Route::match(['get', 'post'], '/removepsgetlcbguest_ps_swot/{id}', 'SwotController@removepsgetlcbguest_ps_swot');
Route::match(['get', 'post'], '/getlcbparticipants_swot/{id}', 'SwotController@getlcbparticipants_swot');
Route::match(['get', 'post'], '/updatetopicstatusanother_swot/', 'SwotController@updatetopicstatusanother_swot');
Route::match(['get', 'post'], '/tocheckanyactivedicussion_swot/', 'SwotController@tocheckanyactivedicussion_swot');
Route::match(['get', 'post'], '/updateremainingtimes_swot/', 'SwotController@updateremainingtimes_swot');
Route::match(['get', 'post'], '/getactiondetails_swot/{id}', 'SwotController@getactiondetails_swot');
Route::match(['get', 'post'], '/updatetimefortopic_swot/', 'SwotController@updatetimefortopic_swot');

Route::match(['get', 'post'], '/updatetopicstatusanother/', 'BoardsController@updatetopicstatusanother');
Route::match(['get', 'post'], '/showmovedtopics/{id}', 'BoardsController@showmovedtopics');
Route::match(['get', 'post'], '/discussingtopics/{id}', 'BoardsController@discussingtopics');
Route::match(['get', 'post'], '/changetopicstatus/', 'BoardsController@changetopicstatus');
Route::match(['get', 'post'], '/updatetimefortopic/', 'BoardsController@updatetimefortopic');

Route::match(['get', 'post'], '/messageentry/', 'BoardsController@messageentry');
Route::match(['get', 'post'], '/topicdiscussionmessage/{id}', 'BoardsController@topicdiscussionmessage');
Route::match(['get', 'post'], '/topicdiscussionmessage/{id}/{mid}', 'BoardsController@topicdiscussionmessage');
Route::match(['get', 'post'], '/deletecomments/{id}', 'BoardsController@deletecomments');
Route::match(['get', 'post'], '/deleteallcomments/{id}', 'BoardsController@deleteallcomments');
Route::match(['get', 'post'], '/updateremainingtimes/', 'BoardsController@updateremainingtimes');

Route::match(['get', 'post'], '/tocheckanyactivedicussion/', 'BoardsController@tocheckanyactivedicussion');
Route::match(['get', 'post'], '/addactiondetails/', 'BoardsController@addactiondetails');
Route::match(['get', 'post'], '/getactiondetails/{id}', 'BoardsController@getactiondetails');

Route::match(['get', 'post'], '/getactioncomments/{id}', 'BoardsController@getactioncomments');
Route::match(['get', 'post'], '/getactiondetailsd/{id}', 'BoardsController@getactiondetailsd');
Route::match(['get', 'post'], '/removeactions/{id}', 'BoardsController@removeactions');
Route::match(['get', 'post'], '/changestatusofthemeeting/{id}', 'BoardsController@changestatusofthemeeting');
Route::match(['get', 'post'], '/changestatusofthemeetingboard/{id}', 'BoardsController@changestatusofthemeetingboard');
Route::match(['get', 'post'], '/getstatusofthemeeting/{id}', 'BoardsController@getstatusofthemeeting');
Route::match(['get', 'post'], '/createpdf', 'BoardsController@createpdf');
Route::match(['get', 'post'], '/createpdf/{id}', 'BoardsController@createpdf');





Route::match(['get', 'post'], '/createpdf/{current_mid}/{from}/{to}', 'BoardsController@createpdf');

Route::match(['get', 'post'], '/participantjoinedmessages/{id}', 'BoardsController@participantjoinedmessages');
Route::match(['get', 'post'], '/participantleftmessages/{id}', 'BoardsController@participantleftmessages');

Route::match(['get', 'post'], '/guestjoinedmessages/{id}', 'BoardsController@guestjoinedmessages');
Route::match(['get', 'post'], '/guestleftmessages/{id}', 'BoardsController@guestleftmessages');


Route::match(['get', 'post'], '/currentdiscussingtopics/{id}', 'BoardsController@currentdiscussingtopics');
Route::match(['get', 'post'], '/gettopicsdetails/{id}', 'BoardsController@gettopicsdetails');
Route::match(['get', 'post'], '/viewalltopics/{id}', 'BoardsController@viewalltopics');
Route::match(['get', 'post'], '/gettopicnamedetails/{id}', 'BoardsController@gettopicnamedetails');
Route::match(['get', 'post'], '/columnone_topics/{id}', 'BoardsController@columnone_topics');
Route::match(['get', 'post'], '/columntwo_topics/{id}', 'BoardsController@columntwo_topics');
Route::match(['get', 'post'], '/columnthree_topics/{id}', 'BoardsController@columnthree_topics');
Route::match(['get', 'post'], '/removeallvotes/{id}', 'BoardsController@removeallvotes');
Route::match(['get', 'post'], '/deletealltopics/{id}', 'BoardsController@deletealltopics');
Route::match(['get', 'post'], '/shownamestatus', 'BoardsController@shownamestatus');
Route::match(['get', 'post'], '/printPDF', 'BoardsController@printPDF');
Route::match(['get', 'post'], '/exporttocsv/{id}', 'BoardsController@exporttocsv');
Route::match(['get', 'post'], '/changetimersound', 'BoardsController@changetimersound');
Route::match(['get', 'post'], '/topics_sorting/{id}', 'BoardsController@topics_sorting');
Route::match(['get', 'post'], '/setconferencestatus/{id}/{sid}', 'BoardsController@setconferencestatus');
Route::match(['get', 'post'], '/mergetopics', 'BoardsController@mergetopics');
Route::match(['get', 'post'], '/gettopicsonly/{id}', 'BoardsController@gettopicsonly');



Route::match(['get', 'post'], '/firstcolumn_topics_swot/{id}', 'SwotController@firstcolumn_topics_swot');
Route::match(['get', 'post'], '/secondcolumn_topics_swot/{id}', 'SwotController@secondcolumn_topics_swot');
Route::match(['get', 'post'], '/thirdcolumn_topics_swot/{id}', 'SwotController@thirdcolumn_topics_swot');
Route::match(['get', 'post'], '/fourthcolumn_topics_swot/{id}', 'SwotController@fourthcolumn_topics_swot');
Route::match(['get', 'post'], '/fifthcolumn_topics_swot/{id}', 'SwotController@fifthcolumn_topics_swot');

Route::match(['get', 'post'], '/firstcolumn_topics_emap/{id}', 'EmapController@firstcolumn_topics_emap');
Route::match(['get', 'post'], '/secondcolumn_topics_emap/{id}', 'EmapController@secondcolumn_topics_emap');
Route::match(['get', 'post'], '/thirdcolumn_topics_emap/{id}', 'EmapController@thirdcolumn_topics_emap');
Route::match(['get', 'post'], '/fourthcolumn_topics_emap/{id}', 'EmapController@fourthcolumn_topics_emap');
Route::match(['get', 'post'], '/fifthcolumn_topics_emap/{id}', 'EmapController@fifthcolumn_topics_emap');
Route::match(['get', 'post'], '/sixthcolumn_topics_emap/{id}', 'EmapController@sixthcolumn_topics_emap');


Route::match(['get', 'post'], '/firstcolumn_topics_emapnew/{id}', 'EmapController@firstcolumn_topics_emapnew');
Route::match(['get', 'post'], '/secondcolumn_topics_emapnew/{id}', 'EmapController@secondcolumn_topics_emapnew');
Route::match(['get', 'post'], '/thirdcolumn_topics_emapnew/{id}', 'EmapController@thirdcolumn_topics_emapnew');
Route::match(['get', 'post'], '/fourthcolumn_topics_emapnew/{id}', 'EmapController@fourthcolumn_topics_emapnew');
Route::match(['get', 'post'], '/fifthcolumn_topics_emapnew/{id}', 'EmapController@fifthcolumn_topics_emapnew');
Route::match(['get', 'post'], '/sixthcolumn_topics_emapnew/{id}', 'EmapController@sixthcolumn_topics_emapnew');


Route::match(['get', 'post'], '/firstcolumn_topics_pvnew/{id}', 'ProductvisionController@firstcolumn_topics_pvnew');
Route::match(['get', 'post'], '/secondcolumn_topics_pvnew/{id}', 'ProductvisionController@secondcolumn_topics_pvnew');
Route::match(['get', 'post'], '/thirdcolumn_topics_pvnew/{id}', 'ProductvisionController@thirdcolumn_topics_pvnew');
Route::match(['get', 'post'], '/fourthcolumn_topics_pvnew/{id}', 'ProductvisionController@fourthcolumn_topics_pvnew');
Route::match(['get', 'post'], '/fifthcolumn_topics_pvnew/{id}', 'ProductvisionController@fifthcolumn_topics_pvnew');

Route::match(['get', 'post'], '/firstcolumn_topics_vsnew/{id}', 'ValueStreamController@firstcolumn_topics_vsnew');
Route::match(['get', 'post'], '/secondcolumn_topics_vsnew/{id}', 'ValueStreamController@secondcolumn_topics_vsnew');
Route::match(['get', 'post'], '/thirdcolumn_topics_vsnew/{id}', 'ValueStreamController@thirdcolumn_topics_vsnew');


Route::match(['get', 'post'], '/firstrow_sailboat_topics/{id}', 'SailboatController@firstrow_sailboat_topics');
Route::match(['get', 'post'], '/secondrow_sailboat_topics/{id}', 'SailboatController@secondrow_sailboat_topics');
Route::match(['get', 'post'], '/thirdrow_sailboat_topics/{id}', 'SailboatController@thirdrow_sailboat_topics');
Route::match(['get', 'post'], '/fourthrow_sailboat_topics/{id}', 'SailboatController@fourthrow_sailboat_topics');

Route::match(['get', 'post'], '/firstcolumn_leancanvas_topics/{id}', 'LeanCanvasController@firstcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/secondcolumn_leancanvas_topics/{id}', 'LeanCanvasController@secondcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/thirdcolumn_leancanvas_topics/{id}', 'LeanCanvasController@thirdcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/fourthcolumn_leancanvas_topics/{id}', 'LeanCanvasController@fourthcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/fifthcolumn_leancanvas_topics/{id}', 'LeanCanvasController@fifthcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/sixthcolumn_leancanvas_topics/{id}', 'LeanCanvasController@sixthcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/seventhcolumn_leancanvas_topics/{id}', 'LeanCanvasController@seventhcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/eighthcolumn_leancanvas_topics/{id}', 'LeanCanvasController@eighthcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/ninethcolumn_leancanvas_topics/{id}', 'LeanCanvasController@ninethcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/tenthcolumn_leancanvas_topics/{id}', 'LeanCanvasController@tenthcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/eleventhcolumn_leancanvas_topics/{id}', 'LeanCanvasController@eleventhcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/twelvthcolumn_leancanvas_topics/{id}', 'LeanCanvasController@twelvthcolumn_leancanvas_topics');
Route::match(['get', 'post'], '/thirteenthcolumn_leancanvas_topics/{id}', 'LeanCanvasController@thirteenthcolumn_leancanvas_topics');



Route::match(['get', 'post'], '/firstcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@firstcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/secondcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@secondcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/thirdcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@thirdcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/fourthcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@fourthcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/fifthcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@fifthcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/sixthcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@sixthcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/seventhcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@seventhcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/eighthcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@eighthcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/ninethcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@ninethcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/tenthcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@tenthcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/eleventhcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@eleventhcolumn_portfoliocanvas_topics');
Route::match(['get', 'post'], '/twelvthcolumn_portfoliocanvas_topics/{id}', 'PortfolioCanvasController@twelvthcolumn_portfoliocanvas_topics');


Route::match(['get', 'post'], '/firstcolumn_leanplanning_topics/{id}', 'LeanPlanningController@firstcolumn_leanplanning_topics');
Route::match(['get', 'post'], '/secondcolumn_leanplanning_topics/{id}', 'LeanPlanningController@secondcolumn_leanplanning_topics');
Route::match(['get', 'post'], '/thirdcolumn_leanplanning_topics/{id}', 'LeanPlanningController@thirdcolumn_leanplanning_topics');
Route::match(['get', 'post'], '/fourthcolumn_leanplanning_topics/{id}', 'LeanPlanningController@fourthcolumn_leanplanning_topics');
Route::match(['get', 'post'], '/fifthcolumn_leanplanning_topics/{id}', 'LeanPlanningController@fifthcolumn_leanplanning_topics');
Route::match(['get', 'post'], '/sixthcolumn_leanplanning_topics/{id}', 'LeanPlanningController@sixthcolumn_leanplanning_topics');
Route::match(['get', 'post'], '/seventhcolumn_leanplanning_topics/{id}', 'LeanPlanningController@seventhcolumn_leanplanning_topics');
Route::match(['get', 'post'], '/eighthcolumn_leanplanning_topics/{id}', 'LeanPlanningController@eighthcolumn_leanplanning_topics');

Route::match(['get', 'post'], '/firstcolumn_topics_smnew/{id}', 'StoryMappingController@firstcolumn_topics_smnew');
Route::match(['get', 'post'], '/secondcolumn_topics_smnew/{id}', 'StoryMappingController@secondcolumn_topics_smnew');
Route::match(['get', 'post'], '/thirdcolumn_topics_smnew/{id}', 'StoryMappingController@thirdcolumn_topics_smnew');
Route::match(['get', 'post'], '/fourthcolumn_topics_smnew/{id}', 'StoryMappingController@fourthcolumn_topics_smnew');
Route::match(['get', 'post'], '/fifthcolumn_topics_smnew/{id}', 'StoryMappingController@fifthcolumn_topics_smnew');

Route::match(['get', 'post'], '/smcolumn_topics/{id}/{status}', 'StoryMappingController@smcolumn_topics');
Route::match(['get', 'post'], '/firstcolumn_topics_smnewsm/{id}', 'StoryMappingController@firstcolumn_topics_smnew');
Route::match(['get', 'post'], '/firsttworowdiscussion/{id}/{status}', 'StoryMappingController@firsttworowdiscussion');

Route::match(['get', 'post'], '/oscolumn_topics/{id}/{status}', 'OpenSpaceController@oscolumn_topics');
Route::match(['get', 'post'], '/firstcolumntopics_os/{id}', 'OpenSpaceController@firstcolumntopics_os');
Route::match(['get', 'post'], '/firstrowwdiscussion/{id}/{status}', 'OpenSpaceController@firstrowwdiscussion');

Route::match(['get', 'post'], '/showtherow_fb/{id}/{status}', 'FishBoneController@showtherow_fb');




Route::match(['get', 'post'], '/firstcolumn_topics/{id}', 'BoardsController@firstcolumn_topics');
Route::match(['get', 'post'], '/secondcolumn_topics/{id}', 'BoardsController@secondcolumn_topics');
Route::match(['get', 'post'], '/thirdcolumn_topics/{id}', 'BoardsController@thirdcolumn_topics');
Route::match(['get', 'post'], '/fourthcolumn_topics/{id}', 'BoardsController@fourthcolumn_topics');
Route::match(['get', 'post'], '/topics_load/{id}', 'BoardsController@topics_load');
Route::match(['get', 'post'], '/topics_load_vote_only/{id}', 'BoardsController@topics_load_vote_only');

// for agenda meeting

Route::match(['get', 'post'], '/getagendaparticipants/{id}', 'AgendaController@getagendaparticipants');
Route::match(['get', 'post'], '/checkagendameetinglivestatus/{id}', 'AgendaController@checkagendameetinglivestatus');
Route::match(['get', 'post'], '/agendameeting/{id}', 'AgendaController@agendameeting');
Route::match(['get', 'post'], '/delete_agenda_meeting/{id}', 'AgendaController@delete_agenda_meeting');
Route::match(['get', 'post'], '/addattendeerequest_agenda', 'AgendaController@addattendeerequest_agenda');
Route::match(['get', 'post'], '/removethisattendee_agenda/{id}', 'AgendaController@removethisattendee_agenda');
Route::match(['get', 'post'], '/addagendameeting', 'AgendaController@addagendameeting');
Route::match(['get', 'post'], '/editagendameeting', 'AgendaController@editagendameeting');
Route::match(['get', 'post'], '/addagendameetingitem', 'AgendaController@addagendameetingitem');
Route::match(['get', 'post'], '/showagendadiscussiondetails', 'AgendaController@showagendadiscussiondetails');
Route::match(['get', 'post'], '/agendameeting/{id}/{item_id}', 'AgendaController@agendameeting');
Route::match(['get', 'post'], '/addlinksfor_agenda', 'AgendaController@addlinksfor_agenda');
Route::match(['get', 'post'], '/removelinkid/{id}', 'AgendaController@removelinkid');
Route::match(['get', 'post'], '/agenda_item_notes_entry', 'AgendaController@agenda_item_notes_entry');
Route::match(['get', 'post'], '/agenda_links_notes_actions/{id}', 'AgendaController@agenda_links_notes_actions');
Route::match(['get', 'post'], '/getallnotes/{id}', 'AgendaController@getallnotes');
Route::match(['get', 'post'], '/removenotesid/{id}', 'AgendaController@removenotesid');
Route::match(['get', 'post'], '/agenda_item_actions_entry', 'AgendaController@agenda_item_actions_entry');
Route::match(['get', 'post'], '/getallactions/{id}', 'AgendaController@getallactions');
Route::match(['get', 'post'], '/removeactionsid/{id}', 'AgendaController@removeactionsid');
Route::match(['get', 'post'], '/editagendameetingitem', 'AgendaController@editagendameetingitem');
Route::match(['get', 'post'], '/delete_agenda_items/{id}/{mid}', 'AgendaController@delete_agenda_items');
Route::match(['get', 'post'], '/startthismeeting/{id}', 'AgendaController@startthismeeting');
Route::match(['get', 'post'], '/endthismeeting/{id}', 'AgendaController@endthismeeting');
Route::match(['get', 'post'], '/createagendapdf', 'AgendaController@createagendapdf');
Route::match(['get', 'post'], '/createagendapdf/{current_mid}', 'AgendaController@createagendapdf');
Route::match(['get', 'post'], '/agenda_sorting/{id}', 'AgendaController@agenda_sorting');
Route::match(['get', 'post'], '/guest_choice/{mid}/{id}', 'AgendaController@guest_choice');
// for agenda meeting

Route::match(['get', 'post'], '/paypalpayment', 'RegLoginController@paypalpayment');
Route::match(['get', 'post'], '/advancepaypalpayment', 'RegLoginController@advancepaypalpayment');

Route::match(['get', 'post'], '/advancerazorpayment', 'RegLoginController@advancerazorpayment');
Route::match(['post'], '/advancerazorpayresponse', 'RegLoginController@advancerazorpayresponse');

Route::match(['get', 'post'], '/razorpayment', 'RegLoginController@razorpayment');
Route::match(['post'], '/razorpayresponse', 'RegLoginController@razorpayresponse');

Route::match(['get', 'post'], '/upgraderazorpayment', 'RegLoginController@upgraderazorpayment');
Route::match(['post'], '/upgraderazorpayresponse', 'RegLoginController@upgraderazorpayresponse');

});
// after login


// admin side

Route::match(['get', 'post'], '/admin/index', 'Admin\AdminController@index');
Route::match(['get', 'post'], '/admin/forgetpassword', 'Admin\AdminController@forgetpassword');

Route::middleware(['adminID'])->group(function() {

Route::match(['get', 'post'], '/admin/home', 'Admin\AdminController@home');

Route::match(['get', 'post'], '/admin/logout', 'Admin\AdminController@logout');

Route::match(['get', 'post'], '/admin/profile', 'Admin\AdminController@profile');

Route::match(['get', 'post'], '/admin/cart', 'Admin\AdminController@cart');

Route::match(['get', 'post'], '/admin/seo', 'Admin\AdminController@seo');
Route::match(['get', 'post'], '/admin/editseo/{id}', 'Admin\AdminController@editseo');
Route::match(['get', 'post'], '/admin/deleteseo/{id}', 'Admin\AdminController@deleteseo');


Route::match(['get', 'post'], '/admin/changepassword', 'Admin\AdminController@changepassword');

Route::match(['get', 'post'], '/admin/faq', 'Admin\AdminController@faq');
Route::match(['get', 'post'], '/admin/newfaq', 'Admin\AdminController@newfaq');
Route::match(['get', 'post'], '/admin/editfaq/{id}', 'Admin\AdminController@editfaq');
Route::match(['get', 'post'], '/admin/deletefaq/{id}', 'Admin\AdminController@deletefaq');

Route::match(['get', 'post'], '/admin/clients', 'Admin\AdminController@clients');
Route::match(['get', 'post'], '/admin/newclient', 'Admin\AdminController@newclient');
Route::match(['get', 'post'], '/admin/editclient/{id}', 'Admin\AdminController@editclient');
Route::match(['get', 'post'], '/admin/deleteclient/{id}', 'Admin\AdminController@deleteclient');

Route::match(['get', 'post'], '/admin/headerbanners', 'Admin\AdminController@headerbanners');
Route::match(['get', 'post'], '/admin/newheaderbanner', 'Admin\AdminController@newheaderbanner');
Route::match(['get', 'post'], '/admin/editheaderbanner/{id}', 'Admin\AdminController@editheaderbanner');

Route::match(['get', 'post'], '/admin/contactdetails', 'Admin\AdminController@contactdetails');
Route::match(['get', 'post'], '/admin/whatislcb', 'Admin\AdminController@whatislcb');

Route::match(['get', 'post'], '/admin/helpcategory', 'Admin\AdminController@helpcategory');
Route::match(['get', 'post'], '/admin/newhelpcategory', 'Admin\AdminController@newhelpcategory');
Route::match(['get', 'post'], '/admin/edithelpcategory/{id}', 'Admin\AdminController@edithelpcategory');
Route::match(['get', 'post'], '/admin/deletehelpcategory/{id}', 'Admin\AdminController@deletehelpcategory');

Route::match(['get', 'post'], '/admin/helpsubcategory/{catid}', 'Admin\AdminController@helpsubcategory');
Route::match(['get', 'post'], '/admin/newhelpsubcategory/{catid}', 'Admin\AdminController@newhelpsubcategory');
Route::match(['get', 'post'], '/admin/edithelpsubcategory/{catid}/{id}', 'Admin\AdminController@edithelpsubcategory');
Route::match(['get', 'post'], '/admin/deletehelpsubcategory/{id}', 'Admin\AdminController@deletehelpsubcategory');

Route::match(['get', 'post'], '/admin/help', 'Admin\AdminController@help');
Route::match(['get', 'post'], '/admin/newhelp', 'Admin\AdminController@newhelp');
Route::match(['get', 'post'], '/admin/edithelp/{id}', 'Admin\AdminController@edithelp');
Route::match(['get', 'post'], '/admin/subcat/{id}', 'Admin\AdminController@getSubcat');
Route::match(['get', 'post'], '/admin/deletehelp/{id}', 'Admin\AdminController@deletehelp');


Route::match(['get', 'post'], '/admin/pricing', 'Admin\AdminController@pricing');
Route::match(['get', 'post'], '/admin/newpricing', 'Admin\AdminController@newpricing');
Route::match(['get', 'post'], '/admin/editpricing/{id}', 'Admin\AdminController@editpricing');
Route::match(['get', 'post'], '/admin/deletepricing/{id}', 'Admin\AdminController@deletepricing');

Route::match(['get', 'post'], '/admin/cms', 'Admin\AdminController@cms');
Route::match(['get', 'post'], '/admin/editcms/{id}', 'Admin\AdminController@editcms');

Route::match(['get', 'post'], '/admin/functionality', 'Admin\AdminController@functionality');
Route::match(['get', 'post'], '/admin/newfunctionality', 'Admin\AdminController@newfunctionality');
Route::match(['get', 'post'], '/admin/editfunctionality/{id}', 'Admin\AdminController@editfunctionality');
Route::match(['get', 'post'], '/admin/deletefunctionality/{id}', 'Admin\AdminController@deletefunctionality');

Route::match(['get', 'post'], '/admin/news', 'Admin\AdminController@news');
Route::match(['get', 'post'], '/admin/newnews', 'Admin\AdminController@newnews');
Route::match(['get', 'post'], '/admin/editnews/{id}', 'Admin\AdminController@editnews');
Route::match(['get', 'post'], '/admin/deletenews/{id}', 'Admin\AdminController@deletenews');
Route::match(['get', 'post'], '/admin/viewnews/{id}', 'Admin\AdminController@viewnews');

Route::match(['get', 'post'], '/admin/cropimage', 'Admin\AdminController@cropimage');
Route::match(['get', 'post'], '/admin/cropimagetwo', 'Admin\AdminController@cropimagetwo');

Route::match(['get', 'post'], '/admin/social_links', 'Admin\AdminController@social_links');
Route::match(['get', 'post'], '/admin/contactlist', 'Admin\AdminController@contactlist');
Route::match(['get', 'post'], '/admin/deletecontact/{id}', 'Admin\AdminController@deletecontact');

Route::match(['get', 'post'], '/admin/userfaq', 'Admin\AdminController@userfaq');
Route::match(['get', 'post'], '/admin/deleteuserfaq/{id}', 'Admin\AdminController@deleteuserfaq');
Route::match(['get', 'post'], '/admin/subscribers', 'Admin\AdminController@subscribers');
Route::match(['get', 'post'], '/admin/deletesubscribers/{id}', 'Admin\AdminController@deletesubscribers');

Route::match(['get', 'post'], '/admin/imageupload', 'Admin\AdminController@imageupload');
Route::match(['get', 'post'], '/admin/uploadimage', 'Admin\AdminController@uploadimage');

Route::match(['get', 'post'], '/admin/editprofile', 'Admin\AdminController@editprofile');
Route::match(['get', 'post'], '/admin/state/{id}', 'Admin\AdminController@getStates');
Route::match(['get', 'post'], '/admin/city/{id}', 'Admin\AdminController@getCities');


Route::match(['get', 'post'], '/admin/facilitators', 'Admin\AdminController@facilitators');
Route::match(['get', 'post'], '/admin/attendees', 'Admin\AdminController@attendees');


});
// admin side



