@extends('layouts.default')
@section('content')
<meta name="csrf-token" content="{{ csrf_token() }}">
<?php
$sociallinks = App\Http\Controllers\Controller::sociallinks();
$subscriptiondetails = App\Http\Controllers\Controller::subscriptiondetails();
$userdetails = App\Http\Controllers\Controller::userdetails();

if($userdetails->user_ccbname == '')
{
	$cur_name = $userdetails->user_name."'s Coffee Club";
}
else
{
	$cur_name = $userdetails->user_ccbname;
}
$facdetails = App\Http\Controllers\Controller::fac_lists();
$totusers = 1 + count($facdetails);


$fdate = date("Y-m-d");
$tdate = $subscriptiondetails->send_date;
$datetime1 = new DateTime($fdate);
$datetime2 = new DateTime($tdate);
$interval = $datetime1->diff($datetime2);
$days = $interval->format('%a');


?>
<style type="text/css">
.panel-body p{ color:#FFFFFF;}
.alphaonly
{
	margin-top:8px;
	font-size:18px;
	color:#545454;
	-moz-border-radius: 2px;
	-webkit-border-radius: 2px;
	-border-radius: 2px;
	display:none;
	width:280px;
	
}

label
{
	float:left;
	margin-top:8px;
	font-size:18px;
	color:#545454;
	-moz-border-radius: 2px;
	-webkit-border-radius: 2px;
	-border-radius: 2px;
}


.clear
{
	clear:both;
	height:20px;
}

.edit
{
	float:left;
	background:url(user/images/edit.png) no-repeat;
	width:32px;
	height:32px;
	display:block;
	cursor: pointer;
	margin-left:10px;
}

</style>
<div id="page-banner-area" class="page-banner-area" style="background-image:url({{url('admin/dist/img/bannerimages/'.$totpbanner->b_image)}})">
  <!-- Subpage title start -->
  <div class="page-banner-title">
    <div class="text-center">
      <h2>Your Account</h2>
      <ol class="breadcrumb">
        <li> <a href="{{url('/')}}">Home /</a> </li>
        <li>Your Account</li>
      </ol>
    </div>
  </div>
  <!-- Subpage title end -->
</div>
<section class="ts-faq-sec">
  <div class="container">
  <div class="row" style="padding-bottom:20px">
            <div class="col-lg-12 col-md-12 wow fadeInUp" data-wow-duration="1.5s" data-wow-delay="400ms">
              <div class="alert alert-primary" role="alert">
              @if($subscription_details->sstatus == '1')
              You have <span data-bind="text:dayLeftInTrial">{{$days}}</span> days left on your Lean Coffee Brew {{$tinfo}}.
              <a href='{{url('advancepaypalpayment')}}'><button class="ere_btn" type="button">Advance Subscription</button></a>
              @else
              <span class="myerror">Your subscription was cancelled. If you wish to re-activate it, please use Manage Subscription below.</span>
              @endif
              </div>
            </div>
          </div>
    <div class="row">
      <div class="col-lg-8" style="border-right: 1px dashed #333;">
        <div class="faq-content mb-70">
          <h2 class="column-title"> Your Account </h2>
          <div class="panel-group faq-item" id="accordion" role="tablist" aria-multiselectable="true">
            <p><strong>Hi {{$userdetails->user_name}}, Welcome to Lean Coffee Brew.</strong></p>
            
            <p>
            <div class="table-responsive">
              <table class="table table-bordered">          
              <tr>
              <td width="30%"><p style="color:#F60; font-size:20px;">Coffee Club Brew : </p></td><td width="70%"><label class="text_label">{{ucfirst($cur_name)}}</label><div class="edit" title="Click to edit your lean coffee brew name"></div><input type="text" name="lcbname" value="{{ucfirst($cur_name)}}" class="alphaonly" maxlength="25"/></td>              
              </tr>
              </table>
              </div>
            </p>
            
            <p>&nbsp;</p>
            <h2 class="column-title"> Subscription Details </h2>
            <div class="table-responsive">
              <table class="table table-bordered">
                <tbody>
                  <tr>
                    <td><strong>Subscription Type</strong></td>
                    <td>{{$subscription_details->snofacilitators}} Barista(s)</td>
                  </tr>
                  <tr>
                    <td><strong>Cost</strong></td>
                    <td>${{$subscription_details->stotalprice}}
                    @if($subscription_details->sbilling == '1') 
                    
                    /year 
                    
                    @else 
                    
                     @if($subscription_details->sbilling == '0')  /month @else for {{$subscription_details->sbilling}} months @endif 
                     
                    @endif</td>
                  </tr>
                  <tr>
                    <td width="50%"><button class="btn btn-primary btn-xs term-service" data-toggle="modal" data-target="#subscriptondetails">Manage Subscription</button></td>
                    @if($tinfo == 'subscription')
                    @if($priceinfo >= 1)  
                    @if($subscription_details->sstatus == 1)             
                    <td width="50%"><a class="btn btn-primary btn-xs term-service" href="{{url('upgrade_subscription')}}">Upgrade Subscription</a></td>
                     @endif
                    @endif
                    @else
                    <td width="50%"d>&nbsp;</td>
                    @endif
                  </tr>
                </tbody>
              </table>
            </div>
            <p>&nbsp;</p>
            <h2 class="column-title"> Baristas </h2>
            <table class="table table-bordered">
              <tbody>
                <tr>
                  <td><p align="justify"> Any named barista in the 'Coffee Club Brew' (see below), can facilitate sessions with functionality including; create and export actions and no adverts.</p>
                    <p align="justify"> Note: The 'Coffee Club Brew' is defined when the first person pays for the Espresso version of Lean Coffee Brew. Other baristas can then be added to the 'Coffee Club', up to the maximum number of that subscription. </p></td>
                </tr>
                <tr>
                  <td><strong>Current Baristas : {{$totusers}} / {{$subscriptiondetails->snofacilitators}}</strong></td>
                </tr>
                @if($subscriptiondetails->snofacilitators >= 2)
                <tr>
                  <td colspan="2"><button class="btn btn-primary btn-xs term-service" data-toggle="modal" data-target="#manageFacilitators">Manage Baristas</button></td>
                  
                </tr>
                @endif
              </tbody>
            </table>
          </div>
          <!-- panel-group -->
        </div>
      </div>
      <!-- col end -->
      <div class="col-lg-4"> @include('common.usermenu') </div>
      <!-- col end-->
    </div>
    <!-- row end-->
  </div>
  <!-- .container end -->
</section>
<div id="manageFacilitators" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Baristas</h4><button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
      <div class="modal-body">
        <div id="listfac">
        <table class="table table-bordered">
          <tr>
            <td>{{$userdetails->user_emailid}}</td>
            <td>{{$userdetails->user_name}}</td>
            <td></td>
          </tr>
          @foreach($facdetails as $fc)
          <tr id="user_id_{{$fc->rid}}">
          	<td>{{$fc->remailid}}</td>
            <td></td>
            <td><a class="re_btn btn-danger btn-sm delete-facilitators"  data-id="{{ $fc->rid }}" href="javascript:void(0)" alt="Delete" title="Delete">REMOVE</a></td>
          </tr>
          @endforeach
        </table>
        </div>
        <p><strong>Invite user to Coffee Club Brew.</strong></p>
        <p>Enter the email address of the person you wish to invite to your Coffee Club below and press the plus button.</p>
        <form method="post" action="" name="emrequest_form" id="emrequest_form">{{ csrf_field() }}
        <div class="input-group">
          <input type="email" class="form-control" required name="reqemail" id="reqemail" AUTOCOMPLETE="OFF">
          <span class="input-group-btn">
          <button class="btn btn-default" type="submit" name="reqbutton" id="reqbutton">+</button>
          </span> </div>
          </form>
           <p id="loadingimage" style="display:none"><img src="{{url('user/images/emailsending.gif')}}" alt="emailsending"/></p>
      </div>
      
    </div>
  </div>
</div>

<div id="manageFacilitators2" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Delete?</h4>
      </div>
      <div class="modal-body">

      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
    </div>
  </div>
</div>

<div id="subscriptondetails" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Manage Subscription</h4><button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
      </div>
      <div class="modal-body">
      <table class="table table-bordered">
          <tr><td>
		{{$subscription_details->snofacilitators}} Barista(s) - ${{$subscription_details->stotalprice}}
        
        
        @if($subscription_details->sbilling == '1') 
                    
                    /year 
                    
                    @else 
                    
                     @if($subscription_details->sbilling == '0')  /month @else for {{$subscription_details->sbilling}} months @endif 
                     
                    @endif
        </td></tr>
        
        <tr><td>@if($subscription_details->sstatus == '1')Your subscription will be cancelled on {{ \Carbon\Carbon::parse($subscription_details->send_date)->format('F d, Y')}} @else Your subscription has been cancelled. <a href='{{url('paypalpayment')}}'><button class="ere_btn" type="button">Reactivate Subscription</button></a> @endif
        
        </td></tr>
        
        <tr><td><i class="fa fa-user"></i>&nbsp;<a data-toggle="modal" data-target="#accountinfo" style="cursor:pointer; color:#F60; font-weight:bold;">Account Information</a></td></tr>
        <tr><td><i class="fa fa-map-marker"></i>&nbsp;<a data-toggle="modal" data-target="#billinginfo" style="cursor:pointer; color:#F60; font-weight:bold;">Billing & Shipping Addresses</a></td></tr>
        
        <tr><td><i class="fa fa-history"></i>&nbsp;<a data-toggle="modal" data-target="#billinghistoryinfo" style="cursor:pointer; color:#F60; font-weight:bold;">Billing History</a></td></tr>
        
        
        </table>
      </div>
      
    </div>
  </div>
</div>


<div id="billinghistoryinfo" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Billing History</h4>
      </div>
      <div class="modal-body">
      @if($hcounts == 0)
      No Billing History to display
      @else
      <div class="table-responsive">
    <table class="table table-bordered">
    <thead>
    <tr>
    	<th>Payment method</th>
        <th>Transaction ID</th>
        <th>Payment date</th>
    </tr>
    </thead>
    <tbody>
    @foreach($payment_history_info as $history)
    <tr>
    	<td>Paypal</td>
        <td>{{$history->pay_trans_id}}</td>
        <td>
        <?php $pdate = explode("T",$history->pay_payment_date);
        
        echo  date("F d, Y", strtotime($pdate[0]));?>
        </td>
    </tr>
    @endforeach
    </tbody>    
    </table>
      </div>
      @endif
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">BACK</button>
      </div>
    </div>
  </div>
</div>


<div id="accountinfo" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Account details</h4>
      </div>
      <div class="modal-body">
     
      <form class="form-signin" name="acc_detail_form" id="acc_detail_form" action="" method="post">{{ csrf_field() }}
       <div id="infodetails" style="display:none; color:#F60">Account details updated!!!</div>
            <div class="table-responsive"><table class="table table-bordered">
              <tbody>
                <tr>
                  <td>Name</td>
                  <td><input type="text" name="newuser_name" id="newuser_name" value="{{$userdetails->user_name}}" class="form-control" maxlength="30"/></td>
                </tr>
                <tr>
                  <td>Email ID</td>
                  <td><input type="text" name="user_email" id="user_email" value="{{$userdetails->user_emailid}}" class="form-control"  disabled="disabled"/></td>
                </tr>
                 <tr>
                  <td></td>
                  <td><button class="loginbtn btn-primary btn-small" type="submit" name="updatebutton" id="updatebutton">Update</button>&nbsp;<button type="button" class="loginbtn btn-primary btn-small" data-dismiss="modal">BACK</button></td>
                </tr>
              </tbody>
            </table></div>
            </form>
      </div>
      <div class="modal-footer">
        
      </div>
    </div>
  </div>
</div>

<div id="billinginfo" class="modal fade" role="dialog">
  <div class="modal-dialog">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title">Billing & Shipping Addresses</h4>
      </div>
      <div class="modal-body">
     
      <form class="form-signin" name="billing_form" id="billing_form" action="" method="post">{{ csrf_field() }}
       <div id="binfodetails" style="display:none; color:#F60">Billing & Shipping Address details updated!!!</div>
      <div class="table-responsive">
            <table class="table table-bordered">
              <tbody>
                <tr>
                  <td>Address Line 1</td>
                  <td><input type="text" name="address1" id="address1" class="form-control" maxlength="50" value="@if($bcounts != 0){{$billing_info->b_address_line1}}@endif" required/></td>
                </tr>
                <tr>
                  <td>Address Line 2(optional)</td>
                  <td><input type="text" name="address2" id="address2" class="form-control" maxlength="50" value="@if($bcounts != 0){{$billing_info->b_address_line2}}@endif"/></td>
                </tr>
                <tr>
                  <td>Country</td>
                  <td><select class="form-control select2" name="country" id="country" required>
                  <option value="">Select one</option>
                  @foreach($allcountries as $country)
                  <option value="{{$country->id}}" @if($bcounts != 0)@if($country->id == $billing_info->b_country_id) selected="selected" @endif @endif>{{$country->name}}</option>
            	  @endforeach	 
                </select> </td>
                </tr>
                <tr>
                  <td>State</td>
                  <td><select class="form-control select2" name="state" id="state" required>
                  @if($bcounts != 0)
                  @foreach($allstates as $state)
                  <option value="{{$state->id}}" @if($state->id == $billing_info->b_state_id) selected="selected" @endif>{{$state->name}}</option>
            	  @endforeach 
                  @endif
                  </select>   </tr>
                <tr>
                  <td>City</td>
                  <td><select class="form-control select2" name="city" id="city" required >
                  @if($bcounts != 0)
                  @foreach($allcities as $city)
                  <option value="{{$city->id}}" @if($city->id == $billing_info->b_city_id) selected="selected" @endif>{{$city->name}}</option>
            	  @endforeach 
                  @endif
                  </select> </td>
                </tr>
                <tr>
                  <td>Zip Code</td>
                  <td><input type="text" name="zipcode" id="zipcode" class="form-control" maxlength="6" required value="@if($bcounts != 0){{$billing_info->b_zipcode}}@endif"/></td>
                </tr>
                 <tr>
                  <td></td>
                  <td><button class="loginbtn btn-primary btn-small" type="submit" name="updatebutton" id="updatebutton">Update</button>&nbsp;<button type="button" class="loginbtn btn-primary btn-small" data-dismiss="modal">BACK</button></td>
                </tr>
              </tbody>
            </table></div>
            </form>
      </div>
      <!--<div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">BACK</button>
      </div>-->
    </div>
  </div>
</div>
@stop