<?php 

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use DB;
use Mail;
use Razorpay\Api\Api;
use Session;
use Carbon\Carbon;
use net\authorize\api\contract\v1 as AnetAPI;
use net\authorize\api\controller as AnetController;



class RegLoginController extends Controller
{
	public function __construct()
	{
		$this->razorKey='rzp_test_IMRsVly6wNM2a6';
		$this->razorSecret='dBdByvbn3RKuvH68AUqPrrIA';
	}
	
	
	public function guestloginarea(Request $request)
	{
		if($request->isMethod("post"))
		{
			/*echo $request->rno;
			echo $request->guestname;
			exit();*/
			
			// insert into guest table
			
			$tdate = date("Y-m-d");
			$pwd = $this->VerificationCode(6);
			$emid = $request->rno."@lcb.com";
			$upwd = $this->encodeID($pwd);
			$td = date("Y-m-d h:i:s");
			$newid = DB::table('siteusers')->insertGetId(['user_emailid' => $emid,'user_ftype' => '0','user_type' => '3','user_name' => $request->guestname,'user_password' => $upwd,'user_status' => '4','user_regdate' => $tdate,'user_online' => '1','user_online_time' => '$td']);
			
			
			
			// insert into guest table
			// to find meeting id discussion/21
			$mid = DB::table('boards')->where('meeting_rand',$request->rno)->first();
			$meeting_id = $mid->meeting_id;
			
			
			// insert into new guest table
			DB::table('guest_request')->insert(['guserid' => $newid,'gmeetingby' => $mid->meeting_by,'gboardid' => $mid->meeting_id,'gemailid' => $emid,'gstatus' => '1','gtoken' => $request->rno,'gonlinestatus' => '1','gremovedstatus' => '0']);
			// insert into new guest table
			
			

			if($mid->meeting_end_status == 1)
			{
				return redirect('/signin')->with("error","Meeting already ended!!!");
			}


			// to find meeting id

			
			// start session
			$guestinfo = DB::table('siteusers')->where('user_emailid',$emid)->where('user_name',$request->guestname)->where('user_id',$newid)->first();
			session()->put('lcbuser_id',$guestinfo->user_id);			
			session()->put('lcbuser_name',$guestinfo->user_name);
			session()->put('lcbuser_ftype',$guestinfo->user_ftype);			
			session()->put('lcbuser_meetingid',$meeting_id);
				
			// start session
			
			if($mid->meeting_type == '1')
			{
				return redirect('discussion/'.$meeting_id);	
			}
			else if($mid->meeting_type == '3')
			{
				return redirect('swotdiscussion/'.$meeting_id);	
			}	
			else if($mid->meeting_type == '4')
			{
				return redirect('empathymap/'.$meeting_id);	
			}	
			else if($mid->meeting_type == '5')
			{
				return redirect('productvision/'.$meeting_id);	
			}	
			else if($mid->meeting_type == '6')
			{
				return redirect('sailboat/'.$meeting_id);	
			}	
			else if($mid->meeting_type == '7')
			{
				return redirect('leancanvas/'.$meeting_id);	
			}	
			else if($mid->meeting_type == '8')
			{
				return redirect('portfoliocanvas/'.$meeting_id);	
			}	
			else if($mid->meeting_type == '9')
			{
				return redirect('leanplanning/'.$meeting_id);	
			}
			else if($mid->meeting_type == '10')
			{
				return redirect('storymapping/'.$meeting_id);	
			}	
			else if($mid->meeting_type == '11')
			{
				return redirect('openspace/'.$meeting_id);	
			}	
			else if($mid->meeting_type == '12')
			{
				return redirect('fishbone/'.$meeting_id);	
			}
			else if($mid->meeting_type == '14')
			{
				return redirect('communityofpractice/'.$meeting_id);	
			}		
			else if($mid->meeting_type == '15')
			{
				return redirect('mindmap/'.$meeting_id);	
			}
			else if($mid->meeting_type == '16')
			{
				return redirect('valuestream/'.$meeting_id);	
			}																										
			else
			{
				return redirect('agendameeting/'.$meeting_id);	
			}
			
		}
	}
	
	// signin process
	public function signin(Request $request)
	{
		if(session('lcbuser_id') != '')
		{
			$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
			
			if($userinfo->user_type == 1)
			{
				if($userinfo->user_ftype == 0)
				{
					return redirect('/home');
				}
				else
				{
					return redirect('/customerhome');
				}
			}
			else
			{
				return redirect('/attendeehome');
			}
							
		}
		
		if($request->isMethod("post"))
		{
			$userinfo = DB::select('CALL checklogin(?)',array($request->emailid));
		
			if(count($userinfo) == 0)
			{
				return redirect('/signin')->with("error","Username doesnot exist!!!");
			}
			else
			{
				$upwd = $this->decodeID($userinfo[0]->user_password);
				if($upwd != $request->password)
				{
					return redirect('/signin')->with("error","Invalid Password!!!");
				}
				else
				{
					if($userinfo[0]->user_online == 0)
					{
						session()->put('lcbuser_id',$userinfo[0]->user_id);			
						session()->put('lcbuser_name',$userinfo[0]->user_name);
						session()->put('lcbuser_ftype',$userinfo[0]->user_ftype);
	
						if($userinfo[0]->user_status == 0)
						{
							return redirect('/choice');
						}
						else if($userinfo[0]->user_status == 2)
						{
							return redirect('/beforeyoustart');
						}
						else if($userinfo[0]->user_status == 3)
						{
							return redirect('/subscription');
						}										
						else if($userinfo[0]->user_status == 1)
						{
							return redirect('/verification');
						}
						else
						{
							if($userinfo[0]->user_type == 1)
							{
								if($userinfo[0]->user_ftype == 0)
								{
									return redirect('/home');
								}
								else
								{
									return redirect('/customerhome');
								}
							}
							else
							{
								return redirect('/attendeehome');
							}
						}				
					}
					else
					{
						return redirect('/signin')->with("error","user already logged in!!!");
					}
				}

			}	
					
		}
		return view('user/signin');
	
	}
	// signin process
	
    public function signin_normal(Request $request)
	{	
		if(session('lcbuser_id') != '')
		{
			$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
			if($userinfo->user_type == 1)
			{
				if($userinfo->user_ftype == 0)
				{
					return redirect('/home');
				}
				else
				{
					return redirect('/customerhome');
				}
			}
			else
			{
				return redirect('/attendeehome');
			}			
		}
		
		if($request->isMethod("post"))
		{
			$UsernameExist = DB::table('siteusers')->where([["user_emailid","=",$request->emailid]])->count();
			
			if($UsernameExist == 0)
			{
				return redirect('/signin')->with("error","Username doesnot exist!!!");
			}	
			else
			{
				// already login
				$al_login = DB::table('siteusers')->where("user_emailid","=",$request->emailid)->where("user_online","=","0")->count();
				if($al_login == 1)
				{
				
				$userinfo = DB::table('siteusers')->where([["user_emailid","=",$request->emailid]])->first();
				
				$upwd = $this->decodeID($userinfo->user_password);
				
				if($upwd != $request->password)
				{
					
					return redirect('/signin')->with("error","Invalid Password!!!");
				}
				else
				{
				
					
				
					session()->put('lcbuser_id',$userinfo->user_id);			
				 	session()->put('lcbuser_name',$userinfo->user_name);
					session()->put('lcbuser_ftype',$userinfo->user_ftype);

					if($userinfo->user_status == 0)
					{
						return redirect('/choice');
					}
					else if($userinfo->user_status == 2)
					{
						return redirect('/beforeyoustart');
					}
					else if($userinfo->user_status == 3)
					{
						return redirect('/subscription');
					}										
					else if($userinfo->user_status == 1)
					{
						return redirect('/verification');
					}
					else
					{
						if($userinfo->user_type == 1)
						{
							if($userinfo->user_ftype == 0)
							{
								return redirect('/home');
							}
							else
							{
								return redirect('/customerhome');
							}
						}
						else
						{
							return redirect('/attendeehome');
						}
					}
				}
				
				}
				else
				{
					return redirect('/signin')->with("error","user already logged in!!!");
				}
			}		
		}
		return view('user/signin');
	}
	
    public function register(Request $request)
	{
		if(session('lcbuser_id') != '')
		{
			$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
			if($userinfo->user_type == 1)
			{
				if($userinfo->user_ftype == 0)
				{
					return redirect('/home');
				}
				else
				{
					return redirect('/customerhome');
				}
			}
			else
			{
				return redirect('/attendeehome');
			}			
		}
			
		if($request->isMethod("post"))
		{
			// to check any request
			$req_count = DB::table('facilitators_request')->where([["remailid","=",$request->emailid]])->count();	
			// to check any request
			if($req_count == 0)
			{
				$tdate = date("Y-m-d");
				$upwd = $this->encodeID($request->password);
				$tdtime = date("Y-m-d h:i:s");
				
				DB::insert('CALL  newRegister(?,?,?,?,?,?,?,?,?,?)',array($request->emailid,0,$request->fname,$upwd,0,$tdate,1,$tdtime,0,0));
				
				//DB::table('siteusers')->insert(['user_emailid' => $request->emailid,'user_ftype' => '0','user_name' => $request->fname,'user_password' => $upwd,'user_status' => '0','user_regdate' => $tdate,'user_online' => '1','user_online_time' => '$td']);
				
				//$userinfo = DB::table('siteusers')->where([["user_emailid","=",$request->emailid]])->first();	
				
				$userinfo1 = DB::select('CALL checklogin(?)',array($request->emailid));
				$userinfo = $userinfo1[0];
								
				session()->put('lcbuser_id',$userinfo->user_id);			
				session()->put('lcbuser_name',$userinfo->user_name);
				session()->put('lcbuser_ftype',$userinfo->user_ftype);								
				return redirect('choice');	
			}
			else
			{
				$req_userinfo = DB::table('facilitators_request')->where([["remailid","=",$request->emailid]])->first();	
				$vcode = $this->VerificationCode(5);
				$tdate = date("Y-m-d");
				$upwd = $this->encodeID($request->password);
				$tdtime = date("Y-m-d h:i:s");
				
				//DB::table('siteusers')->insert(['user_emailid' => $request->emailid,'user_ftype' => $req_userinfo->ruserid,'user_type' => '1','user_token' => $vcode,'user_name' => $request->fname,'user_password' => $upwd,'user_status' => '1','user_regdate' => $tdate,'user_online' => '1','user_online_time' => '$td']);
				
				DB::insert('CALL  newRegister(?,?,?,?,?,?,?,?,?,?)',array($request->emailid,$req_userinfo->ruserid,$request->fname,$upwd,1,$tdate,1,$tdtime,1,$vcode));
								
				//$userinfo = DB::table('siteusers')->where([["user_emailid","=",$request->emailid]])->first();	
				$userinfo1 = DB::select('CALL checklogin(?)',array($request->emailid));
				$userinfo = $userinfo1[0];
				
				
				session()->put('lcbuser_id',$userinfo->user_id);			
				session()->put('lcbuser_name',$userinfo->user_name);
				session()->put('lcbuser_ftype',$userinfo->user_ftype);	
				// send mail
				$sdata2['m_name'] = $userinfo->user_name;
				$sdata2['m_emailid'] = $userinfo->user_emailid;
				$sdata2['m_code'] = $vcode;
				
				Mail::send('mail.mail_register', $sdata2, function($message) use ($sdata2) {
				$subject = "Use ".$sdata2['m_code']." to validate your Lean Coffee Brew email address";
				$message->to($sdata2['m_emailid'],$sdata2['m_name'])->subject($subject);
				});					
				// send mail
			
												
				return redirect('verification');				
			}	
		}
		$data['terms'] = DB::table('cms')->where('cid','1')->first();
		return view('user/register',$data);
	}	
	
	public function advanceauthorizednetpayment()
	{
		$data['subscription_info'] = $this->subscriptiondetails();	
		$data['ord_no'] = $this->VerificationCode(10);
		$values = array('orderno' => $data['ord_no']);
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);		
		DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '','pay_type' => 'Credit Card']);	
		$data['curmonth'] = date('m');	
		$data['userinfo'] = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
		
							
		return view('user/advanceauthorizednetpayment',$data);		
	}
	
	public function advance_authorizednet_payment(Request $request)
	{

		$data['subscription_info'] = $this->subscriptiondetails();	
		// authorise.net payment starts here
        $input = $request->input();
        
        /* Create a merchantAuthenticationType object with authentication details
          retrieved from the constants file */
        $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
        $merchantAuthentication->setName('6uy6eQ2UVa2');
        $merchantAuthentication->setTransactionKey('525de4649MKjzFA5');

        // Set the transaction's refId
        $refId = $request->advance_ord_no;
		session()->put('advance_authord_no',$refId);	
        $cardNumber = $input['cardNumber'];
		$final_price = $data['subscription_info']->stotalprice;
        // Create the payment data for a credit card
        $creditCard = new AnetAPI\CreditCardType();
        $creditCard->setCardNumber($cardNumber);
        $creditCard->setExpirationDate($input['expiration-year'] . "-" .$input['expiration-month']);
        $creditCard->setCardCode($input['cvv']);

        // Add the payment data to a paymentType object
        $paymentOne = new AnetAPI\PaymentType();
        $paymentOne->setCreditCard($creditCard);

        // Create a TransactionRequestType object and add the previous objects to it
        $transactionRequestType = new AnetAPI\TransactionRequestType();
        $transactionRequestType->setTransactionType("authCaptureTransaction");
        $transactionRequestType->setAmount($final_price);
        $transactionRequestType->setPayment($paymentOne);
		
        // Assemble the complete transaction request
        $requests = new AnetAPI\CreateTransactionRequest();
        $requests->setMerchantAuthentication($merchantAuthentication);
        $requests->setRefId($refId);
        $requests->setTransactionRequest($transactionRequestType);

        // Create the controller and get the response
        $controller = new AnetController\CreateTransactionController($requests);
        $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);

		if ($response != null) {
		
			
		
            // Check to see if the API request was successfully received and acted upon
            if ($response->getMessages()->getResultCode() == "Ok") {
                // Since the API request was successful, look for a transaction response
                // and parse it to display the results of authorizing the card
                $tresponse = $response->getTransactionResponse();

                if ($tresponse != null && $tresponse->getMessages() != null) {
                    
                    $msg_type = "success_msg";
					    
                    // when successful payment
					$ptime = time();
					$payment_date = date("Y-m-d");
		$values = array('pay_trans_id' => $tresponse->getTransId(),'pay_payment_date' => $payment_date,'pay_status' => '1','pay_amount' => $final_price,'pay_description' => 'Advance subscription','pay_time' => $ptime);
		DB::table('paymenthistory')->where([["pay_order_number","=",session('advance_authord_no')]])->update($values);	
		
		$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();					
						
		if($last_enddate->sbilling == 1)
		{
			$startdate = date("Y-m-d");
			$enddate = date('Y-m-d',strtotime('+365 days',strtotime($last_enddate->send_date)));
		}
		else
		{	
			if($last_enddate->sbilling == 0)
			{		
				$noofdays = 30;
			}
			if($last_enddate->sbilling == 3)
			{		
				$noofdays = 90;
			}
			if($last_enddate->sbilling == 6)
			{		
				$noofdays = 180;
			}
			if($last_enddate->sbilling == 9)
			{		
				$noofdays = 270;
			}									
			$startdate = date("Y-m-d");
			$hdays = '+'.$noofdays.' days';
			$enddate = date('Y-m-d',strtotime($hdays,strtotime($last_enddate->send_date)));			
		}		
		

		$values = array('sstart_date' => $startdate,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0','advance_done' => '1');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
		
		$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
		
		 					$dateDiff = $this->dateDifference($startdate, $enddate);
					
		$values = array('rstatus' => '1');
		DB::table('attendees_request')->where([["ruserid","=",session('lcbuser_id')]])->update($values);	
		
		// sending email notification regarding payment
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;	
				$details['m_message'] = "Your subscription payment for LeanCoffeeBrew Subscription was successful.";	
				$details['m_content'] = "You now have ".$s_details->snofacilitators." Barista pack for ".$dateDiff." days.";							
				Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
				$subject = 'Thanks for your advance subscription - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});					
		// sending email notification regarding payment					
			session()->put('advance_authord_no','');					
		return redirect('/home')->with("success","Payment success");
		
						
		}
										
					// when successful payment
                  
                 else {
                    $message_text = 'There were some issue with the payment. Please try again later.';
                    $msg_type = "error_msg";                                    

                    if ($tresponse->getErrors() != null) {
                        $message_text = $tresponse->getErrors()[0]->getErrorText();
                        $msg_type = "error_msg";                                    
                    }
                }
                // Or, print errors if the API request wasn't successful
            } else {
                $message_text = 'There were some issue with the payment. Please try again later.';
                $msg_type = "error_msg";                                    

                $tresponse = $response->getTransactionResponse();

                if ($tresponse != null && $tresponse->getErrors() != null) {
                    $message_text = $tresponse->getErrors()[0]->getErrorText();
                    $msg_type = "error_msg";                    
                } else {
                    $message_text = $response->getMessages()->getMessage()[0]->getText();
                    $msg_type = "error_msg";
                }                
            }
        
		
		} else {
            $message_text = "No response returned";
            $msg_type = "error_msg";
        }
        return back()->with($msg_type, $message_text);
	
				
		// authorise.net payment ends here
	}
	
	public function advancepaypalpayment()
	{
		/*$checkpaidornot = DB::table('subscription')->where("suserid","=",session('lcbuser_id'))->where("sstatus","=",'0')->count();		
		if($checkpaidornot == 0)
		{
			return redirect('/home');
		}*/
		$data['subscription_info'] = $this->subscriptiondetails();	
		$data['ord_no'] = $this->VerificationCode(10);
		$values = array('orderno' => $data['ord_no']);
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);		
		DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '']);			
		return view('user/advancepaypalpayment',$data);
	}	
	
	public function paypalpayment()
	{
		$checkpaidornot = DB::table('subscription')->where("suserid","=",session('lcbuser_id'))->where("sstatus","=",'0')->count();		
		if($checkpaidornot == 0)
		{
			return redirect('/home');
		}
		$data['subscription_info'] = $this->subscriptiondetails();	
		$data['ord_no'] = $this->VerificationCode(10);
		$values = array('orderno' => $data['ord_no']);
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);		
		DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '']);			
		return view('user/paypalpayment',$data);
	}
	
	public function authorizednetpayment()
	{
		$checkpaidornot = DB::table('subscription')->where("suserid","=",session('lcbuser_id'))->where("sstatus","=",'0')->count();		
		if($checkpaidornot == 0)
		{
			return redirect('/home');
		}
		$data['subscription_info'] = $this->subscriptiondetails();	
		$data['ord_no'] = $this->VerificationCode(10);
		$values = array('orderno' => $data['ord_no']);
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);		
		DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $data['ord_no'],'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '','pay_type' => 'Credit Card']);		
		$data['curmonth'] = date('m');	
		$data['userinfo'] = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();	
		return view('user/authorizednetpayment',$data);
	}
	
		
public function authorizednet_payment(Request $request)
	{

		$data['subscription_info'] = $this->subscriptiondetails();	
		// authorise.net payment starts here
        $input = $request->input();
        
        /* Create a merchantAuthenticationType object with authentication details
          retrieved from the constants file */
        $merchantAuthentication = new AnetAPI\MerchantAuthenticationType();
        $merchantAuthentication->setName('6uy6eQ2UVa2');
        $merchantAuthentication->setTransactionKey('525de4649MKjzFA5');

        // Set the transaction's refId
        $refId = $request->reactivate_ord_no;
		session()->put('reactivate_authord_no',$refId);		
        $cardNumber = $input['cardNumber'];
		$final_price = $data['subscription_info']->stotalprice;
        // Create the payment data for a credit card
        $creditCard = new AnetAPI\CreditCardType();
        $creditCard->setCardNumber($cardNumber);
        $creditCard->setExpirationDate($input['expiration-year'] . "-" .$input['expiration-month']);
        $creditCard->setCardCode($input['cvv']);

        // Add the payment data to a paymentType object
        $paymentOne = new AnetAPI\PaymentType();
        $paymentOne->setCreditCard($creditCard);

        // Create a TransactionRequestType object and add the previous objects to it
        $transactionRequestType = new AnetAPI\TransactionRequestType();
        $transactionRequestType->setTransactionType("authCaptureTransaction");
        $transactionRequestType->setAmount($final_price);
        $transactionRequestType->setPayment($paymentOne);
		
        // Assemble the complete transaction request
        $requests = new AnetAPI\CreateTransactionRequest();
        $requests->setMerchantAuthentication($merchantAuthentication);
        $requests->setRefId($refId);
        $requests->setTransactionRequest($transactionRequestType);

        // Create the controller and get the response
        $controller = new AnetController\CreateTransactionController($requests);
        $response = $controller->executeWithApiResponse(\net\authorize\api\constants\ANetEnvironment::SANDBOX);

		if ($response != null) {
		
			
		
            // Check to see if the API request was successfully received and acted upon
            if ($response->getMessages()->getResultCode() == "Ok") {
                // Since the API request was successful, look for a transaction response
                // and parse it to display the results of authorizing the card
                $tresponse = $response->getTransactionResponse();

                if ($tresponse != null && $tresponse->getMessages() != null) {
                    
                    $msg_type = "success_msg";
					    
                    // when successful payment
					$ptime = time();
					$payment_date = date("Y-m-d");
		$values = array('pay_trans_id' => $tresponse->getTransId(),'pay_payment_date' => $payment_date,'pay_status' => '1','pay_amount' => $final_price,'pay_description' => 'Subscription Activated','pay_time' => $ptime);
		DB::table('paymenthistory')->where([["pay_order_number","=",session('reactivate_authord_no')]])->update($values);	
		
		$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();					
						
		if($last_enddate->sbilling == 1)
		{
			$startdate = date("Y-m-d");
			$enddate = date('Y-m-d',strtotime('+365 days',strtotime($startdate)));
		}
		else
		{	
			if($last_enddate->sbilling == 0)
			{		
				$noofdays = 30;
			}
			if($last_enddate->sbilling == 3)
			{		
				$noofdays = 90;
			}
			if($last_enddate->sbilling == 6)
			{		
				$noofdays = 180;
			}
			if($last_enddate->sbilling == 9)
			{		
				$noofdays = 270;
			}									
			$startdate = date("Y-m-d");
			$hdays = '+'.$noofdays.' days';
			$enddate = date('Y-m-d',strtotime($hdays,strtotime($startdate)));			
		}		
		

		$values = array('sstart_date' => $startdate,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
		
					
		$values = array('rstatus' => '1');
		DB::table('attendees_request')->where([["ruserid","=",session('lcbuser_id')]])->update($values);	
							
			$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();				
		// sending email notification regarding payment
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;
				$details['m_message'] = "Your Payment for Lean Coffee Subscription is successful.";	
				$details['m_content'] = "Now you own the ".$s_details->snofacilitators." Barista pack for 30 days.";				
				Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
				$subject = 'Thanks for your subscription - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});					
		// sending email notification regarding payment	
										
		return redirect('/home')->with("success","Payment success");	
				
		session()->put('reactivate_authord_no','');	
						
		}
										
					// when successful payment
                  
                 else {
                    $message_text = 'There were some issue with the payment. Please try again later.';
                    $msg_type = "error_msg";                                    

                    if ($tresponse->getErrors() != null) {
                        $message_text = $tresponse->getErrors()[0]->getErrorText();
                        $msg_type = "error_msg";                                    
                    }
                }
                // Or, print errors if the API request wasn't successful
            } else {
                $message_text = 'There were some issue with the payment. Please try again later.';
                $msg_type = "error_msg";                                    

                $tresponse = $response->getTransactionResponse();

                if ($tresponse != null && $tresponse->getErrors() != null) {
                    $message_text = $tresponse->getErrors()[0]->getErrorText();
                    $msg_type = "error_msg";                    
                } else {
                    $message_text = $response->getMessages()->getMessage()[0]->getText();
                    $msg_type = "error_msg";
                }                
            }
        
		
		} else {
            $message_text = "No response returned";
            $msg_type = "error_msg";
        }
        return back()->with($msg_type, $message_text);
	
				
		// authorise.net payment ends here
	}
			
	
	
public function advancepaypalsuccess(Request $request)
	{
	
		$ptime = time();
	
		if($request->payment_status == "Completed")
		{
		//`trans_id`='$_REQUEST[txn_id]',`status`='1',`payment_date`='$_REQUEST[payment_date]' where `order_number`='$_REQUEST[custom]'"
		$values = array('pay_trans_id' => $request->txn_id,'pay_payment_date' => $request->payment_date,'pay_status' => '1','pay_amount' => $request->mc_gross,'pay_description' => 'Advance subscription','pay_time' => $ptime);
		DB::table('paymenthistory')->where([["pay_order_number","=",$request->custom]])->update($values);	
		
		$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
		

		
		
		if($last_enddate->sbilling == 1)
		{
			$startdate = date("Y-m-d");
			$enddate = date('Y-m-d',strtotime('+365 days',strtotime($last_enddate->send_date)));
		}
		else
		{	
			if($last_enddate->sbilling == 0)
			{		
				$noofdays = 30;
			}
			if($last_enddate->sbilling == 3)
			{		
				$noofdays = 90;
			}
			if($last_enddate->sbilling == 6)
			{		
				$noofdays = 180;
			}
			if($last_enddate->sbilling == 9)
			{		
				$noofdays = 270;
			}									
			$startdate = date("Y-m-d");
			$hdays = '+'.$noofdays.' days';
			$enddate = date('Y-m-d',strtotime($hdays,strtotime($last_enddate->send_date)));			
		}
		
		
			
		$values = array('sstart_date' => $startdate,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0','advance_done' => '1');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
		
		$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
		
		 					$dateDiff = $this->dateDifference($startdate, $enddate);
					
		$values = array('rstatus' => '1');
		DB::table('attendees_request')->where([["ruserid","=",session('lcbuser_id')]])->update($values);	
		
		// sending email notification regarding payment
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;	
				$details['m_message'] = "Your subscription payment for LeanCoffeeBrew Subscription was successful.";	
				$details['m_content'] = "You now have ".$s_details->snofacilitators." Barista pack for ".$dateDiff." days.";							
				Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
				$subject = 'Thanks for your advance subscription - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});					
		// sending email notification regarding payment					
							
		return redirect('/home')->with("success","Payment success");			
		}
		else
		{
			return redirect('/home')->with("error","Sorry payment not success");
		}
		
	}	
	
	public function paypalsuccess(Request $request)
	{
	
		/*echo "<pre>";
		print_r($request);
		exit();*/
		if($request->payment_status == "Completed")
		{
		$ptime = time();
		//`trans_id`='$_REQUEST[txn_id]',`status`='1',`payment_date`='$_REQUEST[payment_date]' where `order_number`='$_REQUEST[custom]'"
		$values = array('pay_trans_id' => $request->txn_id,'pay_payment_date' => $request->payment_date,'pay_status' => '1','pay_amount' => $request->mc_gross,'pay_description' => 'Subscription Activated','pay_time' => $ptime);
		DB::table('paymenthistory')->where([["pay_order_number","=",$request->custom]])->update($values);	
		
		
			//$startdate = date("Y-m-d");
			//$enddate = date('Y-m-d', strtotime('+30 days'));
			
$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
		

		
		
		if($last_enddate->sbilling == 1)
		{
			$startdate = date("Y-m-d");
			$enddate = date('Y-m-d',strtotime('+365 days',strtotime($startdate)));$hdayinfo = '1 year';
		}
		else
		{	
			if($last_enddate->sbilling == 0)
			{		
				$noofdays = 30;$hdayinfo = '1 month';
			}
			if($last_enddate->sbilling == 3)
			{		
				$noofdays = 90;$hdayinfo = '3 months';
			}
			if($last_enddate->sbilling == 6)
			{		
				$noofdays = 180;$hdayinfo = '6 months';
			}
			if($last_enddate->sbilling == 9)
			{		
				$noofdays = 270;$hdayinfo = '9 months';
			}									
			$startdate = date("Y-m-d");
			$hdays = '+'.$noofdays.' days';
			$enddate = date('Y-m-d',strtotime($hdays,strtotime($startdate)));			
		}
		
					
			
		$values = array('sstart_date' => $startdate,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
		
					
		$values = array('rstatus' => '1');
		DB::table('attendees_request')->where([["ruserid","=",session('lcbuser_id')]])->update($values);	
							
			$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();				
		// sending email notification regarding payment
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;
				$details['m_message'] = "Your Payment for Lean Coffee Subscription is successful.";	
				$details['m_content'] = "Now you own the ".$s_details->snofacilitators." Barista pack for ".$hdayinfo;				
				Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
				$subject = 'Thanks for your subscription - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});					
		// sending email notification regarding payment	
										
		return redirect('/home')->with("success","Payment success");			
		}
		else
		{
			return redirect('/home')->with("error","Sorry payment not success");
		}
		
	}
	
	public function paypalfailure(Request $request)
	{
		$values = array('orderno' => '');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);			
		return redirect('/home')->with("error","Sorry payment not success");
	}	
	
	
	public function upgradepaypalfailure(Request $request)
	{
		$values = array('pay_order_number' => '');
		DB::table('upgrade_subscription_payment')->where([["pay_user_id","=",session('lcbuser_id')]])->update($values);			
		return redirect('/home')->with("error","Sorry payment not success");
	}	
	
	public function upgradepaypalsuccess(Request $request)
	{
		
		if($request->payment_status == "Completed")
		{
			$values = array('pay_trans_id' => $request->txn_id,'pay_payment_date' => $request->payment_date,'pay_status' => '1');
			DB::table('upgrade_subscription_payment')->where([["pay_order_number","=",$request->custom]])->update($values);	
			$ptime = time();
			

		
					
			
			// to change upgrade subscription
			$sub_details = DB::table('upgrade_subscription_payment')->where("pay_order_number","=",$request->custom)->first();
			$st_date = date("Y-m-d");
			if($sub_details->pay_billed_choice != 1)
			{
				$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
				
				// find user in trial or not
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $st_date)->count();
				// find user in trial or not
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					if($sub_details->pay_billed_choice == 0)
					{
						$hdays = '+30 days';$hdayinfo = 30;
					}
					if($sub_details->pay_billed_choice == 3)
					{
						$hdays = '+90 days';$hdayinfo = 90;
					}
					if($sub_details->pay_billed_choice == 6)
					{
						$hdays = '+180 days';$hdayinfo = 180;
					}
					if($sub_details->pay_billed_choice == 9)
					{
						$hdays = '+270 days';$hdayinfo = 270;
					}										
					
				}
				else
				{
					$start_date1 = date("Y-m-d");
 					$end_date1 = $last_enddate->trial_end_date;
 					$dateDiff = $this->dateDifference($start_date1, $end_date1);
					
					if($sub_details->pay_billed_choice == 0)
					{
						$finaldate = 30+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 3)
					{
						$finaldate = 90+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 6)
					{
						$finaldate = 180+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 9)
					{
						$finaldate = 270+$dateDiff;
					}															
					
					$hdays = '+'.$finaldate.' days';$hdayinfo = $finaldate;
										
				}
				$enddate = date('Y-m-d',strtotime($hdays,strtotime($start_date1)));			
			}
			else
			{
				$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
				// find user in trial or not
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $st_date)->count();
				// find user in trial or not
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					$hdays = '+365 days';$hdayinfo = 365;
				}
				else
				{
					$start_date1 = date("Y-m-d");
 					$end_date1 = $last_enddate->trial_end_date;
 					$dateDiff = $this->dateDifference($start_date1, $end_date1);
					$finaldate = 365+$dateDiff;
					$hdays = '+'.$finaldate.' days'; $hdayinfo = $finaldate;
										
				}
				$enddate = date('Y-m-d',strtotime($hdays,strtotime($start_date1)));					
			}
			
			// update in payment history table
		/*DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $request->custom,'pay_payment_date' => $request->payment_date,
		'pay_status' => '1','pay_trans_id' => $request->txn_id]);	*/			
			// update in payment history table
			
			
		
		
			
		$values = array('sstart_date' => $start_date1,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0','sbilling' => $sub_details->pay_billed_choice,'snofacilitators' => $sub_details->pay_count,'stotalprice' => $sub_details->pay_amount,'advance_done' => '0');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
		
		
	$sub_details_new = DB::table('upgrade_subscription_payment')->where("pay_order_number","=",$request->custom)->first();	
// insert into paymenthistory table
$st_date = date("Y-m-d")."T";
if($sub_details_new->pay_billed_choice == 1)
{
	$cmonth = "1 year";
}
else
{
	$cmonth = $sub_details_new->pay_billed_choice." months";
}


$subscription_message = $sub_details_new->pay_count.' Barista upgraded for '.$cmonth;
DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $request->custom,'pay_trans_id' => $request->txn_id,
'pay_status' => '1','pay_payment_date' => $request->payment_date,'pay_amount' => $request->mc_gross,'pay_description' => $subscription_message,'pay_time' => $ptime]);	
// insert into paymenthistory table


		
		
					
			// to change upgrade subscription
			
			$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
			
		// sending email notification regarding payment
		
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;
				$details['m_message'] = "Your payment to upgrade your LeanCoffeeBrew Subscription was successful.";	
				$details['m_content'] = "You now have ".$s_details->snofacilitators." Barista pack for ".$hdayinfo." days.";		
				Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
				$subject = 'Thanks for your subscription - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});		
							
		// sending email notification regarding payment	

			
			return redirect('/home')->with("success","Your subscription upgraded successfully");					
		}
		else
		{
			return redirect('/home')->with("error","Sorry payment not success");
		}
	}
		
	public function forgetpassword(Request $request)
	{
		if($request->isMethod("post"))
		{
			$userinfo_count = DB::table('siteusers')->where([["user_emailid","=",$request->emailid]])->count();	
			if($userinfo_count == 0)
			{
				return redirect('/forgetpassword')->with("error","Sorry Email ID does not exist!!!");
			}
			else
			{
				$userinfo = DB::table('siteusers')->where([["user_emailid","=",$request->emailid]])->first();	
				$usrPWD = $this->decodeID($userinfo->user_password);
				
				// send mail
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;
				$details['m_pwd'] = $usrPWD;

				Mail::send('mail.mail_userpassword', $details, function($message) use ($details) {
				$subject = 'Password details - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});					
				// send mail				
				return redirect('/forgetpassword')->with("success","Password details sent to your email id");
			}
		}
		return view('user/forgetpassword');
	}		
	
	public function mailview()
	{
				$userinfo = DB::table('siteusers')->where([["user_emailid","=",'kannanog@gmail.com']])->first();	
				
				
				

				// send mail
				$sdata2['m_name'] = $userinfo->user_name;
				$sdata2['m_emailid'] = $userinfo->user_emailid;
				$sdata2['m_code'] = $userinfo->user_token;
				
				Mail::send('mail.mail_register', $sdata2, function($message) use ($sdata2) {
				$subject = "Use ".$sdata2['m_code']." to validate your Lean Coffee Brew email address";
				$message->to($sdata2['m_emailid'],$sdata2['m_name'])->subject($subject);
				$message->from("support@leancoffeebrew.com","Leancoffeebrew");
				});		
				
				
				
							
				// send mail
		return view('mail/mail_register',$sdata2);
	}
	
	public function signout()
    {
		// check in attendee table
		$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
		$em_id = $userinfo->user_emailid;
		$ifemailexist = DB::table('attendees_request')->where([["remailid",$em_id]])->count();
		if($ifemailexist != 0)
		{
			//$values2 = array('ronlinestatus' => '0');
			//DB::table('attendees_request')->where([["remailid",$em_id]])->update($values2);
		}
		// check in attendee table
		
		// check in guest table
		$guestinfocount = DB::table('guest_request')->where([["guserid",session('lcbuser_id')]])->count();
		if($guestinfocount != 0)
		{
			//$values3 = array('gonlinestatus' => '0');
			//DB::table('guest_request')->where([["guserid",session('lcbuser_id')]])->update($values3);			
		}
		// check in guest table				
				
		$values = array('user_online' => '0');
		DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);		
		session()->put('lcbuser_id','');			
		session()->put('lcbuser_name','');
		session()->put('lcbuser_ftype','');		
		return redirect('/index')->with("success","You are successfully logged out from this website");
		
	}
	
	public function signoutandremoved()
    {
		$values = array('user_online' => '0');
		DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);		
		session()->put('lcbuser_id','');			
		session()->put('lcbuser_name','');
		session()->put('lcbuser_ftype','');		
		return redirect('/index')->with("error","Sorry you are removed from this meeting!!!");
	}	
	


	public function signoutandleave()
	{
		$values = array('user_online' => '0');
		DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);	

		session()->put('lcbuser_id','');			
		session()->put('lcbuser_name','');
		session()->put('lcbuser_ftype','');		
		return redirect('/index')->with("success","You left the meeting!!!");		
	}
	
	public function home()
	{
		$user_info = $this->userdetails();		
		if($user_info->user_status != 4)
		{
			if(session('lcbuser_status') == 1)
			{
				return redirect('/choice');
			}
			else if(session('lcbuser_status') == 2)
			{
				return redirect('/beforeyoustart');
			}										
			else if(session('lcbuser_status') == 3)
			{
				return redirect('/subscription');
			}
			else
			{
				if($user_info->user_type == 1)
				{
					if($user_info->user_ftype == 0)
					{
						return redirect('/home');
					}
					else
					{
						return redirect('/customerhome');
					}
				}
				else
				{
					return redirect('/attendeehome');
				}
			}			
		}
		
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','1')->first();
		$data['subscription_details'] = DB::table('subscription')->where('suserid',session('lcbuser_id'))->orderBy('sid','DESC')->first();

		
		// to find price
		$data['subscription_info'] = $this->subscriptiondetails();
		$currentprice = $data['subscription_info']->stotalprice;
		$cuserinfo = $this->userdetails();
		
		if($data['subscription_info']->advance_done == 1)
		{
		// if any advance payment done
		$ad_pay_done = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->count();
		if($ad_pay_done >= 2)
		{
			// get final amount paid
			$ad_pay_done_info_count = DB::table('paymenthistory')->where('pay_user_id',$cuserinfo->user_id)->where('pay_status','1')->where('pay_description','Advance subscription')->orderBy('pay_order_id','DESC')->count();	
			
			$ad_pay_done_info_val = $ad_pay_done_info_count - 1;
	
			$currentpricefinal = 2 * $currentprice;
			// get final amount paid
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
		}
		else
		{
			$currentpricefinal = $currentprice;
		}
		
		
		
		
			// find 
			$data['pinfoall'] = DB::table('prices')->where('pcount','>=',$data['subscription_info']->snofacilitators)->get();
			
			foreach($data['pinfoall'] as $dpinfo)
			{
				$sel_count = $dpinfo->pcount;				
				$cprice = $dpinfo->pprice;
				$allmonths = DB::table('months')->orderBy("mid","asc")->get();
				$a=array();
				foreach($allmonths as $am)
				{
					if($am->mmain == 1)
					{
						$tot_price2 = $am->mcount * $cprice;
						$perc = ($tot_price2 * 5)/100;
						$tot_price = $tot_price2 - $perc;
					}
					else
					{
						$tot_price = $am->mcount * $cprice;
					}
					if($tot_price > $currentpricefinal)
					{					
						array_push($a,$am->mid);
					}					
				}
				$data['selmonths'] = $a;
				
				
				if(count($data['selmonths']) != 0)
				{
					$data['showorhide'] = 1;
				}
				else
				{
					$data['showorhide'] = 0;
				}
				
				
			}
			
		// to find price			
		
		$data['priceinfo'] = DB::table('prices')->where('pprice','>',$data['subscription_details']->stotalprice)->count();
		
		
		$data['allcountries'] = DB::table('countries')->get();
		
		
		$data['hcounts'] = DB::table('paymenthistory')->where([ ["pay_user_id","=",session('lcbuser_id')] ])->where([ ["pay_status","1"] ])->count();	
		
		
		
		if($data['hcounts'] != 0)
		{
				$data['payment_history_info'] = DB::table('paymenthistory')->where([ ["pay_user_id","=",session('lcbuser_id')] ])->where([ ["pay_status","1"] ])->orderBy('pay_time','DESC')->get();
		}	
		
			
		$data['bcounts'] = DB::table('billing_details')->where([ ["b_user_id","=",session('lcbuser_id')] ])->count();	
		
		if($data['bcounts'] != 0)
		{
		$data['billing_info'] = DB::table('billing_details')->where([ ["b_user_id","=",session('lcbuser_id')] ])->first();		
		$countryname = $data['billing_info']->b_country_id;
		$statename = $data['billing_info']->b_state_id;
		// list of countries
		$data['allcountries'] = DB::table('countries')->get();
		// list of countries		
		// list of states
		$data['allstates'] = DB::table('states')->where("country_id",$countryname)->get();
		// list of states
		// list of cities
		$data['allcities'] = DB::table('cities')->where("state_id",$statename)->get();
		// list of cities
		}

		$tochecktrailornot = DB::table('paymenthistory')->where([ ["pay_user_id","=",session('lcbuser_id')] ])->where([ ["pay_status","1"] ])->count();	
		if($tochecktrailornot == 0)
		{
			$data['tinfo'] = "trial";
		}	
		else
		{
			$data['tinfo'] = "subscription";
		}
							
			
				if($user_info->user_type == 1)
				{
					if($user_info->user_ftype == 0)
					{
						return view('user/home',$data);
					}
					else
					{
						return redirect('/customerhome');
					}
				}
				else
				{
					return redirect('/attendeehome');
				}					
		
	

		
	}
	
	public function customerhome()
	{
		$user_info = $this->userdetails();		
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','1')->first();
		$data['owner_info'] = DB::table('siteusers')->where([ ["user_id","=",session('lcbuser_ftype')] ])->first();				
		$data['req_info_count'] = DB::table('facilitators_request')->where('remailid',$user_info->user_emailid)->count();
		$data['req_info_del_count'] = DB::table('facilitators_deleted_request')->where('remailid',$user_info->user_emailid)->count();

return view('user/customerhome',$data);
				/*if($user_info->user_type == 1)
				{
					if($user_info->user_ftype == 0)
					{
						return redirect('/home');
					}
					else
					{
						return view('user/customerhome',$data);
					}
				}
				else
				{
					return redirect('/attendeehome');
				}*/
						
						
		
	}
	
	public function attendeehome()
	{
		$user_info = $this->userdetails();		
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','1')->first();	
		
				if($user_info->user_type == 1)
				{
					if($user_info->user_ftype == 0)
					{
						return redirect('/home');
					}
					else
					{
						return redirect('/customerhome');
					}
				}
				else
				{
					return view('user/attendeehome',$data);
				}					
		
	}	
	
	
	
	public function editprofile(Request $request)
	{

		if($request->isMethod("post"))
		{
			if($request->cur_pwd == '')
			{
			$values = array('user_name' => $request->user_name);
			DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);				
			
			session()->put('lcbuser_name',$request->user_name);
			return redirect('/editprofile')->with("success","Your profile updated!!!");
			}
			else
			{
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();	
				$usrPWD = $this->decodeID($userinfo->user_password);
				
				if($usrPWD == $request->cur_pwd)
				{
					$upwd = $this->encodeID($request->new_pwd);
					$values = array('user_password' => $upwd);
					DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);					
					return redirect('/editprofile')->with("success","Your profile password updated!!!");
				}
				else
				{
					
					return redirect('/editprofile')->with("error","Sorry your current password is wrong!!!");
				}
								
				
			}
			
		}
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','1')->first();
		$data['profile_info'] = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
		return view('user/editprofile',$data);
	}
	
	public function find_session_name()
    {
		return view('user/sessionname');
	}
	
	public function updateaccountdetails(Request $request)
	{

		$values = array('user_name' => $request->newname);
		DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->update($values);						
		session()->put('lcbuser_name',$request->user_name);
		return 1;
	
	}
	
	public function updatebillingdetails(Request $request)
	{
		$binfo = DB::table('billing_details')->where([["b_user_id","=",session('lcbuser_id')]])->count();
		if($binfo == 0)
		{
		DB::table('billing_details')->insert(['b_user_id' => session('lcbuser_id'),'b_country_id' => $request->country,'b_state_id' => $request->state,'b_city_id' => $request->city,'b_address_line1' => $request->address1,'b_address_line2' => $request->address2,'b_zipcode' => $request->zipcode]);
		}
		else
		{
		$values = array('b_zipcode' => $request->zipcode,'b_country_id' => $request->country,'b_state_id' => $request->state,'b_city_id' => $request->city,'b_address_line1' => $request->address1,'b_address_line2' => $request->address2);
		DB::table('billing_details')->where([ ["b_user_id","=",session('lcbuser_id')] ])->update($values);	
		}
		return 1;
	}
	

	public function checkemail(Request $request)
	{
		$st_count = DB::table('siteusers')->where([["user_emailid","=",$request->emailid]])->count();
		if($st_count != 0)
		{
			return "false";
		}
		else
		{
			return "true";
		}
		
	}	
	// for razor payment
	

	public function prepareData($amount,$razorpayOrderId,$payerdata)
	  {
		$data = array(
		  "key" => $this->razorKey,
		  "amount" => $amount,
		  "name" => "LCB",
		  "description" => $payerdata->merch_desc,
		  "image" => "https://www.leancoffeebrew.com/user/images/logo.png",
		  "prefill" => array(
			"name"  => $payerdata->name,
			"email"  => $payerdata->email,
			"contact" => $payerdata->contact,
		  ),
		  "notes"  => array(
			"merchant_order_id" => $payerdata->merch_order_id,
		  ),
		  "theme"  => array(
			"color"  => "#ff6600"
		  ),
		  "order_id" => $razorpayOrderId,
		);
		return $data;
	}
		
	public function advancerazorpayment(Request $request)
	{
		
	
		if ($request->isMethod('get')) {
			return redirect('/home');
		}
		
		if ($request->isMethod('post')) {
				$randtoken = ($request->_token !="") ? $request->_token : $this->VerificationCode(20);
   				$request->session()->put('pay_token', $randtoken);
		}elseif(!$request->session()->has('pay_token') || $request->session()->get('pay_token')=="")
		{
			 return redirect('/home');
		}
	
	
		$subscription_info = $this->subscriptiondetails();	
		$cus_ord_no = $this->VerificationCode(10).time();
		$values = array('orderno' => $cus_ord_no);
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);		
		DB::table('paymenthistory')->insert(['pay_type'=>'razorpay', 'pay_user_id' => session('lcbuser_id'),'pay_order_number' => $cus_ord_no,'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '']);			
		
		$api = new Api($this->razorKey, $this->razorSecret);

       /* $_SESSION['payable_amount'] = 10;*/

		$razorpayOrder = $api->order->create(array(
		  'receipt'         => $cus_ord_no,
		  'amount'          => $subscription_info->stotalprice * 100, // 2000 rupees in paise
		  'currency'        => 'USD',
		  'payment_capture' => 1 // auto capture
		));
		$amount = $razorpayOrder['amount'];
		$razorpayOrderId = $razorpayOrder['id'];
		$request->session()->put('razorpay_order_id', $razorpayOrderId);
		/*$_SESSION['razorpay_order_id'] = $razorpayOrderId;*/
		$user_info = $this->userdetails();
		
		$payerdata = (object)array('merch_order_id'=>$cus_ord_no,'merch_desc'=>'Advance Subscription Payment',"name"=>$user_info->user_name, "email"=>$user_info->user_emailid, "contact"=>'', "cus_ord_no"=>$cus_ord_no);
		$data['payprocessdata'] = $this->prepareData($amount,$razorpayOrderId,$payerdata);
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','1')->first();	


		$data['tourl']=url('advancerazorpayresponse');
	
		return view('user/razorpay', $data);
		
		
	}
	
	public function advancerazorpayresponse(Request $request)
	{

	
	if($request->session()->has('razorpay_order_id') && $request->session()->get('razorpay_order_id')!="") 
		{
			$success = true;
			
			$error = "Payment Failed";
			
			if (empty($request->razorpay_payment_id) === false)
			{
				$api = new Api($this->razorKey, $this->razorSecret);
				
				try
				{
					// Please note that the razorpay order ID must
					// come from a trusted source (session here, but
					// could be database or something else)
					$attributes = array(
					'razorpay_order_id' => $request->session()->get('razorpay_order_id', ''),
					'razorpay_payment_id' => $request->razorpay_payment_id,
					'razorpay_signature' => $request->razorpay_signature
					);
					
					$api->utility->verifyPaymentSignature($attributes);
				}
				catch(SignatureVerificationError $e)
				{
					$success = false;
					$error = 'Razorpay Error : ' . $e->getMessage();
				}
			}
			
			$request->session()->forget('razorpay_order_id');
			$request->session()->forget('pay_token');
			
			if ($success === true)
			{
					$payment = $api->payment->fetch($request->razorpay_payment_id);
					
					$ptime = time();
					
					if($payment->status == "captured" || $payment->status == "authorized")
					{
						$ref_order_id = $payment->notes->merchant_order_id;
						
						$pay_amount = ($payment->amount > 0)? $payment->amount/100 : 0;
						//$payment_date = date('Y-m-d',strtotime($payment->created_at))."T";
						
						$payment_date = gmdate("Y-m-d\TH:i:s\Z", $payment->created_at);
						
						
						//`trans_id`='$_REQUEST[txn_id]',`status`='1',`payment_date`='$_REQUEST[payment_date]' where `order_number`='$_REQUEST[custom]'"
						$values = array('pay_trans_id' => $payment->id,'pay_payment_date' => $payment_date,'pay_status' => '1','pay_amount' => $pay_amount,'pay_currency' => $payment->currency,'pay_description' => 'Advance subscription','pay_time' => $payment->created_at);
						
						DB::table('paymenthistory')->where([["pay_order_number","=",$ref_order_id]])->update($values);	
						
						$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
						
						if($last_enddate->sbilling == 1)
						{
							$startdate = date("Y-m-d");
							$enddate = date('Y-m-d',strtotime('+365 days',strtotime($last_enddate->send_date)));
						}
						else
						{	
							if($last_enddate->sbilling == 0)
							{		
								$noofdays = 30;
							}
							if($last_enddate->sbilling == 3)
							{		
								$noofdays = 90;
							}
							if($last_enddate->sbilling == 6)
							{		
								$noofdays = 180;
							}
							if($last_enddate->sbilling == 9)
							{		
								$noofdays = 270;
							}									
							$startdate = date("Y-m-d");
							$hdays = '+'.$noofdays.' days';
							$enddate = date('Y-m-d',strtotime($hdays,strtotime($last_enddate->send_date)));			
						}
						
						$values = array('sstart_date' => $startdate,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0','advance_done' => '1');
						DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
						
						$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
						
						$dateDiff = $this->dateDifference($startdate, $enddate);
						
						$values = array('rstatus' => '1');
						DB::table('attendees_request')->where([["ruserid","=",session('lcbuser_id')]])->update($values);	
						
						// sending email notification regarding payment
						$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
						$details['m_name'] = $userinfo->user_name;
						$details['m_emailid'] = $userinfo->user_emailid;	
						$details['m_message'] = "Your subscription payment for LeanCoffeeBrew Subscription was successful.";	
						$details['m_content'] = "You now have ".$s_details->snofacilitators." Barista pack for ".$dateDiff." days.";							
						Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
						$subject = 'Thanks for your advance subscription - Lean Coffee Brew';
						$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
						});					
						// sending email notification regarding payment					
						
						return redirect('/home')->with("success","Payment success");			
				}
				else
				{
					return redirect('/home')->with("error","Sorry payment not success");
				}
			
			}
			else
			{
				return redirect('/home')->with("error","Sorry payment not success");
			}
			
			
			/*$payment->capture(array('amount' => 5000, 'currency' => 'INR'));*/
			
		}
		else
		{
		return redirect('/home')->with("error","an error occurred, please try again later.");
		}
		
	}
	
	public function razorpayment(Request $request)
	{
	
	
		$checkpaidornot = DB::table('subscription')->where("suserid","=",session('lcbuser_id'))->where("sstatus","=",'0')->count();		
		if($checkpaidornot == 0)
		{
			return redirect('/home');
		}
		
		if ($request->isMethod('get')) {
			return redirect('/home');
		}
		
		if ($request->isMethod('post')) {
				$randtoken = ($request->_token !="") ? $request->_token : $this->VerificationCode(20);
   				$request->session()->put('pay_token', $randtoken);
		}elseif(!$request->session()->has('pay_token') || $request->session()->get('pay_token')=="")
		{
			 return redirect('/home');
		}
	
	
		$subscription_info = $this->subscriptiondetails();	
		$cus_ord_no = $this->VerificationCode(10).time();
		$values = array('orderno' => $cus_ord_no);
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);		
		DB::table('paymenthistory')->insert(['pay_type'=>'razorpay', 'pay_user_id' => session('lcbuser_id'),'pay_order_number' => $cus_ord_no,'pay_payment_date' => '', 'pay_status' => '0','pay_trans_id' => '']);		
		
		
		$api = new Api($this->razorKey, $this->razorSecret);

       /* $_SESSION['payable_amount'] = 10;*/

		$razorpayOrder = $api->order->create(array(
		  'receipt'         => $cus_ord_no,
		  'amount'          => $subscription_info->stotalprice * 100, // 2000 rupees in paise
		  'currency'        => 'USD',
		  'payment_capture' => 1 // auto capture
		));
		$amount = $razorpayOrder['amount'];
		$razorpayOrderId = $razorpayOrder['id'];
		$request->session()->put('razorpay_order_id', $razorpayOrderId);
		/*$_SESSION['razorpay_order_id'] = $razorpayOrderId;*/
		$user_info = $this->userdetails();
		
		$payerdata = (object)array('merch_order_id'=>$cus_ord_no,'merch_desc'=>'Reactivate Subscription Payment',"name"=>$user_info->user_name, "email"=>$user_info->user_emailid, "contact"=>'', "cus_ord_no"=>$cus_ord_no);
		$data['payprocessdata'] = $this->prepareData($amount,$razorpayOrderId,$payerdata);
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','1')->first();	
		
		$data['tourl']=url('razorpayresponse');
		return view('user/razorpay', $data);
		
	
	}	
	
	public function razorpayresponse(Request $request)
	{

	
	if($request->session()->has('razorpay_order_id') && $request->session()->get('razorpay_order_id')!="") 
		{
			$success = true;
			
			$error = "Payment Failed";
			
			if (empty($request->razorpay_payment_id) === false)
			{
				$api = new Api($this->razorKey, $this->razorSecret);
				
				try
				{
					// Please note that the razorpay order ID must
					// come from a trusted source (session here, but
					// could be database or something else)
					$attributes = array(
					'razorpay_order_id' => $request->session()->get('razorpay_order_id', ''),
					'razorpay_payment_id' => $request->razorpay_payment_id,
					'razorpay_signature' => $request->razorpay_signature
					);
					
					$api->utility->verifyPaymentSignature($attributes);
				}
				catch(SignatureVerificationError $e)
				{
					$success = false;
					$error = 'Razorpay Error : ' . $e->getMessage();
				}
			}
			
			$request->session()->forget('razorpay_order_id');
			$request->session()->forget('pay_token');
			
			if ($success === true)
			{
					$payment = $api->payment->fetch($request->razorpay_payment_id);
					
					$ptime = time();
					
					if($payment->status == "captured" || $payment->status == "authorized")
					{
						$ref_order_id = $payment->notes->merchant_order_id;
						
						$pay_amount = ($payment->amount > 0)? $payment->amount/100 : 0;
						//$payment_date = date('Y-m-d',strtotime($payment->created_at))."T";
						
						$payment_date = gmdate("Y-m-d\TH:i:s\Z", $payment->created_at);
						
						
						//`trans_id`='$_REQUEST[txn_id]',`status`='1',`payment_date`='$_REQUEST[payment_date]' where `order_number`='$_REQUEST[custom]'"
						$values = array('pay_trans_id' => $payment->id,'pay_payment_date' => $payment_date,'pay_status' => '1','pay_amount' => $pay_amount,'pay_currency' => $payment->currency,'pay_description' => 'Subscription Activated','pay_time' => $payment->created_at);
						
						DB::table('paymenthistory')->where([["pay_order_number","=",$ref_order_id]])->update($values);	
						
						$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
						
						if($last_enddate->sbilling == 1)
		{
			$startdate = date("Y-m-d");
			$enddate = date('Y-m-d',strtotime('+365 days',strtotime($startdate)));
		}
		else
		{	
			if($last_enddate->sbilling == 0)
			{		
				$noofdays = 30;
			}
			if($last_enddate->sbilling == 3)
			{		
				$noofdays = 90;
			}
			if($last_enddate->sbilling == 6)
			{		
				$noofdays = 180;
			}
			if($last_enddate->sbilling == 9)
			{		
				$noofdays = 270;
			}									
			$startdate = date("Y-m-d");
			$hdays = '+'.$noofdays.' days';
			$enddate = date('Y-m-d',strtotime($hdays,strtotime($startdate)));			
		}
						
						$values = array('sstart_date' => $startdate,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
		
						$values = array('rstatus' => '1');
		DB::table('attendees_request')->where([["ruserid","=",session('lcbuser_id')]])->update($values);	
						
						$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();				
		// sending email notification regarding payment
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;
				$details['m_message'] = "Your Payment for Lean Coffee Subscription is successful.";	
				$details['m_content'] = "Now you own the ".$s_details->snofacilitators." Barista pack for 30 days.";				
				Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
				$subject = 'Thanks for your subscription - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});					
		// sending email notification regarding payment				
						
						return redirect('/home')->with("success","Payment success");			
				}
				else
				{
					return redirect('/home')->with("error","Sorry payment not success");
				}
			
			}
			else
			{
				return redirect('/home')->with("error","Sorry payment not success");
			}
			
			
			/*$payment->capture(array('amount' => 5000, 'currency' => 'INR'));*/
			
		}
		else
		{
		return redirect('/home')->wwith("error","an error occurred, please try again later.");
		}
		
	}	
	
	public function upgraderazorpayment(Request $request)
	{
	

	
		if ($request->isMethod('get')) {
			return redirect('/home');
		}
		
		if ($request->isMethod('post')) {
				$randtoken = ($request->_token !="") ? $request->_token : $this->VerificationCode(20);
   				$request->session()->put('pay_token', $randtoken);
		}elseif(!$request->session()->has('pay_token') || $request->session()->get('pay_token')=="")
		{
			 return redirect('/home');
		}
	
		$subscription_info = $this->subscriptiondetails();	
		$user_info = $this->userdetails();
		$cus_ord_no = $this->VerificationCode(10).time();
		
		if($subscription_info->sbilling != 1)
			{
				$pinfo = DB::table('prices')->where('pcount','>=',$subscription_info->snofacilitators)->first();
			}
			else
			{
				$pinfo = DB::table('prices')->where('pcount','>',$subscription_info->snofacilitators)->first();
			}


			if($request->pcount == '' and $request->pprice == '')
			{
				$fcount = $pinfo->pcount;
				$fprice = $request->wrefprice;				
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}
			else
			{
				$fcount = $request->pcount;
				$fprice = $request->pprice;
				//$onedayprice =  number_format(($fprice/30),3); // one day price					
			}

			// to find new price


			if($subscription_info->sbilling == 1)
			{
				$onedayprice =  $subscription_info->stotalprice/365;
			}
			else
			{
				
				if($subscription_info->sbilling == 0)
				{
					$onedayprice =  $subscription_info->stotalprice/30;
				}
				if($subscription_info->sbilling == 3)
				{
					$onedayprice =  $subscription_info->stotalprice/90;
				}
				if($subscription_info->sbilling == 6)
				{
					$onedayprice =  $subscription_info->stotalprice/180;
				}										
				if($subscription_info->sbilling == 9)
				{
					$onedayprice =  $subscription_info->stotalprice/270;
				}					
				
			}
				
				
				
			$start_date = date("Y-m-d");
			$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $start_date)->count();
			if($trial_checking == 0)
			{
				$start_date1 = date("Y-m-d");
				$end_date = $subscription_info->send_date;
			}
			else
			{
				$start_date1 = $subscription_info->trial_end_date;
				$end_date = $subscription_info->send_date;
			}
			
			
			
			$dateDiff = $this->dateDifference($start_date1, $end_date);	


			
			
			$to_minus_price2 = number_format(($dateDiff * $onedayprice),2);
			
			$to_minus_price = str_replace(",","",$to_minus_price2);
			
			$final_price2 = number_format(($fprice - $to_minus_price),2);

			$final_price = str_replace(",","",$final_price2);
				
				
			// to find new price
		
		
		
		$em = explode("___",$request->no_facilitators);
		$cus_ord_no = $this->VerificationCode(10);
		DB::table('upgrade_subscription_payment')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $cus_ord_no,'pay_payment_date' => '',
		'pay_status' => '0','pay_trans_id' => '','pay_current_suscription' => $subscription_info->snofacilitators,'pay_no_baristas' => $em[0],'pay_billed_choice' => $request->billing,'pay_count' => $fcount,'pay_paid_amount' => $final_price,'pay_amount' => $fprice]);	
		
		/*DB::table('paymenthistory')->insert(['pay_type'=>'razorpay', 'pay_user_id' => session('lcbuser_id'),'pay_order_number' => $cus_ord_no,'pay_payment_date' => '', 'pay_status' => '0','pay_trans_id' => '']);	*/	
		
		
		$api = new Api($this->razorKey, $this->razorSecret);

       /* $_SESSION['payable_amount'] = 10;*/

		$razorpayOrder = $api->order->create(array(
		  'receipt'         => $cus_ord_no,
		  'amount'          => $final_price * 100, // 2000 rupees in paise
		  'currency'        => 'USD',
		  'payment_capture' => 1 // auto capture
		));
		$amount = $razorpayOrder['amount'];
		$razorpayOrderId = $razorpayOrder['id'];
		$request->session()->put('razorpay_order_id', $razorpayOrderId);
		/*$_SESSION['razorpay_order_id'] = $razorpayOrderId;*/
		
		$payerdata = (object)array('merch_order_id'=>$cus_ord_no,'merch_desc'=>'Upgrade Subscription Payment',"name"=>$user_info->user_name, "email"=>$user_info->user_emailid, "contact"=>'', "cus_ord_no"=>$cus_ord_no);
		$data['payprocessdata'] = $this->prepareData($amount,$razorpayOrderId,$payerdata);
		$data['totpbanner'] = DB::table('headerbanners')->where('b_id','1')->first();	
		
		$data['tourl']=url('upgraderazorpayresponse');
		return view('user/razorpay', $data);
		
	
		
	}	
	
	public function upgraderazorpayresponse(Request $request)
	{

	
	if($request->session()->has('razorpay_order_id') && $request->session()->get('razorpay_order_id')!="") 
		{
			$success = true;
			
			$error = "Payment Failed";
			
			if (empty($request->razorpay_payment_id) === false)
			{
				$api = new Api($this->razorKey, $this->razorSecret);
				
				try
				{
					// Please note that the razorpay order ID must
					// come from a trusted source (session here, but
					// could be database or something else)
					$attributes = array(
					'razorpay_order_id' => $request->session()->get('razorpay_order_id', ''),
					'razorpay_payment_id' => $request->razorpay_payment_id,
					'razorpay_signature' => $request->razorpay_signature
					);
					
					$api->utility->verifyPaymentSignature($attributes);
				}
				catch(SignatureVerificationError $e)
				{
					$success = false;
					$error = 'Razorpay Error : ' . $e->getMessage();
				}
			}
			
			$request->session()->forget('razorpay_order_id');
			$request->session()->forget('pay_token');
			
			if ($success === true)
			{
					$payment = $api->payment->fetch($request->razorpay_payment_id);
					
					$ptime = time();
					
					if($payment->status == "captured" || $payment->status == "authorized")
					{
						$ref_order_id = $payment->notes->merchant_order_id;
						$pay_amount = ($payment->amount > 0)? $payment->amount/100 : 0;
						//$payment_date = date('Y-m-d',strtotime($payment->created_at))."T";
						$payment_date = gmdate("Y-m-d\TH:i:s\Z", $payment->created_at);
						
						
						
						
						
						
						
			$values = array('pay_trans_id' => $payment->id,'pay_payment_date' => $payment_date,'pay_status' => '1');
			DB::table('upgrade_subscription_payment')->where([["pay_order_number","=",$ref_order_id]])->update($values);
						
						
						
			
			$values = array('pay_trans_id' => $payment->id,'pay_payment_date' => $payment_date,'pay_status' => '1');
			DB::table('upgrade_subscription_payment')->where([["pay_order_number","=",$ref_order_id]])->update($values);	
			$ptime = time();
			

		
					
			
			// to change upgrade subscription
			$sub_details = DB::table('upgrade_subscription_payment')->where("pay_order_number","=",$ref_order_id)->first();
			$st_date = date("Y-m-d");
			if($sub_details->pay_billed_choice != 1)
			{
				$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
				
				// find user in trial or not
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $st_date)->count();
				// find user in trial or not
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					if($sub_details->pay_billed_choice == 0)
					{
						$hdays = '+30 days';$hdayinfo = 30;
					}
					if($sub_details->pay_billed_choice == 3)
					{
						$hdays = '+90 days';$hdayinfo = 90;
					}
					if($sub_details->pay_billed_choice == 6)
					{
						$hdays = '+180 days';$hdayinfo = 180;
					}
					if($sub_details->pay_billed_choice == 9)
					{
						$hdays = '+270 days';$hdayinfo = 270;
					}										
					
				}
				else
				{
					$start_date1 = date("Y-m-d");
 					$end_date1 = $last_enddate->trial_end_date;
 					$dateDiff = $this->dateDifference($start_date1, $end_date1);
					
					if($sub_details->pay_billed_choice == 0)
					{
						$finaldate = 30+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 3)
					{
						$finaldate = 90+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 6)
					{
						$finaldate = 180+$dateDiff;
					}
					if($sub_details->pay_billed_choice == 9)
					{
						$finaldate = 270+$dateDiff;
					}															
					
					$hdays = '+'.$finaldate.' days';$hdayinfo = $finaldate;
										
				}
				$enddate = date('Y-m-d',strtotime($hdays,strtotime($start_date1)));			
			}
			else
			{
				$last_enddate = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
				// find user in trial or not
				$trial_checking = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->where('trial_end_date', '>', $st_date)->count();
				// find user in trial or not
				if($trial_checking == 0)
				{
					$start_date1 = date("Y-m-d");
					$hdays = '+365 days';$hdayinfo = 365;
				}
				else
				{
					$start_date1 = date("Y-m-d");
 					$end_date1 = $last_enddate->trial_end_date;
 					$dateDiff = $this->dateDifference($start_date1, $end_date1);
					$finaldate = 365+$dateDiff;
					$hdays = '+'.$finaldate.' days'; $hdayinfo = $finaldate;
										
				}
				$enddate = date('Y-m-d',strtotime($hdays,strtotime($start_date1)));					
			}
			
			// update in payment history table
		/*DB::table('paymenthistory')->insert(['pay_user_id' => session('lcbuser_id'),'pay_order_number' => $ref_order_id,'pay_payment_date' => $payment_date,
		'pay_status' => '1','pay_trans_id' => $payment->id]);	*/			
			// update in payment history table
			
			
		
		
			
		$values = array('sstart_date' => $start_date1,'send_date' => $enddate,'sstatus' => '1','six_day_status' => '0','after_trial_status' => '0','two_day_status' => '0','four_day_status' => '0','sbilling' => $sub_details->pay_billed_choice,'snofacilitators' => $sub_details->pay_count,'stotalprice' => $sub_details->pay_amount,'advance_done' => '0');
		DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->update($values);	
		
		
	$sub_details_new = DB::table('upgrade_subscription_payment')->where("pay_order_number","=",$ref_order_id)->first();	
// insert into paymenthistory table
$st_date = date("Y-m-d")."T";
if($sub_details_new->pay_billed_choice == 1)
{
	$cmonth = "1 year";
}
else
{
	$cmonth = $sub_details_new->pay_billed_choice." months";
}


$subscription_message = $sub_details_new->pay_count.' Barista upgraded for '.$cmonth;
DB::table('paymenthistory')->insert(['pay_type'=>'razorpay','pay_currency' => $payment->currency,'pay_user_id' => session('lcbuser_id'),'pay_order_number' => $ref_order_id,'pay_trans_id' => $payment->id,
'pay_status' => '1','pay_payment_date' => $payment_date,'pay_amount' => $pay_amount,'pay_description' => $subscription_message,'pay_time' => $payment->created_at]);	
// insert into paymenthistory table


		
		
					
			// to change upgrade subscription
			
			$s_details = DB::table('subscription')->where([["suserid","=",session('lcbuser_id')]])->first();
			
		// sending email notification regarding payment
		
				$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();
				$details['m_name'] = $userinfo->user_name;
				$details['m_emailid'] = $userinfo->user_emailid;
				$details['m_message'] = "Your payment to upgrade your LeanCoffeeBrew Subscription was successful.";	
				$details['m_content'] = "You now have ".$s_details->snofacilitators." Barista pack for ".$hdayinfo." days.";		
				Mail::send('mail.mail_advance_payment_notification', $details, function($message) use ($details) {
				$subject = 'Thanks for your subscription - Lean Coffee Brew';
				$message->to($details["m_emailid"] , $details["m_name"])->subject($subject);
				});		
							
		// sending email notification regarding payment	
			
			return redirect('/home')->with("success","Your subscription upgraded successfully");					
				
			}
				else
				{
					return redirect('/home')->with("error","Sorry payment not success");
				}
			
			}
			else
			{
				return redirect('/home')->with("error","Sorry payment not success");
			}
			
			
			/*$payment->capture(array('amount' => 5000, 'currency' => 'INR'));*/
			
		}
		else
		{
		return redirect('/home')->with("error","an error occurred, please try again later.");
		}
		
	}	
	
	public function razorPayDetailById(Request $request)
	{
		$api = new Api($this->razorKey, $this->razorSecret);
		$payment = $api->payment->fetch('pay_29QQoUBi66xm2f');
	}
	
	public function cleartable()
	{
		DB::table('actions')->truncate();
		DB::table('agenda_discussion')->truncate();
		DB::table('agenda_items')->truncate();
		DB::table('agenda_meeting_info')->truncate();
		DB::table('all_payment_history')->truncate();
		DB::table('attendees_request')->truncate();
		DB::table('billing_details')->truncate();
		DB::table('boards')->truncate();
		DB::table('capacity_load')->truncate();
		DB::table('chat_message')->truncate();	
		
		DB::table('columns')->truncate();
		DB::table('facilitators_deleted_request')->truncate();
		DB::table('facilitators_request')->truncate();
		DB::table('fishbone')->truncate();

		DB::table('guest_request')->truncate();
		DB::table('openspace')->truncate();
		DB::table('paymenthistory')->truncate();
		DB::table('releases')->truncate();
		DB::table('siteusers')->truncate();
		
		DB::table('subscription')->truncate();
		DB::table('topics')->truncate();
		DB::table('topics_votes')->truncate();
		DB::table('topic_discussion')->truncate();		
		
		DB::table('upgrade_subscription_payment')->truncate();
		DB::table('topics')->truncate();
		DB::table('topics_votes')->truncate();
		DB::table('topic_discussion')->truncate();		 
											
	}	
	// for razor payment
}
