<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use DB;
use PDF;
use Mail;
class AgendaController extends Controller
{

	public function checkagendameetinglivestatus(Request $request)
	{
		$this->updateusertime();
		$data['bar_info'] = DB::table('boards')->where('meeting_id',$request->id)->first();	
		return view('user/checkagendameetinglivestatus',$data);
	}
	
    public function agendameeting(Request $request)
	{
		$this->updateusertime();
		$sub_info = $this->subscriptiondetails();
		$user_info = $this->userdetails();
		
		$ifexist = DB::table('boards')->where('meeting_id',$request->id)->count();
		if($ifexist == 0)
		{
			if($user_info->user_type == 2)
			{
				return redirect('/attendeehome');
			}
			
			if($user_info->user_type == 1 and $data['meeting_by']->meeting_by != $user_info->user_id)
			{
				return redirect('/boards');
			}
			else
			{
				return redirect('/boards');
			}
			
			if($user_info->user_type == 3)
			{
				$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
				if($ifanyboards == 0)
				{
					session()->put('lcbuser_id','');			
					session()->put('lcbuser_name','');
					session()->put('lcbuser_ftype','');		
					return redirect('/index');
				}
			}
			
			
		}
		
		
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->id)->first();
		
		
		if($user_info->user_type == 2)
		{
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->count();	//where('rstatus','1')->
			if($ifanyboards == 0)
			{
				return redirect('/attendeehome');
			}
		}
		
		if($user_info->user_type == 1 and $data['meeting_by']->meeting_by != $user_info->user_id)
		{			
			$ifanyboards = DB::table('attendees_request')->where('rboardid',$request->id)->where('remailid',$user_info->user_emailid)->count();	//where('rstatus','1')->
			if($ifanyboards == 0)
			{
				return redirect('/boards');
			}			
		}
		
		if($user_info->user_type == 3)
		{
			$ifanyboards = DB::table('boards')->where('meeting_id',$request->id)->where('meeting_no_guests','0')->count();	
			if($ifanyboards == 0)
			{
				session()->put('lcbuser_id','');			
				session()->put('lcbuser_name','');
				session()->put('lcbuser_ftype','');		
				return redirect('/index');
			}
		}				
		
				
		$data['agenda_id'] = $request->id;
		
		// to find agenda meeting details added
		$data['agenda_meeting_info_count'] = DB::table('agenda_meeting_info')->where('agenda_meeting_id',$request->id)->count();	
		
		if($data['agenda_meeting_info_count'] != 0)
		{
		$data['agenda_meeting_info'] = DB::table('agenda_meeting_info')->where('agenda_meeting_id',$request->id)->first();	
		if($data['agenda_meeting_info']->agenda_conf_link != '')
		{
			$conf_link = explode("j/",$data['agenda_meeting_info']->agenda_conf_link);
			$data['agenda_conf_linkinfo'] = $conf_link[1];		
		}
		else
		{
			$data['agenda_conf_linkinfo'] = '';	
		}	
		}
		else
		{
			$data['agenda_conf_linkinfo'] = '';	
		}
		// to find agenda meeting details added
		
		// facilitator details
		$data['bar_info'] = DB::table('boards')->join('siteusers as A' ,'boards.meeting_by','=','A.user_id')->where('boards.meeting_id',$request->id)->first();		
		// facilitator details
		
		// list of attendees
		$data['participants_info_agenda'] = DB::table('attendees_request')->where('rboardid',$request->id)->get();	
		// list of attendees
		
		// if any guest joined
		$rr_no = $data['meeting_by']->meeting_rand;
		$checkanyguestcount = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->count();
		if($checkanyguestcount != 0)
		{
			$data['showguests'] = 1; 
			$data['guestinfos'] = DB::table('siteusers')->where('user_emailid','like','%'.$rr_no.'%')->get();
		}
		else
		{
			$data['showguests'] = 0; 
		}
		// if any guest joined
		
		// list of times
		$data['times_info_agenda'] = DB::table('times')->orderBy('time_id','ASC')->get();	
		// list of times		
		$data['dataexist'] = DB::table('agenda_items')->where('a_agenda_id',$request->id)->orderBy('a_order_by','ASC')->get();
		

		
		$data['item_id'] = $request->item_id;	
		if($request->item_id != '')
		{
			$data['current_agenda_item_info'] = DB::table('agenda_items')->where('a_agenda_item_id',$request->item_id)->first();
			$data['agenda_links_info'] =  DB::table('agenda_discussion')->join('siteusers as A' ,'agenda_discussion.agenda_user_id','=','A.user_id')->
			where('agenda_discussion.agenda_for_item_id',$request->item_id)->where('agenda_discussion.agenda_lna','0')->orderBy('agenda_discussion.agenda_discussion_id','DESC')->get();
			
			$find_board_id =  DB::table('agenda_items')->where('a_agenda_item_id',$request->id)->first();
			
			//$data['find_created_barista'] =  DB::table('boards')->select('meeting_by')->where('meeting_id',$find_board_id->a_agenda_id)->first();
			$data['user_info'] = $this->userdetails();
			
			
		}			
					
		return view('user/agendameeting',$data);
			
	}
	
	
	public function delete_agenda_meeting(Request $request)
	{
		$this->updateusertime();
		$itemids=array();
		$loopvaluesall = DB::table('agenda_items')->where('a_agenda_id',$request->id)->get();
		foreach($loopvaluesall as $lp)
		{
			array_push($itemids,$lp->a_agenda_item_id);
		}
		$data['allitemids'] = $itemids;
			
		DB::table('boards')->where('meeting_id',$request->id)->delete();	
		DB::table('agenda_meeting_info')->where('agenda_meeting_id',$request->id)->delete();
		DB::table('agenda_items')->where('a_agenda_id',$request->id)->delete();
		DB::table('agenda_discussion')->whereIn('agenda_for_item_id',$data['allitemids'])->delete();
		
		DB::table('attendees_request')->where('rboardid',$request->id)->delete();	
		return 1;
	}
	

	
	public function addattendeerequest_agenda(Request $request)
	{		
		$this->updateusertime();
		// check same user id
		$user_info = $this->userdetails();
		if($request->reqemail == $user_info->user_emailid)
		{		
			$htmlmsg='';	
			$results=array("count"=>1,"attendee_list"=>$htmlmsg,"status"=>4);
		}
		else
		{
		
		$alreadyexistcount = DB::table('attendees_request')->where('rboardid',$request->cur_mid)->where([["remailid","=",$request->reqemail]])->count();
		if($alreadyexistcount == 1)
		{
			$htmlmsg='';	
			$results=array("count"=>1,"attendee_list"=>$htmlmsg,"status"=>2);
		}
		else
		{
		// check same user id
		
		$barista_user_exist =  DB::table('siteusers')->where('user_emailid',$request->reqemail)->count();
		if($barista_user_exist == 0)
		{
			$r_status = 0;
		}
		else
		{
			$r_status = 1;
		}
							
		$vcode = $this->VerificationCode(10);
		DB::table('attendees_request')->insert(['ruserid' => session('lcbuser_id'),'rboardid' => $request->cur_mid,'remailid' =>$request->reqemail,'rstatus' =>$r_status,'rtoken' =>$vcode]);
		$values = array('meeting_name' => $request->mcname);
		DB::table('boards')->where([["meeting_id","=",$request->cur_mid]])->update($values);	
		$boards_rand = DB::table('boards')->where('meeting_id',$request->cur_mid)->first();
		$fac_info =  DB::table('attendees_request')->where('rboardid',$request->cur_mid)->orderBy('rid','DESC')->get();

		// create table
		$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
		$uid = "user_id_".$fs->rid;
		$did=$fs->rid;
		$htmlmsg.="<tr id=".$uid."><td>".$fs->remailid."</td>";

		$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-attendee-agenda' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
		}
				
		$htmlmsg.="</table>";	
		// create table	
		$results=array("count"=>1,"attendee_list"=>$htmlmsg,"status"=>1);
		
			// send mail

			$userinfo = DB::table('siteusers')->where([["user_id","=",session('lcbuser_id')]])->first();				
			$sdata2['m_name'] = $userinfo->user_name;
			$sdata2['m_emailid'] = $request->reqemail;	
			$sdata2['m_rand'] = $vcode;	
			
			$sdata2['m_name'] = $request->cur_mname;
			$sdata2['m_date'] = $request->cur_mdate;
			$sdata2['m_stime'] = $request->cur_mstarttime;
			$sdata2['m_etime'] = $request->cur_mendtime;
			if($request->cur_mobj != '')
			{
				$sdata2['m_obj'] = $request->cur_mobj;
				$sdata2['m_obj_choice'] = 1;
			}
			else
			{
				$sdata2['m_obj'] = '';$sdata2['m_obj_choice'] = 0;
			}
			
			
																		
			Mail::send('mail.mail_attendee_request_agenda', $sdata2, function($message) use ($sdata2) {
			$subject = "You have been invited to an Agenda-driven session by ".$sdata2['m_name'];
			$message->to($sdata2['m_emailid'])->subject($subject);
			});	
							
			// send mail
			
		}
		}			
		return response()->json($results);						
	}	
	
	public function removethisattendee_agenda(Request $request)
	{
		$this->updateusertime();
		DB::table('attendees_request')->where('rid',$request->id)->delete();	
	 	$results=array("status"=>'1');
     	return response()->json($results);	
	}
	
	public function addagendameeting(Request $request)
	{
		$this->updateusertime();
		if($request->from != '')
		{
			$adata = $request->from;
		}
		else
		{
			$adata = '';
		}
		
		if($request->start_time != '')
		{
			$astime = $request->start_time;
		}
		else
		{
			$astime = '';
		}
		
		if($request->end_time != '')
		{
			$aetime = $request->end_time;
		}
		else
		{
			$aetime = '';
		}
			
		// to update meeting name 
		$values = array('meeting_name' => $request->meeting_title);
		DB::table('boards')->where([["meeting_id","=",$request->a_mid]])->update($values);
		// to update meeting name
		
		
		// to insert into agenda meeting table					
		DB::table('agenda_meeting_info')->insert(['agenda_meeting_id' => $request->a_mid,'agenda_date' =>$adata,'agenda_start_time' =>$astime,'agenda_end_time' =>$aetime,'agenda_objectives' =>$request->meeting_objectives,'agenda_conf_link' =>$request->conf_link,'agenda_password' => $request->conf_pwd]);
		// to insert into agenda meeting table
		
		
		return 1;
	}	
	
	public function editagendameeting(Request $request)
	{
		$this->updateusertime();
		if($request->from != '')
		{
			$adata = $request->from;
		}
		else
		{
			$adata = '';
		}
		
		if($request->start_time != '')
		{
			$astime = $request->start_time;
		}
		else
		{
			$astime = '';
		}
		
		if($request->end_time != '')
		{
			$aetime = $request->end_time;
		}
		else
		{
			$aetime = '';
		}
			
		// to update meeting name 
		$values = array('meeting_name' => $request->meeting_title);
		DB::table('boards')->where([["meeting_id","=",$request->a_mid]])->update($values);
		// to update meeting name
				
		// to update into agenda meeting table					
		$values2 = array('agenda_date' =>$adata,'agenda_start_time' =>$astime,'agenda_end_time' =>$aetime,'agenda_objectives' =>$request->meeting_objectives,'agenda_conf_link' =>$request->conf_link,'agenda_password' => $request->conf_pwd);
		DB::table('agenda_meeting_info')->where([["agenda_meeting_id","=",$request->a_mid]])->update($values2);		
		// to update into agenda meeting table
		
		return 1;
	}	


	public function addagendameetingitem(Request $request)
	{
		$this->updateusertime();
		$dataexist = DB::table('agenda_items')->where('a_agenda_id',$request->a_mid)->count();
		if($dataexist == 0)
		{
		$data['agenda_meeting_info'] = DB::table('agenda_meeting_info')->where('agenda_meeting_id',$request->a_mid)->first();
		$start_time = $data['agenda_meeting_info']->agenda_start_time;	
		}
		else
		{
			$data['last_time'] =  DB::table('agenda_items')->where('a_agenda_id',$request->a_mid)->orderBy('a_agenda_item_id','DESC')->first();
			$curtime = $data['last_time']->a_agenda_item_time;
			$newtime = strtotime($curtime) + ($data['last_time']->a_agenda_item_length * 60);
			$start_time = date('H:i', $newtime);
			
			$newtime2 = strtotime($start_time) + ($request->item_length * 60);
			$time1 = date('H:i', $newtime2);

			
			// to find maximum time
			$data['agenda_meeting_info2'] = DB::table('agenda_meeting_info')->where('agenda_meeting_id',$request->a_mid)->first();
			$time2 = $data['agenda_meeting_info2']->agenda_end_time;
			
			
			
			
//
function checkTime($time1,$time2)
{
$start = strtotime($time1);

$end = strtotime($time2);

if ($end-$start >= 0)
return 1;
else
return 0;
}
//			
if(checkTime($time1,$time2))
{
$resl = 0;
}
else
{
	
	$results=array("count"=>2);
	return response()->json($results);
	exit();
}

			
			// to find maximum time
			
			
		}	
		// to find order by
		$ifanyitems =  DB::table('agenda_items')->where('a_agenda_id',$request->a_mid)->count();
		if($ifanyitems == 0)
		{
			$orderbyinfo = 1;
		}
		else
		{
			$fac_det =  DB::table('agenda_items')->where('a_agenda_id',$request->a_mid)->orderBy('a_order_by','DESC')->first();
			$orderbyinfo = $fac_det->a_order_by+1;
		}
		// to find order by
		// to insert into agenda item table					
		DB::table('agenda_items')->insert(['a_agenda_id' => $request->a_mid,'a_agenda_item_title' =>$request->item_title,'a_agenda_item_type' =>$request->item_type,'a_agenda_item_length' =>$request->item_length,'a_agenda_item_descriptions' =>$request->item_info,'a_agenda_item_time' =>$start_time,'a_agenda_item_status' =>'1','a_order_by'=>$orderbyinfo]);
		// to insert into agenda item table
		
		$fac_info =  DB::table('agenda_items')->where('a_agenda_id',$request->a_mid)->orderBy('a_order_by','ASC')->get();
		
		$htmlmsg = "";		
		foreach($fac_info as $fs)
		{
		$ddid=$fs->a_agenda_item_id;
		if($fs->a_agenda_item_type == '1')
		{
			$htmlmsg.= "<div class='card' id='item-$ddid' style='background-color:#F2F2F2;cursor:pointer'>";
		}
		else
		{
			$htmlmsg.= "<div class='card' id='item-$ddid' style='background-color:#989898;cursor:pointer'>";
		}		
		$htmlmsg.= "<span class='namesinfo_medium agenda_pressed_edit' align='right' data-id=$ddid>".$fs->a_agenda_item_time."&nbsp;&nbsp;&nbsp;".$fs->a_agenda_item_title."&nbsp;&nbsp;&nbsp;".$fs->a_agenda_item_length."</span></div>";
		}
		$htmlmsg.= '';
		$results=array("count"=>1,"agenda_items"=>$htmlmsg);
		return response()->json($results);
	}
	
	// edit agenda items
	public function editagendameetingitem(Request $request)
	{
		$this->updateusertime();
		
		// change time for next records
		// to find edit id time details
		$data['edited_item_info'] = DB::table('agenda_items')->where('a_agenda_item_id',$request->edit_itemid)->first();
		if($data['edited_item_info']->a_agenda_item_length >= $request->item_length)
		{
			$msg = 0; $dif_length = $data['edited_item_info']->a_agenda_item_length - $request->item_length;
		}
		else
		{
			$msg = 1; $dif_length = $request->item_length - $data['edited_item_info']->a_agenda_item_length;
		}
		
		// to find edit id time details
		$other_agenda_items =  DB::table('agenda_items')->where('a_agenda_id',$request->edit_mid)->where('a_agenda_item_id','>',$request->edit_itemid)->orderBy('a_agenda_item_id','ASC')->get();
		
		foreach($other_agenda_items as $other_items)
		{
			$curtime = $other_items->a_agenda_item_time;
			if($msg == 0)
			{
				$newtime = strtotime($curtime) - ($dif_length * 60);
			}
			else
			{
				$newtime = strtotime($curtime) + ($dif_length * 60);
			}
			
			$start_time2 = date('H:i', $newtime);
			$newvalues = array('a_agenda_item_time' => $start_time2);
			DB::table('agenda_items')->where([["a_agenda_item_id","=",$other_items->a_agenda_item_id]])->update($newvalues);			
		}
		
		// update data
		$values = array('a_agenda_item_title' =>$request->item_title,'a_agenda_item_type' =>$request->item_type,'a_agenda_item_length' =>$request->item_length,'a_agenda_item_descriptions' =>$request->item_info2,'a_agenda_item_status' =>'1');
		DB::table('agenda_items')->where([["a_agenda_item_id","=",$request->edit_itemid]])->update($values);
		// update data		
		
		$fac_info =  DB::table('agenda_items')->where('a_agenda_id',$request->edit_mid)->orderBy('a_order_by','ASC')->get();
		
		$htmlmsg = "";		
		foreach($fac_info as $fs)
		{
		$ddid=$fs->a_agenda_item_id;
		if($fs->a_agenda_item_type == '1')
		{
			$htmlmsg.= "<div class='card' id='item-$ddid' style='background-color:#F2F2F2;cursor:pointer'>";
		}
		else
		{
			$htmlmsg.= "<div class='card' id='item-$ddid' style='background-color:#989898;cursor:pointer'>";
		}
		$htmlmsg.= "<span class='namesinfo_medium agenda_pressed_edit' align='right' data-id=$ddid>".$fs->a_agenda_item_time."&nbsp;&nbsp;&nbsp;".$fs->a_agenda_item_title."&nbsp;&nbsp;&nbsp;".$fs->a_agenda_item_length."</span></div>";
		}
		$htmlmsg.= '';
		$results=array("count"=>1,"agenda_items"=>$htmlmsg);
		return response()->json($results);		
		
		// change time for next records
	}
	// edit agenda items
	
	// delete agenda items	
	public function delete_agenda_items(Request $request)	
	{
		$this->updateusertime();
		$data['deleted_item_info'] = DB::table('agenda_items')->where('a_agenda_item_id',$request->id)->first();
		//$data['deleted_item_info']->a_agenda_item_time;
		$other_agenda_items =  DB::table('agenda_items')->where('a_agenda_item_id','>=',$request->id)->orderBy('a_agenda_item_id','ASC')->get();
		$csvtopicids=array(); $i=0;
		foreach($other_agenda_items as $ff)
		{
			array_push($csvtopicids,$ff->a_agenda_item_time);
		}
		$data['csvtopicids'] = $csvtopicids;
		$other_agenda_items2 =  DB::table('agenda_items')->where('a_agenda_item_id','>',$request->id)->orderBy('a_agenda_item_id','ASC')->get();
		$j=0;
		foreach($other_agenda_items2 as $ff2)
		{
			$newvalues = array('a_agenda_item_time' => $data['csvtopicids'][$j]);
			DB::table('agenda_items')->where([["a_agenda_item_id","=",$ff2->a_agenda_item_id]])->update($newvalues);	
			$j++;		
		}

		DB::table('agenda_items')->where('a_agenda_item_id',$request->id)->delete();
		
		
		$fac_info =  DB::table('agenda_items')->where('a_agenda_id',$request->mid)->orderBy('a_order_by','ASC')->get();
		
		$htmlmsg = "";		
		foreach($fac_info as $fs)
		{
		$ddid=$fs->a_agenda_item_id;
		if($fs->a_agenda_item_type == '1')
		{
			$htmlmsg.= "<div class='card' id='item-$ddid' style='background-color:#F2F2F2;cursor:pointer'>";
		}
		else
		{
			$htmlmsg.= "<div class='card' id='item-$ddid' style='background-color:#989898;cursor:pointer'>";
		}
		$htmlmsg.= "<span class='namesinfo_medium agenda_pressed_edit' align='right' data-id=$ddid>".$fs->a_agenda_item_time."&nbsp;&nbsp;&nbsp;".$fs->a_agenda_item_title."&nbsp;&nbsp;&nbsp;".$fs->a_agenda_item_length."</span></div>";
		}
		$htmlmsg.= '';
		$results=array("count"=>1,"agenda_items"=>$htmlmsg);
		return response()->json($results);	
		
	}
	// delete agenda items	
	
	
public function agenda_links_notes_actions(Request $request)
{
$this->updateusertime();
$data['user_info'] = $this->userdetails();

$fac_info =  DB::table('agenda_discussion')->join('siteusers as A' ,'agenda_discussion.agenda_user_id','=','A.user_id')->
where('agenda_discussion.agenda_for_item_id',$request->id)->where('agenda_discussion.agenda_lna','0')->orderBy('agenda_discussion.agenda_discussion_id','DESC')->get();


//create table	
$htmlmsg = "<table class='table table-bordered'>";		
foreach($fac_info as $fs)
{
$uid = "aitem_id_".$fs->agenda_discussion_id;
$uname = ucfirst(substr($fs->user_name,0,2));
$did=$fs->agenda_discussion_id;
$htmlmsg.="<tr id=".$uid."><td class='ere_btn' width='7%'>".$uname."</td><td>"."<a href=''>$fs->agenda_title</a>"."</td>";
if($fs->agenda_meeting_created_by == $data['user_info']->user_id)
{
$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-item-links' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";		
}
else
{
if($fs->agenda_user_id == $data['user_info']->user_id)
{
$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-item-links' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
}
else
{
$htmlmsg.="<td>---</td></tr>";
}
}


}

$htmlmsg.="</table>";

$htmlmsg .="__________";


$notes_info =  DB::table('agenda_discussion')->join('siteusers as A' ,'agenda_discussion.agenda_user_id','=','A.user_id')->
where('agenda_discussion.agenda_for_item_id',$request->id)->where('agenda_discussion.agenda_lna','1')->orderBy('agenda_discussion.agenda_discussion_id','DESC')->get();


//create table	
$htmlmsg .= "<table class='table table-bordered'>";		
foreach($notes_info as $fs)
{
$uid = "aitem_id_".$fs->agenda_discussion_id;
$uname = ucfirst(substr($fs->user_name,0,2));
$did=$fs->agenda_discussion_id;
$htmlmsg.="<tr id=".$uid."><td class='ere_btn' width='7%'>".$uname."</td><td>"."<a href=''>$fs->agenda_title</a>"."</td>";
if($fs->agenda_meeting_created_by == $data['user_info']->user_id)
{
$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-item-notes' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";		
}
else
{
if($fs->agenda_user_id == $data['user_info']->user_id)
{
$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-item-notes' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
}
else
{
$htmlmsg.="<td>---</td></tr>";
}
}


}

$htmlmsg.="</table>";

$htmlmsg .="__________";

$links_info =  DB::table('agenda_discussion')->join('siteusers as A' ,'agenda_discussion.agenda_user_id','=','A.user_id')->
where('agenda_discussion.agenda_for_item_id',$request->id)->where('agenda_discussion.agenda_lna','2')->orderBy('agenda_discussion.agenda_discussion_id','DESC')->get();


//create table	
$htmlmsg .= "<table class='table table-bordered'>";		
foreach($links_info as $fs)
{
$uid = "aitem_id_".$fs->agenda_discussion_id;
$uname = ucfirst(substr($fs->user_name,0,2));
$did=$fs->agenda_discussion_id;
$htmlmsg.="<tr id=".$uid."><td class='ere_btn' width='7%'>".$uname."</td><td>"."<a href=''>$fs->agenda_title</a>"."</td>";
if($fs->agenda_meeting_created_by == $data['user_info']->user_id)
{
$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-item-links' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";		
}
else
{
if($fs->agenda_user_id == $data['user_info']->user_id)
{
$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-item-links' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
}
else
{
$htmlmsg.="<td>---</td></tr>";
}
}


}

$htmlmsg.="</table>";

 
$results=array("count"=>1,"allagenda_links"=>$htmlmsg);
return response()->json($results);			
	


}
		
	public function addlinksfor_agenda(Request $request)
	{
		$this->updateusertime();
		$tinfo = date('Y-m-d-H:i:s');
		DB::table('agenda_discussion')->insert(['agenda_meeting_id' => $request->c_boardid,'agenda_meeting_created_by' => $request->c_mby,'agenda_user_id' => session('lcbuser_id'),'agenda_for_item_id' => $request->c_itemid,'agenda_title' =>$request->link_title,'agenda_url' =>$request->link_info,'agenda_lna' =>'0','agenda_time'=>$tinfo]);
		
		/*$fac_info =  DB::table('agenda_discussion')->join('siteusers as A' ,'agenda_discussion.agenda_user_id','=','A.user_id')->
	where('agenda_discussion.agenda_for_item_id',$request->c_itemid)->where('agenda_discussion.agenda_lna','0')->orderBy('agenda_discussion.agenda_discussion_id','DESC')->get();*/
	
	
			//$find_board_id =  DB::table('agenda_items')->select('a_agenda_id')->where('a_agenda_item_id',$request->c_itemid)->first();
			
			//$data['find_created_barista'] =  DB::table('boards')->select('meeting_by')->where('meeting_id',$find_board_id->a_agenda_id)->first();
			//$data['user_info'] = $this->userdetails();
			return 1;
			
		// create table
		/*$htmlmsg = "<table class='table table-bordered'>";		
		foreach($fac_info as $fs)
		{
		$uid = "aitem_id_".$fs->agenda_discussion_id;
		$uname = ucfirst(substr($fs->user_name,0,2));
		$did=$fs->agenda_discussion_id;
		$htmlmsg.="<tr id=".$uid."><td class='ere_btn' width='7%'>".$uname."</td><td>"."<a href=''>$fs->agenda_title</a>"."</td>";
		if($fs->meeting_by == $data['user_info']->user_id)
		{
			$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-item-links' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";		
		}
		else
		{
			if($fs->agenda_user_id == $data['user_info']->user_id)
			{
				$htmlmsg.="<td><a class='re_btn btn-danger btn-sm delete-item-links' data-id='$did' href='javascript:void(0)' alt='Delete' title='Delete'>REMOVE</a></td></tr>";
			}
			else
			{
				$htmlmsg.="<td>---</td></tr>";
			}
		}
		
		
		}
				
		$htmlmsg.="</table>";*/
		//$results=array("count"=>1,"allagenda_links"=>$htmlmsg);
		//return response()->json($results);			
		// create table	
						
	}

	public function removelinkid(Request $request)
	{
		$this->updateusertime();
		DB::table('agenda_discussion')->where('agenda_discussion_id',$request->id)->delete();
		return 1;
	}
	
	
	public function agenda_item_notes_entry(Request $request)
	{
		$this->updateusertime();
		$tinfo = date('Y-m-d-H:i:s');
		DB::table('agenda_discussion')->insert(['agenda_meeting_id' => $request->c_boardid,'agenda_meeting_created_by' => $request->c_mby,'agenda_user_id' => session('lcbuser_id'),'agenda_for_item_id' => $request->c_itemid,'agenda_title' =>$request->notes_message,'agenda_url' =>'','agenda_lna' =>'1','agenda_time'=>$tinfo]);
		return 1;
	}	


	public function getallnotes(Request $request)
	{	
		$this->updateusertime();
		$data['allnotes'] =  DB::table('agenda_discussion')->join('siteusers as A' ,'agenda_discussion.agenda_user_id','=','A.user_id')->
			where('agenda_discussion.agenda_for_item_id',$request->id)->where('agenda_discussion.agenda_lna','1')->orderBy('agenda_discussion.agenda_discussion_id','DESC')->get(); 
/*			$find_board_id =  DB::table('agenda_items')->select('a_agenda_id')->where('a_agenda_item_id',$request->id)->first();
			
			$data['find_created_barista'] =  DB::table('boards')->select('meeting_by')->where('meeting_id',$find_board_id->a_agenda_id)->first();*/
			$data['user_info'] = $this->userdetails();
		return view('user/getallnotes',$data);
	}
	
	
	public function getalllinks(Request $request)
	{
		$this->updateusertime();
		$data['agenda_links_info'] =  DB::table('agenda_discussion')->join('siteusers as A' ,'agenda_discussion.agenda_user_id','=','A.user_id')->
			where('agenda_discussion.agenda_for_item_id',$request->id)->where('agenda_discussion.agenda_lna','0')->orderBy('agenda_discussion.agenda_discussion_id','DESC')->get(); 
/*			$find_board_id =  DB::table('agenda_items')->select('a_agenda_id')->where('a_agenda_item_id',$request->id)->first();
			
			$data['find_created_barista'] =  DB::table('boards')->select('meeting_by')->where('meeting_id',$find_board_id->a_agenda_id)->first();*/
			$data['user_info'] = $this->userdetails();
		return view('user/getalllinks',$data);
	}
	
	
		
	public function removenotesid(Request $request)
	{
		$this->updateusertime();
		DB::table('agenda_discussion')->where('agenda_discussion_id',$request->id)->delete();
		return 1;
	}
	
	public function agenda_item_actions_entry(Request $request)
	{
		$this->updateusertime();
		$tinfo = date('Y-m-d-H:i:s');
		DB::table('agenda_discussion')->insert(['agenda_meeting_id' => $request->c_boardid,'agenda_meeting_created_by' => $request->c_mby,'agenda_user_id' => session('lcbuser_id'),'agenda_for_item_id' => $request->c_itemid,'agenda_title' =>$request->action_message,'agenda_url' =>'','agenda_lna' =>'2','agenda_time'=>$tinfo]);
		return 1;
	}		
	
	public function getallactions(Request $request)
	{
		$this->updateusertime();
		$data['allactions'] =  DB::table('agenda_discussion')->join('siteusers as A' ,'agenda_discussion.agenda_user_id','=','A.user_id')->
			where('agenda_discussion.agenda_for_item_id',$request->id)->where('agenda_discussion.agenda_lna','2')->orderBy('agenda_discussion.agenda_discussion_id','DESC')->get(); 
			
			/* $find_board_id =  DB::table('agenda_items')->select('a_agenda_id')->where('a_agenda_item_id',$request->id)->first();			
			$data['find_created_barista'] =  DB::table('boards')->select('meeting_by')->where('meeting_id',$find_board_id->a_agenda_id)->first();*/
			$data['user_info'] = $this->userdetails(); 
			
						
		return view('user/getallactions',$data);
	}	
	
	public function removeactionsid(Request $request)
	{
		$this->updateusertime();
		DB::table('agenda_discussion')->where('agenda_discussion_id',$request->id)->delete();
		return 1;
	}
	
	public function startthismeeting(Request $request)
	{		
		$this->updateusertime();
		$values = array('meeting_start_status' => '1');
		DB::table('boards')->where([["meeting_id","=",$request->id]])->update($values);	
		return 1;	
	}
	
	public function endthismeeting(Request $request)
	{		
		$this->updateusertime();
		$values = array('meeting_start_status' => '2');
		DB::table('boards')->where([["meeting_id","=",$request->id]])->update($values);	
		return 1;	
	}	
	
	// create agenda pdf
	
	public function createagendapdf(Request $request)
	{
		$this->updateusertime();
       // This  $data array will be passed to our PDF blade       
	  	$tinfo = time();

		$data['ainfo'] = $request->action_info;

		$data['datedetails'] = 0;
		$data['meeting_by'] = DB::table('boards')->where('meeting_id',$request->current_mid)->first();
		$data['agenda_meeting_details'] = DB::table('agenda_meeting_info')->where('agenda_meeting_id',$request->current_mid)->first();
		
		$data['barista_info'] = DB::table('siteusers')->where('user_id',$data['meeting_by']->meeting_by)->first();
		$data['par_info'] = DB::table('attendees_request')->where('rboardid',$data['meeting_by']->meeting_id)->get();
		
		$data['agenda_allitems'] = DB::table('agenda_items')->where('a_agenda_id',$request->current_mid)->get();
		
		
		$itemidsall=array();
		$loopvaluesall = DB::table('agenda_items')->where('a_agenda_id',$request->current_mid)->get();
		foreach($loopvaluesall as $lp)
		{
			array_push($itemidsall,$lp->a_agenda_item_id);
		}
		$data['allitemi_ds'] = $itemidsall;

		$data['agenda_actions'] = DB::table('agenda_discussion')->whereIn('agenda_for_item_id',$data['allitemi_ds'])->where('agenda_lna','2')->get();
		$data['agenda_notes'] = DB::table('agenda_discussion')->whereIn('agenda_for_item_id',$data['allitemi_ds'])->where('agenda_lna','1')->get();
				
				
		// if any guest joined
		$rr_no = $data['meeting_by']->meeting_rand;
		$data['guest_count'] = DB::table('siteusers')->where('user_emailid','LIKE','%'.$rr_no.'%')->count();
		$checkanyguestcount = DB::table('siteusers')->where('user_emailid','LIKE','%'.$rr_no.'%')->count();
		if($checkanyguestcount != 0)
		{
			$data['showguests'] = 1; 
			$data['guest_info'] = DB::table('siteusers')->where('user_emailid','LIKE','%'.$rr_no.'%')->get();
		}
		else
		{
			$data['showguests'] = 0; 
		}
		// if any guest joined
		
								
		
        $pdf = PDF::loadView('user/agendapdf_view', $data);
		$path = public_path('pdf/');  
		$fileName =  'agenda-session-summary-'.$tinfo.'.' . 'pdf' ;
		$pdf->save($path . '/' . $fileName);
        return $fileName;
		
	}
	
	
// create agenda sorting
	public function agenda_sorting(Request $request)
	{
	
		$this->updateusertime();
		/*echo "<pre>";
		print_r($data['allitemi_ds']);
		exit()*/;
			
		$id_ary = $request->item;
		$itemcounts = count($id_ary);
		for($i=0;$i<$itemcounts;$i++) 
		{
		$k=$i+1;
		$values = array('a_order_by' => $k);
		DB::table('agenda_items')->where([["a_agenda_item_id","=",$id_ary[$i]]])->update($values);
		}
		// for timing
		
		$itemidsall=array();
		$loopvaluesall = DB::table('agenda_items')->where('a_agenda_id',$request->id)->orderBy('a_order_by','ASC')->get();
		foreach($loopvaluesall as $lp)
		{
			array_push($itemidsall,$lp->a_agenda_item_id);
		}
		$data['allitemi_ds'] = $itemidsall;
		
				
		$data['newagendaitems'] = DB::table('agenda_items')->where('a_agenda_id',$request->id)->orderBy('a_order_by','ASC')->get();
		$m=1;$n=-1;
		foreach($data['newagendaitems'] as $naitems)
		{
		if($m == 1)
		{
		$data['agenda_meeting_info'] = DB::table('agenda_meeting_info')->where('agenda_meeting_id',$request->id)->first();
		$curtime = $data['agenda_meeting_info']->agenda_start_time;			
		$curlength = $naitems->a_agenda_item_length;
		$values3 = array('a_agenda_item_time' => $curtime);
		DB::table('agenda_items')->where([["a_agenda_item_id","=",$naitems->a_agenda_item_id]])->update($values3);						
		}
		else
		{ 
		$l=$m-1;
		$data['newagendaitems2'] = DB::table('agenda_items')->where('a_agenda_item_id',$data['allitemi_ds'][$n])->first();
		$curtime = $data['newagendaitems2']->a_agenda_item_time;
		$curlength = $data['newagendaitems2']->a_agenda_item_length;
		
		$newtime = strtotime($curtime) + ($curlength * 60);
		$next_time = date('H:i', $newtime);	
		
		
		if(count($data['allitemi_ds']) >= $m)
		{
		$values2 = array('a_agenda_item_time' => $next_time);
		DB::table('agenda_items')->where([["a_agenda_item_id","=",$data['allitemi_ds'][$l]]])->update($values2);
		}
		
				
		}	

		
		//$ifexist = DB::table('agenda_items')->where([["a_agenda_item_id","=",$data['allitemi_ds'][$l]]])->count();
		
		/*if($ifexist != 0)
		{
		//echo $data['allitemi_ds'][$l];
		//$values2 = array('a_agenda_item_time' => $next_time);
		//DB::table('agenda_items')->where([["a_agenda_item_id","=",$data['allitemi_ds'][$l]]])->update($values2);
		}*/
				
		//$data['allitems_id'] = DB::table('agenda_items')->select('a_agenda_item_id')->orderBy('a_order_by','ASC')->skip($m)->first();
		/*$data['allitems_id'] = DB::table('agenda_items')->select('a_agenda_item_id')->where('a_agenda_item_id',$data['allitemi_ds'][$l])->first();
		if(count($data['allitems_id']) != 0)
		{		
		$values2 = array('a_agenda_item_time' => $next_time);
		DB::table('agenda_items')->where([["a_agenda_item_id","=",$data['allitems_id']->a_agenda_item_id]])->update($values2);
		}*/	
		$m++; $n++;		
		}
		// for timing	


		$fac_info =  DB::table('agenda_items')->where('a_agenda_id',$request->id)->orderBy('a_order_by','ASC')->get();
		
		$htmlmsg = "";		
		foreach($fac_info as $fs)
		{
		$ddid=$fs->a_agenda_item_id;
		if($fs->a_agenda_item_type == '1')
		{
			$htmlmsg.= "<div class='card' id='item-$ddid' style='background-color:#F2F2F2;cursor:pointer'>";
		}
		else
		{
			$htmlmsg.= "<div class='card' id='item-$ddid' style='background-color:#989898;cursor:pointer'>";
		}		
		$htmlmsg.= "<span class='namesinfo_medium agenda_pressed_edit' align='right' data-id=$ddid>".$fs->a_agenda_item_time."&nbsp;&nbsp;&nbsp;".$fs->a_agenda_item_title."&nbsp;&nbsp;&nbsp;".$fs->a_agenda_item_length."</span></div>";
		}
		$htmlmsg.= '';
		$results=array("count"=>1,"agenda_items"=>$htmlmsg);
		return response()->json($results);
		
			
	}
// create agenda sorting

	// guest choice
	public function guest_choice(Request $request)
	{
		$this->updateusertime();
		$values = array('meeting_no_guests' => $request->id);
		DB::table('boards')->where([["meeting_id","=",$request->mid]])->update($values);	
		return 1;		
	}
	// guest choice	
	
}
